/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.policy.security.jaas;

import java.util.ArrayList;
import java.util.List;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.ConfiguredOperation;
import org.apache.tuscany.sca.assembly.OperationsConfigurator;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.policy.security.jaas.JaasAuthenticationInterceptor;
import org.apache.tuscany.sca.policy.security.jaas.JaasAuthenticationPolicy;
import org.apache.tuscany.sca.provider.PolicyProvider;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaasAuthenticationServicePolicyProvider
implements PolicyProvider {
    private RuntimeComponent component;
    private RuntimeComponentService service;
    private Binding binding;
    private List<Operation> operations = new ArrayList<Operation>();

    public JaasAuthenticationServicePolicyProvider(RuntimeComponent component, RuntimeComponentService service, Binding binding) {
        this.component = component;
        this.service = service;
        this.binding = binding;
        this.operations.addAll(service.getInterfaceContract().getInterface().getOperations());
    }

    private List<JaasAuthenticationPolicy> findPolicies(Operation op) {
        ArrayList<JaasAuthenticationPolicy> polices = new ArrayList<JaasAuthenticationPolicy>();
        for (Operation operation : this.operations) {
            if (operation == null || operation.getName() == null || !operation.getName().equals(op.getName())) continue;
            for (PolicySet ps : operation.getPolicySets()) {
                for (Object p : ps.getPolicies()) {
                    if (!JaasAuthenticationPolicy.class.isInstance(p)) continue;
                    polices.add((JaasAuthenticationPolicy)p);
                }
            }
        }
        if (this.service instanceof OperationsConfigurator) {
            RuntimeComponentService operationsConfigurator = this.service;
            for (ConfiguredOperation cop : operationsConfigurator.getConfiguredOperations()) {
                if (cop == null || cop.getName() == null || !cop.getName().equals(op.getName())) continue;
                for (PolicySet ps : cop.getApplicablePolicySets()) {
                    for (Object p : ps.getPolicies()) {
                        if (!JaasAuthenticationPolicy.class.isInstance(p)) continue;
                        polices.add((JaasAuthenticationPolicy)p);
                    }
                }
            }
        }
        List<PolicySet> policySets = this.service.getPolicySets();
        for (PolicySet ps : policySets) {
            for (Object p : ps.getPolicies()) {
                if (!JaasAuthenticationPolicy.class.isInstance(p)) continue;
                polices.add((JaasAuthenticationPolicy)p);
            }
        }
        return polices;
    }

    @Override
    public Interceptor createInterceptor(Operation operation) {
        List<JaasAuthenticationPolicy> policies = this.findPolicies(operation);
        if (policies == null || policies.isEmpty()) {
            return null;
        }
        return new JaasAuthenticationInterceptor(policies);
    }

    @Override
    public String getPhase() {
        return "service.policy";
    }
}

