/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.policy.util;

import java.util.List;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.policy.util.PolicyHandler;
import org.apache.tuscany.sca.policy.util.PolicyHandlerTuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyHandlerUtils {
    public static PolicyHandler findPolicyHandler(PolicySet policySet, List<PolicyHandlerTuple> policyHandlerClassNames) throws IllegalAccessException, ClassNotFoundException, InstantiationException {
        PolicyHandler handler = null;
        for (PolicyHandlerTuple handlerTuple : policyHandlerClassNames) {
            for (Intent intent : policySet.getProvidedIntents()) {
                if (!intent.getName().equals(handlerTuple.getProvidedIntentName())) continue;
                for (Object policy : policySet.getPolicies()) {
                    if (!policy.getClass().getName().equals(handlerTuple.getPolicyModelClassName())) continue;
                    if (handlerTuple.getAppliesTo() != null) {
                        if (!handlerTuple.getAppliesTo().equals(policySet.getAppliesTo())) continue;
                        handler = (PolicyHandler)handlerTuple.getDeclaration().loadClass().newInstance();
                        handler.setApplicablePolicySet(policySet);
                        return handler;
                    }
                    handler = (PolicyHandler)handlerTuple.getDeclaration().loadClass().newInstance();
                    handler.setApplicablePolicySet(policySet);
                    return handler;
                }
            }
        }
        return handler;
    }
}

