/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.policy.xml;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.monitor.impl.ProblemImpl;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.policy.PolicyFactory;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.policy.xml.PolicyConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicySetProcessor
extends BaseStAXArtifactProcessor
implements StAXArtifactProcessor<PolicySet>,
PolicyConstants {
    private PolicyFactory policyFactory;
    private StAXArtifactProcessor<Object> extensionProcessor;
    private XPathFactory xpathFactory = XPathFactory.newInstance();
    private Monitor monitor;

    public PolicySetProcessor(ModelFactoryExtensionPoint modelFactories, StAXArtifactProcessor<Object> extensionProcessor, Monitor monitor) {
        this.policyFactory = modelFactories.getFactory(PolicyFactory.class);
        this.extensionProcessor = extensionProcessor;
        this.monitor = monitor;
    }

    public PolicySetProcessor(PolicyFactory policyFactory, StAXArtifactProcessor<Object> extensionProcessor, Monitor monitor) {
        this.policyFactory = policyFactory;
        this.extensionProcessor = extensionProcessor;
        this.monitor = monitor;
    }

    private void error(String message, Object model, Exception ex) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "policy-xml-validation-messages", Problem.Severity.ERROR, model, message, ex);
            this.monitor.problem(problem);
        }
    }

    private void error(String message, Object model, Object ... messageParameters) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "policy-xml-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            this.monitor.problem(problem);
        }
    }

    @Override
    public PolicySet read(XMLStreamReader reader) throws ContributionReadException, XMLStreamException {
        PolicySet policySet = null;
        String policySetName = reader.getAttributeValue(null, "name");
        String appliesTo = reader.getAttributeValue(null, "appliesTo");
        if (policySetName == null || appliesTo == null) {
            if (policySetName == null) {
                this.error("PolicySetNameMissing", (Object)reader, new Object[0]);
            }
            if (appliesTo == null) {
                this.error("PolicySetAppliesToMissing", (Object)reader, new Object[0]);
            }
            return policySet;
        }
        policySet = this.policyFactory.createPolicySet();
        policySet.setName(new QName(policySetName));
        String alwaysAppliesTo = reader.getAttributeValue("http://tuscany.apache.org/xmlns/sca/1.0", "alwaysAppliesTo");
        if (appliesTo != null && !appliesTo.startsWith("/")) {
            appliesTo = "//" + appliesTo;
        }
        if (alwaysAppliesTo != null && !alwaysAppliesTo.startsWith("/")) {
            alwaysAppliesTo = "//" + alwaysAppliesTo;
        }
        policySet.setAppliesTo(appliesTo);
        policySet.setAlwaysAppliesTo(alwaysAppliesTo);
        XPath path = this.xpathFactory.newXPath();
        path.setNamespaceContext(reader.getNamespaceContext());
        try {
            if (appliesTo != null) {
                policySet.setAppliesToXPathExpression(path.compile(appliesTo));
            }
            if (alwaysAppliesTo != null) {
                policySet.setAlwaysAppliesToXPathExpression(path.compile(alwaysAppliesTo));
            }
        }
        catch (XPathExpressionException e) {
            ContributionReadException ce = new ContributionReadException(e);
            this.error("ContributionReadException", (Object)policySet, ce);
        }
        this.readProvidedIntents(policySet, reader);
        int event = reader.getEventType();
        QName name = null;
        reader.next();
        while (reader.hasNext()) {
            event = reader.getEventType();
            switch (event) {
                case 1: {
                    name = reader.getName();
                    if (POLICY_INTENT_MAP_QNAME.equals(name)) {
                        Intent mappedIntent = this.policyFactory.createIntent();
                        String provides = reader.getAttributeValue(null, "provides");
                        if (provides != null) {
                            mappedIntent.setName(this.getQName(reader, "provides"));
                            if (policySet.getProvidedIntents().contains(mappedIntent)) {
                                this.readIntentMap(reader, policySet, mappedIntent);
                                break;
                            }
                            this.error("IntentNotSpecified", (Object)policySet, policySetName);
                            break;
                        }
                        this.error("IntentMapProvidesMissing", (Object)reader, policySetName);
                        break;
                    }
                    if (POLICY_SET_REFERENCE_QNAME.equals(name)) {
                        PolicySet referredPolicySet = this.policyFactory.createPolicySet();
                        String referencename = reader.getAttributeValue(null, "name");
                        if (referencename != null) {
                            referredPolicySet.setName(this.getQName(reader, "name"));
                            policySet.getReferencedPolicySets().add(referredPolicySet);
                            break;
                        }
                        this.error("PolicySetReferenceNameMissing", (Object)reader, policySetName);
                        break;
                    }
                    Object extension = this.extensionProcessor.read(reader);
                    if (extension == null) break;
                    policySet.getPolicies().add(extension);
                }
            }
            if (event == 2 && POLICY_SET_QNAME.equals(reader.getName())) break;
            if (!reader.hasNext()) continue;
            reader.next();
        }
        return policySet;
    }

    public void readIntentMap(XMLStreamReader reader, PolicySet policySet, Intent mappedIntent) throws ContributionReadException {
        QName name = reader.getName();
        Map<Intent, List<Object>> mappedPolicies = policySet.getMappedPolicies();
        if (POLICY_INTENT_MAP_QNAME.equals(name)) {
            String defaultQualifier = this.getString(reader, "default");
            String qualifierName = null;
            String qualfiedIntentName = null;
            Intent qualifiedIntent = null;
            int event = reader.getEventType();
            try {
                reader.next();
                while (reader.hasNext()) {
                    event = reader.getEventType();
                    switch (event) {
                        case 1: {
                            name = reader.getName();
                            if (POLICY_INTENT_MAP_QUALIFIER_QNAME.equals(name)) {
                                qualifierName = this.getString(reader, "name");
                                if (qualifierName != null) {
                                    qualfiedIntentName = mappedIntent.getName().getLocalPart() + "." + qualifierName;
                                    qualifiedIntent = this.policyFactory.createIntent();
                                    qualifiedIntent.setName(new QName(mappedIntent.getName().getNamespaceURI(), qualfiedIntentName));
                                    break;
                                }
                                this.error("QualifierNameMissing", (Object)reader, policySet.getName());
                                break;
                            }
                            if (POLICY_INTENT_MAP_QNAME.equals(name)) {
                                QName providedIntent = this.getQName(reader, "provides");
                                if (qualifierName.equals(providedIntent.getLocalPart())) {
                                    this.readIntentMap(reader, policySet, qualifiedIntent);
                                    break;
                                }
                                this.error("IntentMapDoesNotMatch", (Object)providedIntent, providedIntent, qualifierName, policySet);
                                break;
                            }
                            Object extension = this.extensionProcessor.read(reader);
                            if (extension == null || qualifiedIntent == null) break;
                            List<Object> policyList = mappedPolicies.get(qualifiedIntent);
                            if (policyList == null) {
                                policyList = new ArrayList<Object>();
                                mappedPolicies.put(qualifiedIntent, policyList);
                                if (qualifierName.equals(defaultQualifier)) {
                                    mappedPolicies.put(mappedIntent, policyList);
                                }
                            }
                            policyList.add(extension);
                            break;
                        }
                        case 2: {
                            if (!POLICY_INTENT_MAP_QNAME.equals(reader.getName()) || defaultQualifier == null) break;
                            String qualifiedIntentName = mappedIntent.getName().getLocalPart() + "." + defaultQualifier;
                            Intent defaultQualifiedIntent = this.policyFactory.createIntent();
                            defaultQualifiedIntent.setName(new QName(mappedIntent.getName().getNamespaceURI(), qualifiedIntentName));
                            List<Object> policyList = mappedPolicies.get(defaultQualifiedIntent);
                            if (policyList != null) {
                                mappedPolicies.put(mappedIntent, policyList);
                            } else {
                                this.error("UnableToMapPolicies", mappedPolicies, mappedIntent, policySet);
                            }
                            defaultQualifier = null;
                        }
                    }
                    if (event != 2 || !POLICY_INTENT_MAP_QNAME.equals(reader.getName())) {
                        if (!reader.hasNext()) continue;
                        reader.next();
                        continue;
                    }
                    break;
                }
            }
            catch (XMLStreamException e) {
                ContributionReadException ce = new ContributionReadException(e);
                this.error("ContributionReadException", (Object)reader, ce);
                throw ce;
            }
        }
    }

    @Override
    public void write(PolicySet policySet, XMLStreamWriter writer) throws ContributionWriteException, XMLStreamException {
        writer.writeStartElement("http://www.osoa.org/xmlns/sca/1.0", "policySet");
        writer.writeNamespace(policySet.getName().getPrefix(), policySet.getName().getNamespaceURI());
        writer.writeAttribute("name", policySet.getName().getPrefix() + ":" + policySet.getName().getLocalPart());
        writer.writeAttribute("appliesTo", policySet.getAppliesTo());
        writer.writeAttribute("http://tuscany.apache.org/xmlns/sca/1.0", "alwaysAppliesTo", policySet.getAlwaysAppliesTo());
        this.writeProvidedIntents(policySet, writer);
        writer.writeEndElement();
    }

    private void readProvidedIntents(PolicySet policySet, XMLStreamReader reader) {
        String value = reader.getAttributeValue(null, "provides");
        if (value != null) {
            List<Intent> providedIntents = policySet.getProvidedIntents();
            StringTokenizer tokens = new StringTokenizer(value);
            while (tokens.hasMoreTokens()) {
                QName qname = this.getQNameValue(reader, tokens.nextToken());
                Intent intent = this.policyFactory.createIntent();
                intent.setName(qname);
                providedIntents.add(intent);
            }
        }
    }

    private void writeProvidedIntents(PolicySet policySet, XMLStreamWriter writer) throws XMLStreamException {
        if (policySet.getProvidedIntents() != null && policySet.getProvidedIntents().size() > 0) {
            StringBuffer sb = new StringBuffer();
            for (Intent providedIntents : policySet.getProvidedIntents()) {
                sb.append(providedIntents.getName());
                sb.append(" ");
            }
            writer.writeAttribute("provides", sb.toString());
        }
    }

    private void resolvePolicies(PolicySet policySet, ModelResolver resolver) throws ContributionResolveException {
        boolean unresolved = false;
        if (policySet != null) {
            for (Object o : policySet.getPolicies()) {
                this.extensionProcessor.resolve(o, resolver);
            }
            policySet.setUnresolved(unresolved);
        }
    }

    @Override
    public QName getArtifactType() {
        return POLICY_SET_QNAME;
    }

    @Override
    public Class<PolicySet> getModelType() {
        return PolicySet.class;
    }

    private void resolveProvidedIntents(PolicySet policySet, ModelResolver resolver) throws ContributionResolveException {
        if (policySet != null) {
            ArrayList<Intent> providedIntents = new ArrayList<Intent>();
            for (Intent providedIntent : policySet.getProvidedIntents()) {
                if (providedIntent.isUnresolved()) {
                    Intent resolvedProvidedIntent = resolver.resolveModel(Intent.class, providedIntent);
                    if (!resolvedProvidedIntent.isUnresolved()) {
                        providedIntents.add(resolvedProvidedIntent);
                        continue;
                    }
                    this.error("ProvidedIntentNotFound", (Object)policySet, providedIntent, policySet);
                    return;
                }
                providedIntents.add(providedIntent);
            }
            policySet.getProvidedIntents().clear();
            policySet.getProvidedIntents().addAll(providedIntents);
        }
    }

    private void resolveIntentsInMappedPolicies(PolicySet policySet, ModelResolver resolver) throws ContributionResolveException {
        Hashtable<Intent, List<Object>> mappedPolicies = new Hashtable<Intent, List<Object>>();
        for (Map.Entry<Intent, List<Object>> entry : policySet.getMappedPolicies().entrySet()) {
            Intent mappedIntent = entry.getKey();
            if (mappedIntent.isUnresolved()) {
                Intent resolvedMappedIntent = resolver.resolveModel(Intent.class, mappedIntent);
                if (!resolvedMappedIntent.isUnresolved()) {
                    mappedPolicies.put(resolvedMappedIntent, entry.getValue());
                    continue;
                }
                this.error("MappedIntentNotFound", (Object)policySet, mappedIntent, policySet);
                return;
            }
            mappedPolicies.put(mappedIntent, entry.getValue());
        }
        policySet.getMappedPolicies().clear();
        policySet.getMappedPolicies().putAll(mappedPolicies);
    }

    private void resolveReferredPolicySets(PolicySet policySet, ModelResolver resolver) throws ContributionResolveException {
        ArrayList<PolicySet> referredPolicySets = new ArrayList<PolicySet>();
        for (PolicySet referredPolicySet : policySet.getReferencedPolicySets()) {
            if (referredPolicySet.isUnresolved()) {
                PolicySet resolvedReferredPolicySet = resolver.resolveModel(PolicySet.class, referredPolicySet);
                if (!resolvedReferredPolicySet.isUnresolved()) {
                    referredPolicySets.add(resolvedReferredPolicySet);
                    continue;
                }
                this.error("ReferredPolicySetNotFound", (Object)policySet, referredPolicySet, policySet);
                return;
            }
            referredPolicySets.add(referredPolicySet);
        }
        policySet.getReferencedPolicySets().clear();
        policySet.getReferencedPolicySets().addAll(referredPolicySets);
    }

    private void includeReferredPolicySets(PolicySet policySet, PolicySet referredPolicySet) {
        for (PolicySet furtherReferredPolicySet : referredPolicySet.getReferencedPolicySets()) {
            this.includeReferredPolicySets(referredPolicySet, furtherReferredPolicySet);
        }
        policySet.getPolicies().addAll(referredPolicySet.getPolicies());
        policySet.getMappedPolicies().putAll(referredPolicySet.getMappedPolicies());
    }

    @Override
    public void resolve(PolicySet policySet, ModelResolver resolver) throws ContributionResolveException {
        this.resolveProvidedIntents(policySet, resolver);
        this.resolveIntentsInMappedPolicies(policySet, resolver);
        this.resolveReferredPolicySets(policySet, resolver);
        for (PolicySet referredPolicySet : policySet.getReferencedPolicySets()) {
            this.includeReferredPolicySets(policySet, referredPolicySet);
        }
        if (policySet.isUnresolved()) {
            this.resolvePolicies(policySet, resolver);
        }
    }
}

