/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.workspace.processor.impl;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.contribution.Artifact;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.ContributionFactory;
import org.apache.tuscany.sca.contribution.ContributionMetadata;
import org.apache.tuscany.sca.contribution.DefaultExport;
import org.apache.tuscany.sca.contribution.DefaultImport;
import org.apache.tuscany.sca.contribution.Export;
import org.apache.tuscany.sca.contribution.Import;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.ExtensibleStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.ExtensibleURLArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessorExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.URLArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.URLArtifactProcessorExtensionPoint;
import org.apache.tuscany.sca.contribution.resolver.ClassReference;
import org.apache.tuscany.sca.contribution.resolver.DefaultModelResolver;
import org.apache.tuscany.sca.contribution.resolver.ExtensibleModelResolver;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.resolver.ModelResolverExtensionPoint;
import org.apache.tuscany.sca.contribution.scanner.ContributionScanner;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.definitions.SCADefinitions;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.policy.IntentAttachPointType;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.workspace.scanner.impl.DirectoryContributionScanner;
import org.apache.tuscany.sca.workspace.scanner.impl.JarContributionScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContributionContentProcessor
implements URLArtifactProcessor<Contribution> {
    private ExtensionPointRegistry extensionPoints;
    private ContributionFactory contributionFactory;
    private ModelResolverExtensionPoint modelResolvers;
    private ModelFactoryExtensionPoint modelFactories;
    private URLArtifactProcessor<Object> artifactProcessor;
    private StAXArtifactProcessor<Object> extensionProcessor;
    private UtilityExtensionPoint utilities;
    private Monitor monitor = null;
    private ModelResolver policyDefinitionsResolver = null;
    private List<SCADefinitions> policyDefinitions = null;
    private static final String COMPOSITE_FILE_EXTN = ".composite";

    public ContributionContentProcessor(ExtensionPointRegistry extensionPoints, Monitor monitor) {
        this.extensionPoints = extensionPoints;
        this.modelFactories = extensionPoints.getExtensionPoint(ModelFactoryExtensionPoint.class);
        this.modelResolvers = extensionPoints.getExtensionPoint(ModelResolverExtensionPoint.class);
        ContributionContentProcessor.hackResolvers(this.modelResolvers);
        this.monitor = monitor;
        URLArtifactProcessorExtensionPoint artifactProcessors = extensionPoints.getExtensionPoint(URLArtifactProcessorExtensionPoint.class);
        this.artifactProcessor = new ExtensibleURLArtifactProcessor(artifactProcessors, this.monitor);
        StAXArtifactProcessorExtensionPoint staxProcessors = extensionPoints.getExtensionPoint(StAXArtifactProcessorExtensionPoint.class);
        XMLInputFactory inputFactory = this.modelFactories.getFactory(XMLInputFactory.class);
        XMLOutputFactory outputFactory = this.modelFactories.getFactory(XMLOutputFactory.class);
        this.extensionProcessor = new ExtensibleStAXArtifactProcessor(staxProcessors, inputFactory, outputFactory, monitor);
        this.contributionFactory = this.modelFactories.getFactory(ContributionFactory.class);
    }

    public ContributionContentProcessor(ExtensionPointRegistry extensionPoints, Monitor monitor, ModelResolver policyDefinitionsResolver, List<SCADefinitions> policyDefinitions) {
        this(extensionPoints, monitor);
        this.policyDefinitionsResolver = policyDefinitionsResolver;
        this.policyDefinitions = policyDefinitions;
    }

    @Override
    public String getArtifactType() {
        return ".contribution/content";
    }

    @Override
    public Class<Contribution> getModelType() {
        return Contribution.class;
    }

    @Override
    public Contribution read(URL parentURL, URI contributionURI, URL contributionURL) throws ContributionReadException {
        Object model;
        Artifact artifact;
        URL artifactURL;
        Contribution contribution = this.contributionFactory.createContribution();
        contribution.setURI(contributionURI.toString());
        contribution.setLocation(contributionURL.toString());
        ExtensibleModelResolver modelResolver = this.policyDefinitionsResolver != null ? new ExtensibleModelResolver(contribution, this.extensionPoints, this.modelResolvers, this.modelFactories, this.policyDefinitionsResolver) : new ExtensibleModelResolver(contribution, this.extensionPoints);
        contribution.setModelResolver(modelResolver);
        contribution.setUnresolved(true);
        ContributionScanner scanner = "file".equals(contributionURL.getProtocol()) && new File(contributionURL.getFile()).isDirectory() ? new DirectoryContributionScanner() : new JarContributionScanner();
        List<Artifact> artifacts = contribution.getArtifacts();
        boolean contributionMetadata = false;
        ArrayList<String> compositeURIs = new ArrayList<String>();
        List<String> artifactURIs = scanner.getArtifacts(contributionURL);
        for (String artifactURI : artifactURIs) {
            if (artifactURI.endsWith(COMPOSITE_FILE_EXTN)) {
                compositeURIs.add(artifactURI);
                continue;
            }
            artifactURL = scanner.getArtifactURL(contributionURL, artifactURI);
            artifact = this.contributionFactory.createArtifact();
            artifact.setURI(artifactURI);
            artifact.setLocation(artifactURL.toString());
            artifacts.add(artifact);
            modelResolver.addModel(artifact);
            model = this.artifactProcessor.read(contributionURL, URI.create(artifactURI), artifactURL);
            if (model == null) continue;
            artifact.setModel(model);
            modelResolver.addModel(model);
            if (this.policyDefinitionsResolver != null) {
                this.addPolicyDefinitions(model);
            }
            if (!(model instanceof ContributionMetadata)) continue;
            contributionMetadata = true;
            ContributionMetadata c = (ContributionMetadata)model;
            contribution.getImports().addAll(c.getImports());
            contribution.getExports().addAll(c.getExports());
            contribution.getDeployables().addAll(c.getDeployables());
            contribution.getExtensions().addAll(c.getExtensions());
            contribution.getAttributeExtensions().addAll(c.getAttributeExtensions());
        }
        for (String artifactURI : compositeURIs) {
            artifactURL = scanner.getArtifactURL(contributionURL, artifactURI);
            artifact = this.contributionFactory.createArtifact();
            artifact.setURI(artifactURI);
            artifact.setLocation(artifactURL.toString());
            artifacts.add(artifact);
            modelResolver.addModel(artifact);
            model = this.artifactProcessor.read(contributionURL, URI.create(artifactURI), artifactURL);
            if (model == null) continue;
            artifact.setModel(model);
            modelResolver.addModel(model);
        }
        if (!contributionMetadata) {
            for (Artifact artifact2 : artifacts) {
                if (!(artifact2.getModel() instanceof Composite)) continue;
                contribution.getDeployables().add((Composite)artifact2.getModel());
            }
            DefaultImport defaultImport = this.contributionFactory.createDefaultImport();
            defaultImport.setModelResolver(new DefaultModelResolver());
            contribution.getImports().add(defaultImport);
            DefaultExport defaultExport = this.contributionFactory.createDefaultExport();
            contribution.getExports().add(defaultExport);
        }
        return contribution;
    }

    @Override
    public void resolve(Contribution contribution, ModelResolver resolver) throws ContributionResolveException {
        Object model;
        ModelResolver contributionResolver = contribution.getModelResolver();
        contribution.setUnresolved(false);
        contributionResolver.addModel(contribution);
        for (Export export : contribution.getExports()) {
            if (export instanceof DefaultExport) {
                export.setModelResolver(contributionResolver);
                continue;
            }
            this.extensionProcessor.resolve(export, contributionResolver);
        }
        for (Import import_ : contribution.getImports()) {
            this.extensionProcessor.resolve(import_, contributionResolver);
        }
        ArrayList<Artifact> composites = new ArrayList<Artifact>();
        for (Artifact artifact : contribution.getArtifacts()) {
            if (artifact.getURI().endsWith(COMPOSITE_FILE_EXTN)) {
                composites.add(artifact);
                continue;
            }
            model = artifact.getModel();
            if (model == null) continue;
            try {
                this.artifactProcessor.resolve(model, contributionResolver);
            }
            catch (ContributionResolveException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ContributionResolveException(e);
            }
        }
        for (Artifact artifact : composites) {
            model = artifact.getModel();
            if (model == null) continue;
            try {
                this.artifactProcessor.resolve(model, contributionResolver);
            }
            catch (ContributionResolveException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ContributionResolveException(e);
            }
        }
        List<Composite> deployables = contribution.getDeployables();
        int n = deployables.size();
        for (int i = 0; i < n; ++i) {
            Composite deployable = deployables.get(i);
            Composite resolved = contributionResolver.resolveModel(Composite.class, deployable);
            if (resolved == deployable) continue;
            deployables.set(i, resolved);
        }
    }

    private static void hackResolvers(ModelResolverExtensionPoint modelResolvers) {
        Class<? extends ModelResolver> resolverClass = modelResolvers.getResolver(ClassReference.class);
        if (resolverClass == null || !resolverClass.getName().equals("org.apache.tuscany.sca.contribution.java.impl.ClassLoaderModelResolver")) {
            try {
                Class<?> loaderResolverClass = Class.forName("org.apache.tuscany.sca.contribution.java.impl.ClassLoaderModelResolver", true, ContributionContentProcessor.class.getClassLoader());
                modelResolvers.addResolver(ClassReference.class, loaderResolverClass);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    private void addPolicyDefinitions(Object model) {
        if (model instanceof SCADefinitions) {
            this.policyDefinitions.add((SCADefinitions)model);
            SCADefinitions definitions = (SCADefinitions)model;
            for (Intent intent : definitions.getPolicyIntents()) {
                this.policyDefinitionsResolver.addModel(intent);
            }
            for (PolicySet policySet : definitions.getPolicySets()) {
                this.policyDefinitionsResolver.addModel(policySet);
            }
            for (IntentAttachPointType attachPointType : definitions.getBindingTypes()) {
                this.policyDefinitionsResolver.addModel(attachPointType);
            }
            for (IntentAttachPointType attachPointType : definitions.getImplementationTypes()) {
                this.policyDefinitionsResolver.addModel(attachPointType);
            }
            for (Object binding : definitions.getBindings()) {
                this.policyDefinitionsResolver.addModel(binding);
            }
        }
    }
}

