/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.workspace.scanner.impl;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.tuscany.sca.contribution.scanner.ContributionScanner;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarContributionScanner
implements ContributionScanner {
    @Override
    public String getContributionType() {
        return "application/x-compressed";
    }

    @Override
    public URL getArtifactURL(URL contributionURL, String artifact) throws ContributionReadException {
        try {
            URL url = contributionURL.toString().startsWith("jar:") ? new URL(contributionURL, artifact.toString()) : new URL("jar:" + contributionURL.toExternalForm() + "!/" + artifact);
            return url;
        }
        catch (MalformedURLException e) {
            throw new ContributionReadException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getArtifacts(URL contributionURL) throws ContributionReadException {
        ArrayList<String> arrayList;
        URLConnection connection = contributionURL.openConnection();
        connection.setUseCaches(false);
        JarInputStream jar = new JarInputStream(connection.getInputStream());
        try {
            ArrayList<String> artifacts;
            JarEntry entry;
            HashSet<String> names = new HashSet<String>();
            while ((entry = jar.getNextJarEntry()) != null) {
                int s;
                String name = entry.getName();
                if (name.length() == 0 || name.startsWith(".")) continue;
                if (name.endsWith("/")) {
                    name = name.substring(0, name.length() - 1);
                }
                if (names.contains(name)) continue;
                names.add(name);
                while ((name = (s = name.lastIndexOf(47)) == -1 ? "" : name.substring(0, s)).length() != 0 && !names.contains(name)) {
                    names.add(name);
                }
            }
            arrayList = artifacts = new ArrayList<String>(names);
        }
        catch (Throwable throwable) {
            try {
                jar.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new ContributionReadException(e);
            }
        }
        jar.close();
        return arrayList;
    }
}

