/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.xsd.xml;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tuscany.sca.contribution.Artifact;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.contribution.DefaultImport;
import org.apache.tuscany.sca.contribution.Import;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.namespace.NamespaceImport;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionRuntimeException;
import org.apache.tuscany.sca.xsd.DefaultXSDFactory;
import org.apache.tuscany.sca.xsd.XSDFactory;
import org.apache.tuscany.sca.xsd.XSDefinition;
import org.apache.tuscany.sca.xsd.impl.XSDefinitionImpl;
import org.apache.tuscany.sca.xsd.xml.XMLDocumentHelper;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaInclude;
import org.apache.ws.commons.schema.XmlSchemaObject;
import org.apache.ws.commons.schema.resolver.URIResolver;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSDModelResolver
implements ModelResolver {
    private static final String AGGREGATED_XSD = "http://tuscany.apache.org/aggregated.xsd";
    private XSDFactory factory;
    private Contribution contribution;
    private Map<String, List<XSDefinition>> map = new HashMap<String, List<XSDefinition>>();
    private XmlSchemaCollection schemaCollection;

    public XSDModelResolver(Contribution contribution, ModelFactoryExtensionPoint modelFactories) {
        this.contribution = contribution;
        this.schemaCollection = new XmlSchemaCollection();
        this.schemaCollection.setSchemaResolver((URIResolver)new URIResolverImpl(contribution));
        this.factory = new DefaultXSDFactory();
    }

    @Override
    public void addModel(Object resolved) {
        XSDefinition definition = (XSDefinition)resolved;
        List<XSDefinition> list = this.map.get(definition.getNamespace());
        if (list == null) {
            list = new ArrayList<XSDefinition>();
            this.map.put(definition.getNamespace(), list);
        }
        list.add(definition);
    }

    @Override
    public Object removeModel(Object resolved) {
        XSDefinition definition = (XSDefinition)resolved;
        List<XSDefinition> list = this.map.get(definition.getNamespace());
        if (list == null) {
            return null;
        }
        return list.remove(definition);
    }

    @Override
    public <T> T resolveModel(Class<T> modelClass, T unresolved) {
        int index;
        XSDefinition definition = (XSDefinition)unresolved;
        String namespace = definition.getNamespace();
        List<XSDefinition> list = this.map.get(namespace);
        XSDefinition modelXSD = null;
        if (list != null && definition.getDocument() != null && (index = list.indexOf(definition)) != -1) {
            modelXSD = list.get(index);
            modelXSD.setDocument(definition.getDocument());
        }
        if (list == null && definition.getDocument() != null) {
            list = new ArrayList<XSDefinition>();
            list.add(definition);
            this.map.put(namespace, list);
        }
        XSDefinition resolved = null;
        try {
            resolved = this.aggregate(list);
        }
        catch (ContributionRuntimeException e) {
            throw new ContributionRuntimeException(e);
        }
        if (resolved != null && !resolved.isUnresolved()) {
            if (definition.isUnresolved() && definition.getSchema() == null && modelXSD != null) {
                definition.setSchema(modelXSD.getSchema());
                definition.setSchemaCollection(modelXSD.getSchemaCollection());
                definition.setUnresolved(false);
            }
            return modelClass.cast(resolved);
        }
        for (Import import_ : this.contribution.getImports()) {
            NamespaceImport namespaceImport;
            if (!(import_ instanceof NamespaceImport ? (namespaceImport = (NamespaceImport)import_).getNamespace().equals(namespace) && !(resolved = namespaceImport.getModelResolver().resolveModel(XSDefinition.class, (XSDefinition)unresolved)).isUnresolved() : import_ instanceof DefaultImport && !(resolved = import_.getModelResolver().resolveModel(XSDefinition.class, (XSDefinition)unresolved)).isUnresolved())) continue;
            return modelClass.cast(resolved);
        }
        return modelClass.cast(unresolved);
    }

    private void loadOnDemand(XSDefinition definition) throws ContributionRuntimeException {
        if (definition.getSchema() != null) {
            return;
        }
        if (definition.getDocument() != null) {
            String uri = null;
            if (definition.getLocation() != null) {
                uri = definition.getLocation().toString();
            }
            XmlSchema schema = null;
            try {
                schema = this.schemaCollection.read(definition.getDocument(), uri, null);
            }
            catch (RuntimeException e) {
                Throwable cause;
                for (cause = e; cause.getCause() != null && cause != cause.getCause(); cause = cause.getCause()) {
                }
                throw new ContributionRuntimeException(cause);
            }
            definition.setSchemaCollection(this.schemaCollection);
            definition.setSchema(schema);
            definition.setUnresolved(false);
        } else if (definition.getLocation() != null) {
            if (definition.getLocation().getFragment() != null) {
                return;
            }
            XmlSchema schema = null;
            for (XmlSchema d : this.schemaCollection.getXmlSchemas()) {
                if (!this.isSameNamespace(d.getTargetNamespace(), definition.getNamespace()) || !d.getSourceURI().equals(definition.getLocation().toString())) continue;
                schema = d;
                break;
            }
            if (schema == null) {
                InputSource xsd = null;
                try {
                    xsd = XMLDocumentHelper.getInputSource(definition.getLocation().toURL());
                }
                catch (IOException e) {
                    throw new ContributionRuntimeException(e);
                }
                try {
                    schema = this.schemaCollection.read(xsd, null);
                }
                catch (RuntimeException e) {
                    Throwable cause;
                    for (cause = e; cause.getCause() != null && cause != cause.getCause(); cause = cause.getCause()) {
                    }
                    throw new ContributionRuntimeException(cause);
                }
            }
            definition.setSchemaCollection(this.schemaCollection);
            definition.setSchema(schema);
        }
    }

    private boolean isSameNamespace(String ns1, String ns2) {
        if (ns1 == null) {
            return ns2 == null;
        }
        return ns1.equals(ns2);
    }

    private XSDefinition aggregate(List<XSDefinition> definitions) throws ContributionRuntimeException {
        if (definitions == null || definitions.size() == 0) {
            return null;
        }
        if (definitions.size() == 1) {
            XSDefinition d = definitions.get(0);
            this.loadOnDemand(d);
            return d;
        }
        XSDefinition aggregated = this.factory.createXSDefinition();
        for (XSDefinition d : definitions) {
            this.loadOnDemand(d);
        }
        String ns = definitions.get(0).getNamespace();
        XmlSchema facade = null;
        for (XmlSchema s : this.schemaCollection.getXmlSchema(AGGREGATED_XSD)) {
            if (!ns.equals(s.getTargetNamespace())) continue;
            facade = s;
            break;
        }
        if (facade == null) {
            facade = new XmlSchema(ns, AGGREGATED_XSD, this.schemaCollection);
        }
        for (XmlSchema d : this.schemaCollection.getXmlSchemas()) {
            if (!ns.equals(d.getTargetNamespace()) || d == facade) continue;
            XmlSchemaInclude include = new XmlSchemaInclude();
            include.setSchema(d);
            include.setSourceURI(d.getSourceURI());
            include.setSchemaLocation(d.getSourceURI());
            facade.getIncludes().add((XmlSchemaObject)include);
            facade.getItems().add((XmlSchemaObject)include);
        }
        aggregated.setUnresolved(true);
        aggregated.setSchema(facade);
        aggregated.setNamespace(ns);
        aggregated.setAggregatedDefinitions(definitions);
        aggregated.setUnresolved(false);
        return aggregated;
    }

    public static class URIResolverImpl
    implements URIResolver {
        private Contribution contribution;

        public URIResolverImpl(Contribution contribution) {
            this.contribution = contribution;
        }

        public InputSource resolveEntity(String targetNamespace, String schemaLocation, String baseUri) {
            try {
                if (schemaLocation == null) {
                    return null;
                }
                URL url = null;
                if (schemaLocation.startsWith("/")) {
                    String uri = schemaLocation.substring(1);
                    for (Artifact a : this.contribution.getArtifacts()) {
                        if (!a.getURI().equals(uri)) continue;
                        url = new URL(a.getLocation());
                        break;
                    }
                    if (url == null) {
                        return new InputSource(schemaLocation);
                    }
                } else {
                    url = new URL(new URL(baseUri), schemaLocation);
                }
                return XMLDocumentHelper.getInputSource(url);
            }
            catch (IOException e) {
                try {
                    for (Artifact artifact : this.contribution.getArtifacts()) {
                        String artifactNamespace;
                        if (!(artifact.getModel() instanceof XSDefinitionImpl) || !targetNamespace.equals(artifactNamespace = ((XSDefinitionImpl)artifact.getModel()).getNamespace())) continue;
                        URL artifactLocation = ((XSDefinitionImpl)artifact.getModel()).getLocation().toURL();
                        return XMLDocumentHelper.getInputSource(artifactLocation);
                    }
                }
                catch (IOException ex) {
                    return new InputSource(schemaLocation);
                }
                return new InputSource(schemaLocation);
            }
        }
    }
}

