/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.tools.wsdl2java.generate;

import commonj.sdo.helper.XSDHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.tuscany.sdo.generate.XSD2JavaGenerator;
import org.apache.tuscany.sdo.helper.HelperContextImpl;
import org.apache.tuscany.sdo.util.DataObjectUtil;
import org.apache.tuscany.tools.wsdl2java.generate.JavaInterfaceGenerator;
import org.apache.tuscany.tools.wsdl2java.generate.SDODataBindingTypeMappingEntry;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelFactory;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.BasicExtendedMetaData;
import org.eclipse.emf.ecore.util.ExtendedMetaData;

public class WSDL2JavaGenerator {
    protected static final int DYNAMIC_SDO = 1;
    protected static final int GENERATE_SDO = 2;
    protected static final int VERBOSE_MODE = 4;
    protected static final String NO_GEN_PARM = "-noGenerate";
    protected static final String TARGET_DIR_PARM = "-targetDirectory";
    protected static final String JAVA_PACKAGE_PARM = "-javaPackage";
    protected static final String ALL_NAMESPACES_PARM = "-schemaNamespace all";

    public static void main(String[] args) {
        String wsdlFileName;
        int index;
        if (args.length == 0) {
            WSDL2JavaGenerator.printUsage();
            return;
        }
        String portName = null;
        String targetDirectory = null;
        String wsdlJavaPackage = null;
        String xsdJavaPackage = null;
        String sdoGenArgs = null;
        String sdoGenArgsString = null;
        int genOptions = 0;
        for (index = 0; index < args.length && args[index].startsWith("-"); ++index) {
            if (args[index].equalsIgnoreCase("-port")) {
                portName = args[++index];
                continue;
            }
            if (args[index].equalsIgnoreCase(TARGET_DIR_PARM)) {
                targetDirectory = args[++index];
                continue;
            }
            if (args[index].equalsIgnoreCase(JAVA_PACKAGE_PARM)) {
                wsdlJavaPackage = args[++index];
                continue;
            }
            if (args[index].equalsIgnoreCase("-dynamicSDO")) {
                genOptions |= 1;
                continue;
            }
            if (args[index].equalsIgnoreCase("-generateSDO")) {
                genOptions |= 2;
                continue;
            }
            if (args[index].equalsIgnoreCase("-sdoGenArgs")) {
                sdoGenArgs = args[++index];
                continue;
            }
            if (args[index].equalsIgnoreCase("-verbose")) {
                genOptions |= 4;
                continue;
            }
            WSDL2JavaGenerator.printUsage();
            return;
        }
        if (sdoGenArgs != null && (2 & genOptions) == 0) {
            genOptions |= 2;
        }
        if (targetDirectory == null) {
            targetDirectory = ".";
        }
        if ((wsdlFileName = args[index]) == null || (1 & genOptions) != 0 && (2 & genOptions) != 0) {
            WSDL2JavaGenerator.printUsage();
            return;
        }
        if (sdoGenArgs != null) {
            try {
                String line;
                File inFile = new File(sdoGenArgs).getAbsoluteFile();
                FileReader inputFile = new FileReader(inFile);
                BufferedReader bufRead = new BufferedReader(inputFile);
                StringBuffer fileContents = new StringBuffer();
                while ((line = bufRead.readLine()) != null) {
                    fileContents.append(line + " ");
                }
                sdoGenArgsString = fileContents.toString();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new IllegalArgumentException(e);
            }
        } else {
            sdoGenArgsString = null;
        }
        if ((1 & genOptions) != 0) {
            String[] stringArray;
            if (portName != null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = portName;
            } else {
                stringArray = null;
            }
            WSDL2JavaGenerator.generateDynamicFromWSDL(wsdlFileName, stringArray, targetDirectory, wsdlJavaPackage, xsdJavaPackage, genOptions);
        } else {
            String[] stringArray;
            if (portName != null) {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = portName;
            } else {
                stringArray = null;
            }
            WSDL2JavaGenerator.generateFromWSDL(wsdlFileName, stringArray, targetDirectory, wsdlJavaPackage, genOptions, sdoGenArgsString);
        }
    }

    public static void generateFromWSDL(String wsdlFileName, String[] ports, String targetDirectory, String wsdlJavaPackage, int genOptions, String sdoGenArgsString) {
        try {
            targetDirectory = targetDirectory == null ? new File(wsdlFileName).getCanonicalFile().getParent() : new File(targetDirectory).getCanonicalPath();
            HashMap<QName, SDODataBindingTypeMappingEntry> typeMapping = new HashMap<QName, SDODataBindingTypeMappingEntry>();
            StringBuffer buildCommand = new StringBuffer();
            buildCommand.append(ALL_NAMESPACES_PARM);
            if (sdoGenArgsString == null) {
                buildCommand.append(" -targetDirectory " + targetDirectory);
                if (wsdlJavaPackage != null && (genOptions & 2) != 0) {
                    buildCommand.append(" -javaPackage " + wsdlJavaPackage);
                }
                if ((genOptions & 2) == 0) {
                    buildCommand.append(" ");
                    buildCommand.append(NO_GEN_PARM);
                }
            } else {
                buildCommand.append(" ");
                buildCommand.append(sdoGenArgsString);
            }
            Vector<String> sdoCommand = new Vector<String>(Arrays.asList(buildCommand.toString().split("\\s+")));
            sdoCommand.add(wsdlFileName);
            String[] sdoGenCommand = new String[sdoCommand.size()];
            sdoCommand.toArray(sdoGenCommand);
            if ((genOptions & 4) != 0) {
                System.out.println("Options passed to XSD2Java: ");
                for (int i = 0; i < sdoGenCommand.length; ++i) {
                    System.out.println("\"" + sdoGenCommand[i] + "\"");
                }
            }
            XSD2JavaGenerator codeGen = new XSD2JavaGenerator();
            try {
                codeGen.generateFromXMLSchema(sdoGenCommand);
            }
            catch (IllegalArgumentException e) {
                System.out.println("Specified Invalid XSD2Java Arguments.\nFollow the XSD2Java usage, omitting the wsdl/xsd file argument.");
                throw new IllegalArgumentException(e);
            }
            List packages = codeGen.getGeneratedPackageInfo();
            for (XSD2JavaGenerator.GeneratedPackage packageInfo : packages) {
                for (XSD2JavaGenerator.GeneratedPackage.PackageClassInfo classInfo : packageInfo.getClasses()) {
                    QName qname;
                    SDODataBindingTypeMappingEntry existingTypeMapping;
                    SDODataBindingTypeMappingEntry typeMappingEntry;
                    if ((genOptions & 1) == 0) {
                        typeMappingEntry = new SDODataBindingTypeMappingEntry(classInfo.getClassName(), classInfo.getAnonymous(), classInfo.getProperties());
                    } else {
                        typeMappingEntry = null;
                        System.out.println();
                    }
                    if ((existingTypeMapping = (SDODataBindingTypeMappingEntry)typeMapping.get(qname = new QName(packageInfo.getNamespace(), classInfo.getName()))) != null && existingTypeMapping.isAnonymous()) continue;
                    typeMapping.put(qname, typeMappingEntry);
                }
            }
            JavaInterfaceGenerator codeGenerator = new JavaInterfaceGenerator(wsdlFileName, ports, targetDirectory, wsdlJavaPackage, typeMapping);
            codeGenerator.generate();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException(e);
        }
    }

    public static void generateFromWSDL(String wsdlFileName, String targetDirectory, String wsdlJavaPackage, String xsdJavaPackage, int genOptions) {
        String sdoGenArgsString = null;
        if (xsdJavaPackage != null) {
            sdoGenArgsString = "-javaPackage " + xsdJavaPackage;
        }
        WSDL2JavaGenerator.generateFromWSDL(wsdlFileName, null, targetDirectory, wsdlJavaPackage, genOptions, sdoGenArgsString);
    }

    public static void generateFromWSDL(String wsdlFileName, String[] ports, String targetDirectory, String wsdlJavaPackage, String xsdJavaPackage, int genOptions) {
        String sdoGenArgsString = null;
        if (xsdJavaPackage != null) {
            sdoGenArgsString = "-javaPackage " + xsdJavaPackage;
        }
        WSDL2JavaGenerator.generateFromWSDL(wsdlFileName, null, targetDirectory, wsdlJavaPackage, genOptions, sdoGenArgsString);
    }

    public static void generateDynamicFromWSDL(String wsdlFileName, String[] ports, String targetDirectory, String wsdlJavaPackage, String xsdJavaPackage, int genOptions) {
        DataObjectUtil.initRuntime();
        EPackageRegistryImpl packageRegistry = new EPackageRegistryImpl(EPackage.Registry.INSTANCE);
        BasicExtendedMetaData extendedMetaData = new BasicExtendedMetaData((EPackage.Registry)packageRegistry);
        HelperContextImpl context = new HelperContextImpl((ExtendedMetaData)extendedMetaData, false);
        XSDHelper xsdHelper = context.getXSDHelper();
        try {
            File inputFile = new File(wsdlFileName).getAbsoluteFile();
            FileInputStream inputStream = new FileInputStream(inputFile);
            xsdHelper.define((InputStream)inputStream, inputFile.toURI().toString());
            targetDirectory = targetDirectory == null ? new File(wsdlFileName).getCanonicalFile().getParent() : new File(targetDirectory).getCanonicalPath();
            HashMap<QName, SDODataBindingTypeMappingEntry> typeMapping = new HashMap<QName, SDODataBindingTypeMappingEntry>();
            if (!packageRegistry.values().isEmpty()) {
                ResourceSet resourceSet = DataObjectUtil.createResourceSet();
                ArrayList<GenPackage> genPackages = new ArrayList<GenPackage>();
                HashMap<EClass, GenClass> genClasses = new HashMap<EClass, GenClass>();
                for (EPackage currentEPackage : packageRegistry.values()) {
                    String currentBasePackage = WSDL2JavaGenerator.extractBasePackageName(currentEPackage, xsdJavaPackage);
                    String currentPrefix = CodeGenUtil.capName((String)currentEPackage.getName());
                    GenPackage currentGenPackage = WSDL2JavaGenerator.createGenPackage(currentEPackage, currentBasePackage, currentPrefix, genOptions, resourceSet);
                    genPackages.add(currentGenPackage);
                    for (GenClass genClass : currentGenPackage.getGenClasses()) {
                        genClasses.put(genClass.getEcoreClass(), genClass);
                    }
                }
                for (GenPackage currentGenPackage : genPackages) {
                    EPackage currentEPackage = currentGenPackage.getEcorePackage();
                    for (GenClass genClass : currentGenPackage.getGenClasses()) {
                        QName qname = new QName(extendedMetaData.getNamespace(currentEPackage), extendedMetaData.getName((EClassifier)genClass.getEcoreClass()));
                        String interfaceName = (1 & genOptions) == 1 ? "commonj.sdo.DataObject" : currentGenPackage.getInterfacePackageName() + '.' + genClass.getInterfaceName();
                        SDODataBindingTypeMappingEntry typeMappingEntry = new SDODataBindingTypeMappingEntry(interfaceName, false, null);
                        typeMapping.put(qname, typeMappingEntry);
                    }
                    EClass documentRoot = extendedMetaData.getDocumentRoot(currentEPackage);
                    if (documentRoot == null) continue;
                    for (EStructuralFeature element : extendedMetaData.getElements(documentRoot)) {
                        EClassifier elementType = element.getEType();
                        if (elementType instanceof EClass) {
                            EClass eClass = (EClass)elementType;
                            GenClass genClass = (GenClass)genClasses.get(elementType);
                            QName qname = new QName(extendedMetaData.getNamespace(currentEPackage), extendedMetaData.getName(element));
                            String interfaceName = (1 & genOptions) == 1 ? "commonj.sdo.DataObject" : genClass.getGenPackage().getInterfacePackageName() + '.' + genClass.getInterfaceName();
                            boolean anonymous = extendedMetaData.isAnonymous((EClassifier)eClass);
                            ArrayList<String> propertyClassNames = new ArrayList<String>();
                            for (EStructuralFeature feature : eClass.getEStructuralFeatures()) {
                                EClassifier propertyType = feature.getEType();
                                if (propertyType instanceof EClass) {
                                    GenClass propertyGenClass = (GenClass)genClasses.get(propertyType);
                                    String propertyClassName = (1 & genOptions) == 1 ? "commonj.sdo.DataObject" : propertyGenClass.getGenPackage().getInterfacePackageName() + '.' + '.' + propertyGenClass.getInterfaceName();
                                    propertyClassNames.add(propertyClassName);
                                    continue;
                                }
                                if (!(propertyType instanceof EClassifier)) continue;
                                String propertyClassName = propertyType.getInstanceClass().getName();
                                propertyClassNames.add(propertyClassName);
                            }
                            SDODataBindingTypeMappingEntry typeMappingEntry = new SDODataBindingTypeMappingEntry(interfaceName, anonymous, propertyClassNames);
                            typeMapping.put(qname, typeMappingEntry);
                            continue;
                        }
                        QName qname = new QName(extendedMetaData.getNamespace(currentEPackage), extendedMetaData.getName(element));
                        String className = elementType.getInstanceClass().getName();
                        SDODataBindingTypeMappingEntry typeMappingEntry = new SDODataBindingTypeMappingEntry(className, false, null);
                        typeMapping.put(qname, typeMappingEntry);
                    }
                }
            }
            try {
                JavaInterfaceGenerator codeGenerator = new JavaInterfaceGenerator(wsdlFileName, ports, targetDirectory, wsdlJavaPackage, typeMapping);
                codeGenerator.generate();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalArgumentException(e);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(e);
        }
    }

    public static GenPackage createGenPackage(EPackage ePackage, String basePackage, String prefix, int genOptions, ResourceSet resourceSet) {
        GenModel genModel = WSDL2JavaGenerator.ecore2GenModel(ePackage, basePackage, prefix, genOptions);
        URI ecoreURI = URI.createURI((String)("file:///" + ePackage.getName() + ".ecore"));
        URI genModelURI = ecoreURI.trimFileExtension().appendFileExtension("genmodel");
        Resource ecoreResource = resourceSet.createResource(ecoreURI);
        ecoreResource.getContents().add((Object)ePackage);
        Resource genModelResource = resourceSet.createResource(genModelURI);
        genModelResource.getContents().add((Object)genModel);
        return (GenPackage)genModel.getGenPackages().get(0);
    }

    public static GenModel ecore2GenModel(EPackage ePackage, String basePackage, String prefix, int genOptions) {
        GenModel genModel = GenModelFactory.eINSTANCE.createGenModel();
        genModel.initialize(Collections.singleton(ePackage));
        genModel.setRootExtendsInterface("");
        genModel.setRootImplementsInterface("commonj.sdo.DataObject");
        genModel.setRootExtendsClass("org.apache.tuscany.sdo.impl.DataObjectImpl");
        genModel.setFeatureMapWrapperInterface("commonj.sdo.Sequence");
        genModel.setFeatureMapWrapperInternalInterface("org.apache.tuscany.sdo.util.BasicSequence");
        genModel.setFeatureMapWrapperClass("org.apache.tuscany.sdo.util.BasicSequence");
        genModel.setSuppressEMFTypes(true);
        genModel.setSuppressEMFMetaData(true);
        genModel.setSuppressEMFModelTags(true);
        genModel.setCanGenerate(true);
        genModel.setFacadeHelperClass("Hack");
        genModel.setForceOverwrite(true);
        GenPackage genPackage = (GenPackage)genModel.getGenPackages().get(0);
        if (basePackage != null) {
            genPackage.setBasePackage(basePackage);
        }
        if (prefix != null) {
            genPackage.setPrefix(prefix);
        }
        return genModel;
    }

    public static String extractBasePackageName(EPackage ePackage, String javaPackage) {
        String qualifiedName = javaPackage != null ? javaPackage : ePackage.getName();
        String name = WSDL2JavaGenerator.shortName(qualifiedName);
        String baseName = qualifiedName.substring(0, qualifiedName.length() - name.length());
        if (javaPackage != null || !name.equals(qualifiedName)) {
            ePackage.setName(name);
        }
        return baseName != null ? WSDL2JavaGenerator.safeQualifiedName(baseName) : null;
    }

    public static String shortName(String qualifiedName) {
        int index = qualifiedName.lastIndexOf(".");
        return index != -1 ? qualifiedName.substring(index + 1) : qualifiedName;
    }

    public static String safeQualifiedName(String qualifiedName) {
        StringBuffer safeQualifiedName = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(qualifiedName, ".");
        while (stringTokenizer.hasMoreTokens()) {
            String name = stringTokenizer.nextToken();
            safeQualifiedName.append(CodeGenUtil.safeName((String)name));
            if (!stringTokenizer.hasMoreTokens()) continue;
            safeQualifiedName.append('.');
        }
        return safeQualifiedName.toString();
    }

    public static String normalizeClassName(String className) {
        StringBuffer normalizedClassName = new StringBuffer();
        String beginPart = className.substring(0, 1);
        String endPart = className.substring(1);
        normalizedClassName.append(beginPart.toUpperCase());
        normalizedClassName.append(endPart);
        return normalizedClassName.toString();
    }

    protected static void printDiagnostic(Diagnostic diagnostic, String indent) {
        System.out.print(indent);
        System.out.println(diagnostic.getMessage());
        Iterator i = diagnostic.getChildren().iterator();
        while (i.hasNext()) {
            WSDL2JavaGenerator.printDiagnostic((Diagnostic)i.next(), indent + "  ");
        }
    }

    protected static void printUsage() {
        System.out.println("Usage arguments:");
        System.out.println("  [ -targetDirectory <target-root-directory> ]");
        System.out.println("  [ -javaPackage <java-package-name> ]");
        System.out.println("  [ -dynamicSDO | -generateSDO [ -sdoGenArgs <command-file-name> ]]");
        System.out.println("  [ -verbose ]");
        System.out.println("  <wsdl-file>");
        System.out.println("");
        System.out.println("Where <command-file-name> is a text file containing valid XSD2Java command\narguments (w/o the wsdl/xsd file name)");
        System.out.println("For example:");
        System.out.println("");
        System.out.println("    WSDL2JavaGenerator -targetDirectory myDir somedir/somefile.wsdl");
    }
}

