/*
 * Decompiled with CFR 0.152.
 */
package commonj.sdo.impl;

import commonj.sdo.helper.CopyHelper;
import commonj.sdo.helper.DataFactory;
import commonj.sdo.helper.DataHelper;
import commonj.sdo.helper.EqualityHelper;
import commonj.sdo.helper.HelperContext;
import commonj.sdo.helper.TypeHelper;
import commonj.sdo.helper.XMLHelper;
import commonj.sdo.helper.XSDHelper;
import commonj.sdo.impl.ExternalizableDelegator;
import commonj.sdo.impl.NoHelperProviderException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.PrivilegedAction;

public abstract class HelperProvider {
    public static HelperProvider INSTANCE;
    public static final String SERVICE_RESOURCE_NAME = "META-INF/services/commonj.sdo.impl.HelperProvider";
    public static final String PROPERTY_NAME = "commonj.sdo.impl.HelperProvider";
    protected static HelperContext defaultContext;

    public static synchronized void setDefaultInstance(ClassLoader cl) {
        if (INSTANCE == null) {
            try {
                INSTANCE = HelperProvider.getInstance(cl);
            }
            catch (NoHelperProviderException noHelperProviderException) {
                // empty catch block
            }
        }
    }

    public static HelperProvider getInstance() throws NoHelperProviderException {
        HelperProvider provider;
        String implName = HelperProvider.getImplementationName();
        ClassLoader cl = HelperProvider.getContextClassLoader();
        if (cl != null && (provider = HelperProvider.loadImplementation(cl, implName)) != null) {
            return provider;
        }
        cl = HelperProvider.class.getClassLoader();
        provider = HelperProvider.loadImplementation(cl, implName);
        if (provider != null) {
            return provider;
        }
        throw new NoHelperProviderException(implName);
    }

    public static HelperProvider getInstance(ClassLoader cl) throws NoHelperProviderException {
        String implName = HelperProvider.getImplementationName();
        HelperProvider provider = HelperProvider.loadImplementation(cl, implName);
        if (provider == null) {
            throw new NoHelperProviderException(implName);
        }
        return provider;
    }

    private static ClassLoader getContextClassLoader() {
        try {
            return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
        }
        catch (SecurityException e) {
            return null;
        }
    }

    private static HelperProvider loadImplementation(ClassLoader cl, String implName) throws NoHelperProviderException {
        if (implName == null) {
            implName = HelperProvider.getImplementationName(cl);
        }
        if (implName == null) {
            return null;
        }
        try {
            return (HelperProvider)cl.loadClass(implName).newInstance();
        }
        catch (InstantiationException e) {
            throw new NoHelperProviderException(implName, e);
        }
        catch (IllegalAccessException e) {
            throw new NoHelperProviderException(implName, e);
        }
        catch (ClassNotFoundException e) {
            throw new NoHelperProviderException(implName, e);
        }
    }

    private static String getImplementationName() {
        try {
            return (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty(HelperProvider.PROPERTY_NAME);
                }
            });
        }
        catch (SecurityException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getImplementationName(ClassLoader cl) {
        InputStreamReader in;
        InputStream is = cl.getResourceAsStream(SERVICE_RESOURCE_NAME);
        if (is == null) {
            return null;
        }
        try {
            in = new InputStreamReader(is, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"UTF-8 encoding not available");
        }
        try {
            BufferedReader reader = new BufferedReader(in, 128);
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    int i = line.indexOf(35);
                    if (i != -1) {
                        line = line.substring(0, i);
                    }
                    if ((line = line.trim()).length() <= 0) continue;
                    String string = line;
                    return string;
                }
                String string = null;
                return string;
            }
            finally {
                reader.close();
            }
        }
        catch (IOException e) {
            throw new NoHelperProviderException(e);
        }
    }

    public abstract CopyHelper copyHelper();

    public abstract DataFactory dataFactory();

    public abstract DataHelper dataHelper();

    public abstract EqualityHelper equalityHelper();

    public abstract TypeHelper typeHelper();

    public abstract XMLHelper xmlHelper();

    public abstract XSDHelper xsdHelper();

    public abstract ExternalizableDelegator.Resolvable resolvable();

    public abstract ExternalizableDelegator.Resolvable resolvable(Object var1);

    public static CopyHelper getCopyHelper() {
        return INSTANCE.copyHelper();
    }

    public static DataFactory getDataFactory() {
        return INSTANCE.dataFactory();
    }

    public static DataHelper getDataHelper() {
        return INSTANCE.dataHelper();
    }

    public static EqualityHelper getEqualityHelper() {
        return INSTANCE.equalityHelper();
    }

    public static TypeHelper getTypeHelper() {
        return INSTANCE.typeHelper();
    }

    public static XMLHelper getXMLHelper() {
        return INSTANCE.xmlHelper();
    }

    public static XSDHelper getXSDHelper() {
        return INSTANCE.xsdHelper();
    }

    public static ExternalizableDelegator.Resolvable createResolvable() {
        return INSTANCE.resolvable();
    }

    public static ExternalizableDelegator.Resolvable createResolvable(Object target) {
        return INSTANCE.resolvable(target);
    }

    public static HelperContext getDefaultContext() {
        return INSTANCE.helperContext();
    }

    HelperContext helperContext() {
        return defaultContext;
    }

    static {
        HelperProvider provider;
        try {
            provider = HelperProvider.getInstance(HelperProvider.class.getClassLoader());
        }
        catch (NoHelperProviderException e) {
            provider = null;
        }
        INSTANCE = provider;
    }

    static class DefaultHelperContext
    implements HelperContext {
        DefaultHelperContext() {
        }

        public CopyHelper getCopyHelper() {
            return INSTANCE.copyHelper();
        }

        public DataFactory getDataFactory() {
            return INSTANCE.dataFactory();
        }

        public DataHelper getDataHelper() {
            return INSTANCE.dataHelper();
        }

        public EqualityHelper getEqualityHelper() {
            return INSTANCE.equalityHelper();
        }

        public TypeHelper getTypeHelper() {
            return INSTANCE.typeHelper();
        }

        public XMLHelper getXMLHelper() {
            return INSTANCE.xmlHelper();
        }

        public XSDHelper getXSDHelper() {
            return INSTANCE.xsdHelper();
        }
    }
}

