/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sdo.helper;

import commonj.sdo.Property;
import commonj.sdo.Type;
import commonj.sdo.helper.HelperContext;
import commonj.sdo.helper.XSDHelper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.tuscany.sdo.helper.HelperContextImpl;
import org.apache.tuscany.sdo.helper.SDOExtendedMetaDataImpl;
import org.apache.tuscany.sdo.helper.SDOXSDEcoreBuilder;
import org.apache.tuscany.sdo.helper.SchemaBuilder;
import org.apache.tuscany.sdo.helper.TypeHelperImpl;
import org.apache.tuscany.sdo.helper.TypeTable;
import org.apache.tuscany.sdo.impl.DynamicDataObjectImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.ecore.XSDEcoreBuilder;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.xml.sax.InputSource;

public class XSDHelperImpl
implements XSDHelper {
    protected boolean extensibleNamespaces = false;
    protected HelperContext helperContext;
    protected SDOXSDEcoreBuilder nondelegatingEcoreBuilder = null;
    protected HashMap tcclToEcoreBuilderMap = null;
    private ExtendedMetaData extendedMetaData;

    public XSDHelperImpl(HelperContext hc, String redefineBuiltIn, boolean extensibleNamespaces) {
        this.helperContext = hc;
        this.extensibleNamespaces = extensibleNamespaces;
        this.extendedMetaData = ((HelperContextImpl)this.helperContext).extendedMetaData;
        SDOXSDEcoreBuilder ecoreBuilder = this.createEcoreBuilder();
        if (this.extendedMetaData instanceof SDOExtendedMetaDataImpl && ((SDOExtendedMetaDataImpl)this.extendedMetaData).getRegistry() instanceof EPackageRegistryImpl.Delegator) {
            this.tcclToEcoreBuilderMap = new HashMap();
            this.putTCCLEcoreBuilder(ecoreBuilder);
        } else {
            this.nondelegatingEcoreBuilder = ecoreBuilder;
        }
        if (redefineBuiltIn != null) {
            ecoreBuilder.getTargetNamespaceToEPackageMap().remove(redefineBuiltIn);
        }
    }

    public XSDHelperImpl(HelperContext hc) {
        this(hc, null, false);
    }

    public void setRedefineBuiltIn(String redefineBuiltIn) {
        if (redefineBuiltIn != null) {
            this.getEcoreBuilder().getTargetNamespaceToEPackageMap().remove(redefineBuiltIn);
        }
    }

    public void setExtensibleNamespaces(boolean extensibleNamespaces) {
        this.extensibleNamespaces = extensibleNamespaces;
    }

    protected SDOXSDEcoreBuilder createEcoreBuilder() {
        SDOXSDEcoreBuilder ecoreBuilder = new SDOXSDEcoreBuilder(this.extendedMetaData, this.extensibleNamespaces);
        Iterator iter = TypeHelperImpl.getBuiltInModels().iterator();
        while (iter.hasNext()) {
            EPackage ePackage = (EPackage)iter.next();
            ecoreBuilder.getTargetNamespaceToEPackageMap().put(ePackage.getNsURI(), ePackage);
        }
        return ecoreBuilder;
    }

    protected void putTCCLEcoreBuilder(XSDEcoreBuilder ecoreBuilder) {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        if (this.tcclToEcoreBuilderMap.get(tccl) == null) {
            this.tcclToEcoreBuilderMap.put(tccl, ecoreBuilder);
        }
    }

    protected SDOXSDEcoreBuilder getEcoreBuilder() {
        if (this.nondelegatingEcoreBuilder != null) {
            return this.nondelegatingEcoreBuilder;
        }
        SDOXSDEcoreBuilder result = null;
        try {
            for (ClassLoader tccl = Thread.currentThread().getContextClassLoader(); tccl != null; tccl = tccl.getParent()) {
                result = (SDOXSDEcoreBuilder)((Object)this.tcclToEcoreBuilderMap.get(tccl));
                if (result == null) continue;
                return result;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        result = this.createEcoreBuilder();
        this.putTCCLEcoreBuilder(result);
        return result;
    }

    public String getLocalName(Type type) {
        return this.extendedMetaData.getName((EClassifier)type);
    }

    public String getLocalName(Property property) {
        return this.extendedMetaData.getName((EStructuralFeature)property);
    }

    public String getNamespaceURI(Property property) {
        return this.extendedMetaData.getNamespace((EStructuralFeature)property);
    }

    public boolean isAttribute(Property property) {
        return this.extendedMetaData.getFeatureKind((EStructuralFeature)property) == 2;
    }

    public boolean isElement(Property property) {
        return this.extendedMetaData.getFeatureKind((EStructuralFeature)property) == 4;
    }

    public boolean isMixed(Type type) {
        if (type instanceof EClass) {
            return this.extendedMetaData.getContentKind((EClass)type) == 3;
        }
        return false;
    }

    public boolean isXSD(Type type) {
        return ((EModelElement)type).getEAnnotation("http:///org/eclipse/emf/ecore/util/ExtendedMetaData") != null;
    }

    public Property getGlobalProperty(String uri, String propertyName, boolean isElement) {
        if (isElement) {
            return (Property)this.extendedMetaData.getElement(uri, propertyName);
        }
        return (Property)this.extendedMetaData.getAttribute(uri, propertyName);
    }

    public String getAppinfo(Type type, String source) {
        return this.getAppinfo((EModelElement)type, source);
    }

    public String getAppinfo(Property property, String source) {
        return this.getAppinfo((EModelElement)property, source);
    }

    protected String getAppinfo(EModelElement eModelElement, String source) {
        return (String)eModelElement.getEAnnotation(source).getDetails().get((Object)"appinfo");
    }

    public List define(String xsd) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(xsd.getBytes());
        return this.define(inputStream, "*.xsd");
    }

    public List define(Reader xsdReader, String schemaLocation) {
        InputSource inputSource = new InputSource(xsdReader);
        return this.define(inputSource, schemaLocation);
    }

    public List define(InputStream xsdInputStream, String schemaLocation) {
        InputSource inputSource = new InputSource(xsdInputStream);
        return this.define(inputSource, schemaLocation);
    }

    protected List define(InputSource inputSource, String schemaLocation) {
        try {
            SDOXSDEcoreBuilder ecoreBuilder = this.getEcoreBuilder();
            ResourceSet resourceSet = ecoreBuilder.createResourceSet();
            Resource model = resourceSet.createResource(URI.createURI((String)(schemaLocation != null ? schemaLocation : "null.xsd")));
            ((XSDResourceImpl)model).load(inputSource, null);
            ArrayList newTypes = new ArrayList();
            Iterator schemaIter = model.getContents().iterator();
            while (schemaIter.hasNext()) {
                XSDSchema schema = (XSDSchema)schemaIter.next();
                String targetNamespace = schema.getTargetNamespace();
                EPackage ePackage = this.extendedMetaData.getPackage(targetNamespace);
                if (!this.extensibleNamespaces && ePackage != null && !TypeHelperImpl.getBuiltInModels().contains(ePackage)) continue;
                Map targetNamespaceToEPackageMap = ecoreBuilder.getTargetNamespaceToEPackageMap();
                targetNamespaceToEPackageMap.remove(targetNamespace);
                HashSet originalEPackages = new HashSet(targetNamespaceToEPackageMap.values());
                ecoreBuilder.generate(schema);
                Collection newEPackages = ecoreBuilder.getTargetNamespaceToEPackageMap().values();
                Iterator iter = newEPackages.iterator();
                while (iter.hasNext()) {
                    EPackage currentPackage = (EPackage)iter.next();
                    if (originalEPackages.contains(currentPackage)) continue;
                    currentPackage.setEFactoryInstance((EFactory)new DynamicDataObjectImpl.FactoryImpl());
                    EcoreUtil.freeze((EPackage)currentPackage);
                    newTypes.addAll(currentPackage.getEClassifiers());
                }
            }
            return newTypes;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public String generate(List types) throws IllegalArgumentException {
        return this.generate(types, new Hashtable());
    }

    public String generate(List types, Map namespaceToSchemaLocation) throws IllegalArgumentException {
        if (types != null && !types.isEmpty()) {
            Hashtable schemaMap = new Hashtable();
            Hashtable nsPrefixMap = new Hashtable();
            TypeTable typeTable = new TypeTable();
            SchemaBuilder schemaBuilder = new SchemaBuilder(schemaMap, nsPrefixMap, typeTable, namespaceToSchemaLocation);
            Iterator<Object> iterator = types.iterator();
            Type dataType = null;
            try {
                while (iterator.hasNext()) {
                    dataType = (Type)iterator.next();
                    schemaBuilder.buildSchema(dataType);
                }
                XSDSchema xmlSchema = null;
                iterator = schemaMap.values().iterator();
                StringWriter writer = new StringWriter();
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                while (iterator.hasNext()) {
                    xmlSchema = (XSDSchema)iterator.next();
                    if (xmlSchema.getElement() == null) {
                        xmlSchema.updateElement();
                    }
                    transformer.transform(new DOMSource(xmlSchema.getElement().getOwnerDocument()), new StreamResult(writer));
                }
                writer.close();
                return writer.getBuffer().toString();
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
        return "";
    }

    public HelperContext getHelperContext() {
        return this.helperContext;
    }
}

