/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sdo.util.metadata.impl;

import commonj.sdo.Type;
import java.util.Collection;
import java.util.List;
import org.apache.tuscany.sdo.impl.DataObjectBase;
import org.apache.tuscany.sdo.util.metadata.JavaMetaData;
import org.apache.tuscany.sdo.util.metadata.MetadataFactory;
import org.apache.tuscany.sdo.util.metadata.SDOMetaDataGroup;
import org.apache.tuscany.sdo.util.metadata.TypeMetaData;
import org.apache.tuscany.sdo.util.metadata.XSDMetaData;
import org.apache.tuscany.sdo.util.metadata.impl.MetadataFactoryImpl;

public class SDOMetaDataGroupImpl
extends DataObjectBase
implements SDOMetaDataGroup {
    public static final int JAVA_META_DATA = 0;
    public static final int XSD_META_DATA = 1;
    public static final int TYPE_META_DATA = 2;
    public static final int SDO_PROPERTY_COUNT = 3;
    protected List javaMetaData = null;
    protected List xsdMetaData = null;
    protected List typeMetaData = null;

    protected SDOMetaDataGroupImpl() {
    }

    public Type getStaticType() {
        return ((MetadataFactoryImpl)MetadataFactory.INSTANCE).getSDOMetaDataGroup();
    }

    public List getJavaMetaData() {
        if (this.javaMetaData == null) {
            this.javaMetaData = this.createPropertyList(0, JavaMetaData.class, 0);
        }
        return this.javaMetaData;
    }

    public List getXsdMetaData() {
        if (this.xsdMetaData == null) {
            this.xsdMetaData = this.createPropertyList(0, XSDMetaData.class, 1);
        }
        return this.xsdMetaData;
    }

    public List getTypeMetaData() {
        if (this.typeMetaData == null) {
            this.typeMetaData = this.createPropertyList(0, TypeMetaData.class, 2);
        }
        return this.typeMetaData;
    }

    public DataObjectBase.ChangeContext inverseRemove(Object otherEnd, int propertyIndex, DataObjectBase.ChangeContext changeContext) {
        switch (propertyIndex) {
            case 0: {
                return this.removeFromList(this.getJavaMetaData(), otherEnd, changeContext);
            }
            case 1: {
                return this.removeFromList(this.getXsdMetaData(), otherEnd, changeContext);
            }
            case 2: {
                return this.removeFromList(this.getTypeMetaData(), otherEnd, changeContext);
            }
        }
        return super.inverseRemove(otherEnd, propertyIndex, changeContext);
    }

    public Object get(int propertyIndex, boolean resolve) {
        switch (propertyIndex) {
            case 0: {
                return this.getJavaMetaData();
            }
            case 1: {
                return this.getXsdMetaData();
            }
            case 2: {
                return this.getTypeMetaData();
            }
        }
        return super.get(propertyIndex, resolve);
    }

    public void set(int propertyIndex, Object newValue) {
        switch (propertyIndex) {
            case 0: {
                this.getJavaMetaData().clear();
                this.getJavaMetaData().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.getXsdMetaData().clear();
                this.getXsdMetaData().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.getTypeMetaData().clear();
                this.getTypeMetaData().addAll((Collection)newValue);
                return;
            }
        }
        super.set(propertyIndex, newValue);
    }

    public void unset(int propertyIndex) {
        switch (propertyIndex) {
            case 0: {
                this.getJavaMetaData().clear();
                return;
            }
            case 1: {
                this.getXsdMetaData().clear();
                return;
            }
            case 2: {
                this.getTypeMetaData().clear();
                return;
            }
        }
        super.unset(propertyIndex);
    }

    public boolean isSet(int propertyIndex) {
        switch (propertyIndex) {
            case 0: {
                return this.javaMetaData != null && !this.javaMetaData.isEmpty();
            }
            case 1: {
                return this.xsdMetaData != null && !this.xsdMetaData.isEmpty();
            }
            case 2: {
                return this.typeMetaData != null && !this.typeMetaData.isEmpty();
            }
        }
        return super.isSet(propertyIndex);
    }
}

