/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.client;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.Application;
import org.apache.wink.client.ClientConfigException;
import org.apache.wink.client.handlers.ClientHandler;
import org.apache.wink.client.handlers.ConnectionHandler;
import org.apache.wink.client.internal.handlers.HttpURLConnectionHandler;
import org.apache.wink.common.WinkApplication;
import org.apache.wink.common.internal.providers.entity.ByteArrayProvider;
import org.apache.wink.common.internal.providers.entity.DataSourceProvider;
import org.apache.wink.common.internal.providers.entity.FileProvider;
import org.apache.wink.common.internal.providers.entity.FormMultivaluedMapProvider;
import org.apache.wink.common.internal.providers.entity.InputStreamProvider;
import org.apache.wink.common.internal.providers.entity.ReaderProvider;
import org.apache.wink.common.internal.providers.entity.SourceProvider;
import org.apache.wink.common.internal.providers.entity.StreamingOutputProvider;
import org.apache.wink.common.internal.providers.entity.StringProvider;
import org.apache.wink.common.internal.providers.entity.app.AppCategoriesProvider;
import org.apache.wink.common.internal.providers.entity.app.AppServiceProvider;
import org.apache.wink.common.internal.providers.entity.app.CategoriesProvider;
import org.apache.wink.common.internal.providers.entity.atom.AtomEntryJAXBElementProvider;
import org.apache.wink.common.internal.providers.entity.atom.AtomEntryProvider;
import org.apache.wink.common.internal.providers.entity.atom.AtomEntrySyndEntryProvider;
import org.apache.wink.common.internal.providers.entity.atom.AtomFeedJAXBElementProvider;
import org.apache.wink.common.internal.providers.entity.atom.AtomFeedProvider;
import org.apache.wink.common.internal.providers.entity.atom.AtomFeedSyndFeedProvider;
import org.apache.wink.common.internal.providers.entity.json.JsonJAXBProvider;
import org.apache.wink.common.internal.providers.entity.json.JsonProvider;
import org.apache.wink.common.internal.providers.entity.json.JsonSyndEntryProvider;
import org.apache.wink.common.internal.providers.entity.json.JsonSyndFeedProvider;
import org.apache.wink.common.internal.providers.entity.opensearch.OpenSearchDescriptionProvider;
import org.apache.wink.common.internal.providers.entity.xml.JAXBElementXmlProvider;
import org.apache.wink.common.internal.providers.entity.xml.JAXBXmlProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientConfig
implements Cloneable {
    private String proxyHost = null;
    private int proxyPort = 80;
    private int connectTimeout = 60000;
    private int readTimeout = 60000;
    private boolean followRedirects = true;
    private LinkedList<ClientHandler> handlers = new LinkedList();
    private LinkedList<Application> applications = new LinkedList();
    private boolean modifiable = true;

    public ClientConfig() {
        this.initDefaultApplication();
    }

    private void initDefaultApplication() {
        this.applications(new Application[]{new WinkApplication(){

            public Set<Class<?>> getClasses() {
                HashSet set = new HashSet();
                set.add(StringProvider.class);
                set.add(FileProvider.class);
                set.add(ByteArrayProvider.class);
                set.add(InputStreamProvider.class);
                set.add(StringProvider.class);
                set.add(ReaderProvider.class);
                set.add(DataSourceProvider.class);
                set.add(FormMultivaluedMapProvider.class);
                set.add(SourceProvider.StreamSourceProvider.class);
                set.add(SourceProvider.SAXSourceProvider.class);
                set.add(SourceProvider.DOMSourceProvider.class);
                set.add(StreamingOutputProvider.class);
                set.add(JAXBElementXmlProvider.class);
                set.add(JAXBXmlProvider.class);
                set.add(AtomFeedProvider.class);
                set.add(AtomFeedSyndFeedProvider.class);
                set.add(AtomFeedJAXBElementProvider.class);
                set.add(AtomEntryProvider.class);
                set.add(AtomEntrySyndEntryProvider.class);
                set.add(AtomEntryJAXBElementProvider.class);
                set.add(AppServiceProvider.class);
                set.add(AppCategoriesProvider.class);
                set.add(CategoriesProvider.class);
                set.add(OpenSearchDescriptionProvider.class);
                set.add(JsonProvider.class);
                set.add(JsonJAXBProvider.class);
                set.add(JsonSyndEntryProvider.class);
                set.add(JsonSyndFeedProvider.class);
                return set;
            }

            public double getPriority() {
                return 0.1;
            }
        }});
    }

    public final String getProxyHost() {
        return this.proxyHost;
    }

    public final ClientConfig proxyHost(String proxyHost) {
        if (!this.modifiable) {
            throw new ClientConfigException("configuration is unmodifiable");
        }
        this.proxyHost = proxyHost;
        return this;
    }

    public final int getProxyPort() {
        return this.proxyPort;
    }

    public final ClientConfig proxyPort(int proxyPort) {
        if (!this.modifiable) {
            throw new ClientConfigException("configuration is unmodifiable");
        }
        if (proxyPort <= 0) {
            proxyPort = 80;
        }
        this.proxyPort = proxyPort;
        return this;
    }

    public final int getConnectTimeout() {
        return this.connectTimeout;
    }

    public final ClientConfig connectTimeout(int connectTimeout) {
        if (!this.modifiable) {
            throw new ClientConfigException("configuration is unmodifiable");
        }
        this.connectTimeout = connectTimeout;
        return this;
    }

    public final int getReadTimeout() {
        return this.readTimeout;
    }

    public final ClientConfig readTimeout(int readTimeout) {
        if (!this.modifiable) {
            throw new ClientConfigException("configuration is unmodifiable");
        }
        this.readTimeout = readTimeout;
        return this;
    }

    public final boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public final ClientConfig followRedirects(boolean followRedirects) {
        if (!this.modifiable) {
            throw new ClientConfigException("configuration is unmodifiable");
        }
        this.followRedirects = followRedirects;
        return this;
    }

    public final List<ClientHandler> getHandlers() {
        return Collections.unmodifiableList(this.handlers);
    }

    public final ClientConfig handlers(ClientHandler ... handlers) {
        if (!this.modifiable) {
            throw new ClientConfigException("configuration is unmodifiable");
        }
        for (ClientHandler handler : handlers) {
            this.handlers.add(handler);
        }
        return this;
    }

    ClientConfig build() {
        this.handlers.add(this.getConnectionHandler());
        this.modifiable = false;
        return this;
    }

    protected ConnectionHandler getConnectionHandler() {
        return new HttpURLConnectionHandler();
    }

    public final List<Application> getApplications() {
        return Collections.unmodifiableList(this.applications);
    }

    public final ClientConfig applications(Application ... applications) {
        if (!this.modifiable) {
            throw new ClientConfigException("configuration is unmodifiable");
        }
        for (Application application : applications) {
            this.applications.add(application);
        }
        return this;
    }

    protected ClientConfig clone() {
        try {
            ClientConfig clone = (ClientConfig)super.clone();
            clone.handlers = new LinkedList<ClientHandler>(this.handlers);
            clone.applications = new LinkedList<Application>(this.applications);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

