/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.client;

import java.net.URI;
import java.util.Set;
import javax.ws.rs.core.Application;
import org.apache.wink.client.ClientConfig;
import org.apache.wink.client.Resource;
import org.apache.wink.client.internal.ResourceImpl;
import org.apache.wink.common.WinkApplication;
import org.apache.wink.common.internal.application.ApplicationValidator;
import org.apache.wink.common.internal.i18n.Messages;
import org.apache.wink.common.internal.lifecycle.LifecycleManager;
import org.apache.wink.common.internal.lifecycle.LifecycleManagersRegistry;
import org.apache.wink.common.internal.lifecycle.ScopeLifecycleManager;
import org.apache.wink.common.internal.registry.ProvidersRegistry;
import org.apache.wink.common.internal.registry.metadata.ProviderMetadataCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestClient {
    private static final Logger logger = LoggerFactory.getLogger(RestClient.class);
    private ProvidersRegistry providersRegistry;
    private ClientConfig config;
    private static final String CLASS_NOT_A_PROVIDER_MSG = Messages.getMessage((String)"classNotAProvider");

    public RestClient() {
        this(new ClientConfig());
    }

    public RestClient(ClientConfig config) {
        ClientConfig clone = config.clone();
        this.config = clone.build();
        this.initProvidersRegistry();
    }

    public ClientConfig getConfig() {
        return this.config;
    }

    public Resource resource(URI uri) {
        return new ResourceImpl(uri, this.config, this.providersRegistry);
    }

    public Resource resource(String uri) {
        return this.resource(URI.create(uri));
    }

    private void initProvidersRegistry() {
        LifecycleManagersRegistry ofFactoryRegistry = new LifecycleManagersRegistry();
        ofFactoryRegistry.addFactoryFactory((LifecycleManager)new ScopeLifecycleManager());
        this.providersRegistry = new ProvidersRegistry(ofFactoryRegistry, new ApplicationValidator());
        for (Application app : this.config.getApplications()) {
            this.processApplication(app);
        }
    }

    private void processApplication(Application application) {
        Set classes;
        if (application == null) {
            return;
        }
        Set singletons = application.getSingletons();
        if (singletons != null && singletons.size() > 0) {
            this.processSingletons(singletons);
        }
        if ((classes = application.getClasses()) != null && classes.size() > 0) {
            this.processClasses(classes);
        }
        if (application instanceof WinkApplication) {
            this.processWinkApplication((WinkApplication)application);
        }
    }

    private void processClasses(Set<Class<?>> classes) {
        for (Class<?> cls : classes) {
            if (ProviderMetadataCollector.isProvider(cls)) {
                this.providersRegistry.addProvider(cls);
                continue;
            }
            logger.warn(CLASS_NOT_A_PROVIDER_MSG, cls);
        }
    }

    private void processSingletons(Set<Object> singletons) {
        for (Object obj : singletons) {
            Class<?> cls = obj.getClass();
            if (ProviderMetadataCollector.isProvider(cls)) {
                this.providersRegistry.addProvider(obj);
                continue;
            }
            logger.warn(CLASS_NOT_A_PROVIDER_MSG, obj);
        }
    }

    private void processWinkApplication(WinkApplication sApplication) {
        Set instances = sApplication.getInstances();
        double priority = sApplication.getPriority();
        if (instances == null) {
            return;
        }
        for (Object obj : instances) {
            Class<?> cls = obj.getClass();
            if (ProviderMetadataCollector.isProvider(cls)) {
                this.providersRegistry.addProvider(obj, priority);
                continue;
            }
            logger.warn(CLASS_NOT_A_PROVIDER_MSG, obj);
        }
    }
}

