/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.client.internal.handlers;

import java.util.Set;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.wink.client.ClientRequest;
import org.apache.wink.client.ClientResponse;
import org.apache.wink.client.handlers.ClientHandler;
import org.apache.wink.client.handlers.HandlerContext;
import org.apache.wink.common.internal.i18n.Messages;
import org.apache.wink.common.internal.registry.ProvidersRegistry;
import org.apache.wink.common.internal.runtime.RuntimeContextTLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcceptHeaderHandler
implements ClientHandler {
    private static final Logger logger = LoggerFactory.getLogger(AcceptHeaderHandler.class);

    public ClientResponse handle(ClientRequest request, HandlerContext context) throws Exception {
        Object responseEntityClassType;
        MultivaluedMap<String, String> requestHeaders = request.getHeaders();
        if (requestHeaders.getFirst((Object)"Accept") == null && (responseEntityClassType = request.getAttributes().get("response.entity.class.type")) != null) {
            Class classType = (Class)responseEntityClassType;
            logger.debug("Response entity class is: {}", (Object)classType);
            Set mediaTypes = request.getAttribute(ProvidersRegistry.class).getMessageBodyReaderMediaTypesLimitByIsReadable(classType, RuntimeContextTLS.getRuntimeContext());
            logger.debug("Found media types: {}", (Object)mediaTypes);
            StringBuffer acceptHeader = new StringBuffer();
            boolean isFirst = true;
            for (MediaType mt : mediaTypes) {
                if (!isFirst) {
                    acceptHeader.append(",");
                }
                acceptHeader.append(mt.toString());
                isFirst = false;
            }
            if (acceptHeader.length() > 0) {
                String acceptValue = acceptHeader.toString();
                requestHeaders.add((Object)"Accept", (Object)acceptValue);
                logger.info(Messages.getMessage((String)"clientAcceptHeaderHandlerSetAccept"), (Object)acceptValue);
            }
        }
        return context.doChain(request);
    }
}

