/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.client.internal;

import java.lang.reflect.Type;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;
import org.apache.wink.client.ClientConfig;
import org.apache.wink.client.ClientRequest;
import org.apache.wink.client.ClientResponse;
import org.apache.wink.client.ClientRuntimeException;
import org.apache.wink.client.ClientWebException;
import org.apache.wink.client.EntityType;
import org.apache.wink.client.Resource;
import org.apache.wink.client.handlers.HandlerContext;
import org.apache.wink.client.internal.ClientRuntimeContext;
import org.apache.wink.client.internal.ClientUtils;
import org.apache.wink.client.internal.handlers.ClientRequestImpl;
import org.apache.wink.client.internal.handlers.HandlerContextImpl;
import org.apache.wink.common.RuntimeContext;
import org.apache.wink.common.internal.CaseInsensitiveMultivaluedMap;
import org.apache.wink.common.internal.i18n.Messages;
import org.apache.wink.common.internal.registry.ProvidersRegistry;
import org.apache.wink.common.internal.runtime.RuntimeContextTLS;
import org.apache.wink.common.internal.utils.HeaderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceImpl
implements Resource {
    private static final String USER_AGENT = "Wink Client v1.1";
    private ProvidersRegistry providersRegistry;
    private ClientConfig config;
    private MultivaluedMap<String, String> headers;
    private Map<String, Object> attributes;
    private UriBuilder uriBuilder;
    private static Logger logger = LoggerFactory.getLogger(ResourceImpl.class);

    public ResourceImpl(URI uri, ClientConfig config, ProvidersRegistry providersRegistry) {
        this.config = config;
        this.providersRegistry = providersRegistry;
        this.uriBuilder = UriBuilder.fromUri((URI)uri);
        this.headers = new CaseInsensitiveMultivaluedMap();
        this.attributes = new HashMap<String, Object>();
    }

    @Override
    public Resource accept(String ... values) {
        String header = (String)this.headers.getFirst((Object)"Accept");
        this.headers.putSingle((Object)"Accept", (Object)this.appendHeaderValues(header, values));
        return this;
    }

    @Override
    public Resource accept(MediaType ... values) {
        String header = (String)this.headers.getFirst((Object)"Accept");
        this.headers.putSingle((Object)"Accept", (Object)this.appendHeaderValues(header, values));
        return this;
    }

    @Override
    public Resource acceptLanguage(String ... values) {
        String header = (String)this.headers.getFirst((Object)"Accept-Language");
        this.headers.putSingle((Object)"Accept-Language", (Object)this.appendHeaderValues(header, values));
        return this;
    }

    @Override
    public Resource acceptLanguage(Locale ... values) {
        String[] types = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            types[i] = HeaderUtils.localeToLanguage((Locale)values[i]);
        }
        return this;
    }

    @Override
    public Resource contentType(String mediaType) {
        this.headers.putSingle((Object)"Content-Type", (Object)mediaType);
        return this;
    }

    @Override
    public Resource contentType(MediaType mediaType) {
        return this.contentType(mediaType.toString());
    }

    @Override
    public Resource cookie(String value) {
        this.headers.add((Object)"Cookie", (Object)value);
        return this;
    }

    @Override
    public Resource cookie(Cookie value) {
        return this.cookie(value.toString());
    }

    @Override
    public Resource header(String name, String ... values) {
        if (name == null) {
            return this;
        }
        for (String value : values) {
            if (value == null) continue;
            this.headers.add((Object)name, (Object)value);
        }
        return this;
    }

    @Override
    public Resource queryParam(String key, Object ... values) {
        this.uriBuilder.queryParam(key, values);
        return this;
    }

    @Override
    public Resource queryParams(MultivaluedMap<String, String> params) {
        for (String query : params.keySet()) {
            this.queryParam(query, ((List)params.get((Object)query)).toArray());
        }
        return this;
    }

    @Override
    public Resource attribute(String key, Object value) {
        this.attributes.put(key, value);
        return this;
    }

    @Override
    public Object attribute(String key) {
        return this.attributes.get(key);
    }

    @Override
    public UriBuilder getUriBuilder() {
        return this.uriBuilder;
    }

    @Override
    public Resource uri(URI uri) {
        this.uriBuilder = UriBuilder.fromUri((URI)uri);
        return this;
    }

    @Override
    public Resource uri(String uri) {
        this.uriBuilder = UriBuilder.fromUri((String)uri);
        return this;
    }

    private ClientResponse invokeNoException(String method, Object requestEntity) {
        try {
            return this.invoke(method, ClientResponse.class, requestEntity);
        }
        catch (ClientWebException e) {
            return e.getResponse();
        }
    }

    @Override
    public <T> T invoke(String method, Class<T> responseEntity, Object requestEntity) {
        ClientResponse response = this.invoke(method, responseEntity, responseEntity, requestEntity);
        if (responseEntity == null) {
            return null;
        }
        if (ClientResponse.class.equals(responseEntity)) {
            return (T)response;
        }
        return response.getEntity(responseEntity);
    }

    @Override
    public <T> T invoke(String method, EntityType<T> responseEntity, Object requestEntity) {
        ClientResponse response = this.invoke(method, responseEntity.getRawClass(), responseEntity.getType(), requestEntity);
        if (responseEntity == null) {
            return null;
        }
        if (ClientResponse.class.equals(responseEntity.getRawClass())) {
            return (T)response;
        }
        return response.getEntity(responseEntity);
    }

    private ClientResponse invoke(String method, Class<?> responseEntity, Type responseEntityType, Object requestEntity) {
        ClientRequest request = this.createClientRequest(method, responseEntity, responseEntityType, requestEntity);
        HandlerContext context = this.createHandlerContext();
        ProvidersRegistry providersRegistry = request.getAttribute(ProvidersRegistry.class);
        ClientRuntimeContext runtimeContext = new ClientRuntimeContext(providersRegistry);
        RuntimeContext saved = RuntimeContextTLS.getRuntimeContext();
        RuntimeContextTLS.setRuntimeContext((RuntimeContext)runtimeContext);
        try {
            ClientResponse response = context.doChain(request);
            int statusCode = response.getStatusCode();
            if (ClientUtils.isErrorCode(statusCode)) {
                logger.info(Messages.getMessage((String)"clientResponseIsErrorCode"), (Object)statusCode);
                throw new ClientWebException(request, response);
            }
            ClientResponse clientResponse = response;
            return clientResponse;
        }
        catch (ClientWebException e) {
            throw e;
        }
        catch (ClientRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ClientRuntimeException(e);
        }
        finally {
            RuntimeContextTLS.setRuntimeContext((RuntimeContext)saved);
        }
    }

    private <T> ClientRequest createClientRequest(String method, Class<T> responseEntity, Type responseEntityType, Object requestEntity) {
        ClientRequestImpl request = new ClientRequestImpl();
        request.setEntity(requestEntity);
        URI requestURI = this.uriBuilder.build(new Object[0]);
        request.setURI(requestURI);
        request.setMethod(method);
        request.getHeaders().putAll(this.headers);
        if (logger.isDebugEnabled()) {
            Integer requestEntityInfo = requestEntity == null ? null : Integer.valueOf(System.identityHashCode(requestEntity));
            logger.debug(Messages.getMessage((String)"clientIssueRequest", (Object[])new Object[]{method, requestURI, requestEntityInfo, this.headers.keySet()}));
        }
        if (this.headers.getFirst((Object)"User-Agent") == null) {
            request.getHeaders().add((Object)"User-Agent", (Object)USER_AGENT);
        }
        request.getAttributes().putAll(this.attributes);
        request.setAttribute(ProvidersRegistry.class, this.providersRegistry);
        request.setAttribute(ClientConfig.class, this.config);
        request.getAttributes().put("response.entity.generic.type", responseEntityType);
        request.getAttributes().put("response.entity.class.type", responseEntity);
        return request;
    }

    private HandlerContext createHandlerContext() {
        HandlerContextImpl context = new HandlerContextImpl(this.config.getHandlers());
        return context;
    }

    @Override
    public ClientResponse head() {
        return this.invokeNoException("HEAD", null);
    }

    @Override
    public ClientResponse options() {
        return this.invokeNoException("OPTIONS", null);
    }

    @Override
    public <T> T delete(Class<T> responseEntity) {
        return this.invoke("DELETE", responseEntity, null);
    }

    @Override
    public <T> T delete(EntityType<T> responseEntity) {
        return this.invoke("DELETE", responseEntity, null);
    }

    @Override
    public ClientResponse delete() {
        return this.invokeNoException("DELETE", null);
    }

    @Override
    public <T> T get(Class<T> responseEntity) {
        return this.invoke("GET", responseEntity, null);
    }

    @Override
    public <T> T get(EntityType<T> responseEntity) {
        return this.invoke("GET", responseEntity, null);
    }

    @Override
    public ClientResponse get() {
        return this.invokeNoException("GET", null);
    }

    @Override
    public <T> T post(Class<T> responseEntity, Object requestEntity) {
        return this.invoke("POST", responseEntity, requestEntity);
    }

    @Override
    public <T> T post(EntityType<T> responseEntity, Object requestEntity) {
        return this.invoke("POST", responseEntity, requestEntity);
    }

    @Override
    public ClientResponse post(Object requestEntity) {
        return this.invokeNoException("POST", requestEntity);
    }

    @Override
    public <T> T put(Class<T> responseEntity, Object requestEntity) {
        return this.invoke("PUT", responseEntity, requestEntity);
    }

    @Override
    public <T> T put(EntityType<T> responseEntity, Object requestEntity) {
        return this.invoke("PUT", responseEntity, requestEntity);
    }

    @Override
    public ClientResponse put(Object requestEntity) {
        return this.invokeNoException("PUT", requestEntity);
    }

    private <T> String toHeaderString(T[] objects) {
        String delim = "";
        StringBuilder sb = new StringBuilder();
        for (T t : objects) {
            sb.append(delim);
            sb.append(t.toString());
            delim = ", ";
        }
        return sb.toString();
    }

    private <T> String appendHeaderValues(String value, T[] objects) {
        StringBuilder builder = new StringBuilder(value != null ? value : "");
        builder.append(value != null ? ", " : "");
        builder.append(this.toHeaderString(objects));
        return builder.toString();
    }
}

