/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.client.internal.handlers;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;
import org.apache.wink.client.ClientResponse;
import org.apache.wink.client.ClientRuntimeException;
import org.apache.wink.client.EntityType;
import org.apache.wink.client.internal.ClientRuntimeContext;
import org.apache.wink.client.internal.handlers.BaseRequestResponseImpl;
import org.apache.wink.common.RuntimeContext;
import org.apache.wink.common.internal.i18n.Messages;
import org.apache.wink.common.internal.registry.ProvidersRegistry;
import org.apache.wink.common.internal.runtime.RuntimeContextTLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientResponseImpl
extends BaseRequestResponseImpl
implements ClientResponse {
    private Object entity;
    private String message;
    private int status;
    private Runnable contentConsumer;

    @Override
    public <T> T getEntity(Class<T> type) {
        return this.getEntity(type, type);
    }

    @Override
    public <T> T getEntity(EntityType<T> entityType) {
        return this.getEntity(entityType.getRawClass(), entityType.getType());
    }

    private <T> T getEntity(Class<T> type, Type genericType) {
        if (type.isInstance(this.entity)) {
            return (T)this.entity;
        }
        if (this.entity instanceof InputStream) {
            T t = this.readEntity(type, genericType, (InputStream)this.entity);
            this.setEntity(t);
            return t;
        }
        if (this.entity == null) {
            return null;
        }
        throw new ClassCastException(String.format(Messages.getMessage((String)"clientCannotConvertEntity"), this.entity.getClass().getName(), type.getName()));
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public int getStatusCode() {
        return this.status;
    }

    @Override
    public void setEntity(Object entity) {
        this.entity = entity;
    }

    @Override
    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public void setStatusCode(int code) {
        this.status = code;
    }

    private <T> T readEntity(Class<T> type, Type genericType, InputStream is) {
        if (type == null) {
            return null;
        }
        if (ClientResponse.class.equals(type)) {
            return (T)this;
        }
        ProvidersRegistry providersRegistry = this.getAttribute(ProvidersRegistry.class);
        RuntimeContext saved = RuntimeContextTLS.getRuntimeContext();
        ClientRuntimeContext runtimeContext = new ClientRuntimeContext(providersRegistry);
        RuntimeContextTLS.setRuntimeContext((RuntimeContext)runtimeContext);
        try {
            Object entity;
            MediaType contentMediaType;
            MessageBodyReader reader;
            String contentType = (String)this.getHeaders().getFirst((Object)"Content-Type");
            if (contentType == null || contentType.length() == 0) {
                contentType = "application/octet-stream";
            }
            if ((reader = providersRegistry.getMessageBodyReader(type, genericType, null, contentMediaType = MediaType.valueOf((String)contentType), (RuntimeContext)runtimeContext)) == null) {
                throw new RuntimeException(Messages.getMessage((String)"clientNoReaderForTypeAndMediaType", (Object[])new Object[]{String.valueOf(type), contentType}));
            }
            Object object = entity = reader.readFrom(type, genericType, null, contentMediaType, this.getHeaders(), is);
            return (T)object;
        }
        catch (WebApplicationException e) {
            throw new ClientRuntimeException(e);
        }
        catch (IOException e) {
            throw new ClientRuntimeException(e);
        }
        finally {
            RuntimeContextTLS.setRuntimeContext((RuntimeContext)saved);
            this.consumeContent();
        }
    }

    @Override
    public void consumeContent() {
        if (this.contentConsumer != null) {
            this.contentConsumer.run();
        }
    }

    public void setContentConsumer(Runnable contentConsumer) {
        this.contentConsumer = contentConsumer;
    }

    public Runnable getContentConsumer() {
        return this.contentConsumer;
    }

    @Override
    public Response.StatusType getStatusType() {
        final int statusCode = this.status;
        final String reasonPhrase = this.message;
        return new Response.StatusType(){

            public int getStatusCode() {
                return statusCode;
            }

            public String getReasonPhrase() {
                return reasonPhrase;
            }

            public Response.Status.Family getFamily() {
                int family = statusCode / 100;
                if (family == 1) {
                    return Response.Status.Family.INFORMATIONAL;
                }
                if (family == 2) {
                    return Response.Status.Family.SUCCESSFUL;
                }
                if (family == 3) {
                    return Response.Status.Family.REDIRECTION;
                }
                if (family == 4) {
                    return Response.Status.Family.CLIENT_ERROR;
                }
                if (family == 5) {
                    return Response.Status.Family.SERVER_ERROR;
                }
                return Response.Status.Family.OTHER;
            }
        };
    }
}

