/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.internal.registry;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import org.apache.wink.common.RuntimeContext;
import org.apache.wink.common.internal.application.ApplicationValidator;
import org.apache.wink.common.internal.i18n.Messages;
import org.apache.wink.common.internal.lifecycle.LifecycleManagersRegistry;
import org.apache.wink.common.internal.lifecycle.ObjectFactory;
import org.apache.wink.common.internal.utils.AnnotationUtils;
import org.apache.wink.common.internal.utils.GenericsUtils;
import org.apache.wink.common.internal.utils.MediaTypeUtils;
import org.apache.wink.common.internal.utils.SoftConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProvidersRegistry {
    private static final Logger logger = LoggerFactory.getLogger(ProvidersRegistry.class);
    private final ProducesMediaTypeMap<ContextResolver<?>> contextResolvers = new ProducesMediaTypeMap(ContextResolver.class);
    private volatile TreeSet<ObjectFactory<ExceptionMapper<?>>> exceptionMappers = new TreeSet(Collections.reverseOrder());
    private final ConsumesMediaTypeMap<MessageBodyReader<?>> messageBodyReaders = new ConsumesMediaTypeMap(MessageBodyReader.class);
    private final ProducesMediaTypeMap<MessageBodyWriter<?>> messageBodyWriters = new ProducesMediaTypeMap(MessageBodyWriter.class);
    private final ApplicationValidator applicationValidator;
    private final LifecycleManagersRegistry factoryFactoryRegistry;

    public ProvidersRegistry(LifecycleManagersRegistry factoryRegistry, ApplicationValidator applicationValidator) {
        this.factoryFactoryRegistry = factoryRegistry;
        this.applicationValidator = applicationValidator;
    }

    public boolean addProvider(Class<?> cls, double priority) {
        return this.addProvider(cls, priority, false);
    }

    public boolean addProvider(Class<?> cls, double priority, boolean isSystemProvider) {
        if (cls == null) {
            throw new NullPointerException(Messages.getMessage("variableIsNull", "cls"));
        }
        ObjectFactory<?> objectFactory = this.factoryFactoryRegistry.getObjectFactory(cls);
        return this.addProvider(new PriorityObjectFactory(objectFactory, priority, isSystemProvider));
    }

    public boolean addProvider(Object provider, double priority) {
        return this.addProvider(provider, priority, false);
    }

    public boolean addProvider(Object provider, double priority, boolean isSystemProvider) {
        if (provider == null) {
            throw new NullPointerException(Messages.getMessage("variableIsNull", "provider"));
        }
        ObjectFactory<Object> objectFactory = this.factoryFactoryRegistry.getObjectFactory(provider);
        return this.addProvider(new PriorityObjectFactory<Object>(objectFactory, priority, isSystemProvider));
    }

    private synchronized boolean addProvider(PriorityObjectFactory<?> objectFactory) {
        Class<?> cls = objectFactory.getInstanceClass();
        logger.debug("Processing provider of type {}", cls);
        boolean retValue = false;
        if (!this.applicationValidator.isValidProvider(cls)) {
            return retValue;
        }
        if (ContextResolver.class.isAssignableFrom(cls)) {
            this.contextResolvers.putProvider(objectFactory);
            retValue = true;
        }
        if (ExceptionMapper.class.isAssignableFrom(cls)) {
            logger.debug("Adding type {} to ExceptionMappers list", cls);
            TreeSet exceptionMappersCopy = new TreeSet(Collections.reverseOrder());
            exceptionMappersCopy.addAll(this.exceptionMappers);
            exceptionMappersCopy.add(objectFactory);
            this.exceptionMappers = exceptionMappersCopy;
            retValue = true;
        }
        if (MessageBodyReader.class.isAssignableFrom(cls)) {
            this.messageBodyReaders.putProvider(objectFactory);
            retValue = true;
        }
        if (MessageBodyWriter.class.isAssignableFrom(cls)) {
            this.messageBodyWriters.putProvider(objectFactory);
            retValue = true;
        }
        if (!retValue && logger.isWarnEnabled()) {
            logger.warn(Messages.getMessage("classIsUnknownProvider", cls));
        }
        return retValue;
    }

    public boolean addProvider(Class<?> cls) {
        return this.addProvider(cls, 0.5);
    }

    public boolean addProvider(Object provider) {
        return this.addProvider(provider, 0.5);
    }

    public void removeAllProviders() {
        this.contextResolvers.removeAll();
        this.messageBodyReaders.removeAll();
        this.messageBodyWriters.removeAll();
        for (ObjectFactory<ExceptionMapper<?>> of : this.exceptionMappers) {
            of.releaseAll(null);
        }
    }

    public <T> ContextResolver<T> getContextResolver(final Class<T> contextType, MediaType mediaType, RuntimeContext runtimeContext) {
        if (contextType == null) {
            throw new NullPointerException(Messages.getMessage("variableIsNull", "contextType"));
        }
        logger.debug("Getting ContextResolver for {} which has @Produces compatible with {}", contextType, (Object)mediaType);
        if (mediaType == null) {
            mediaType = MediaType.WILDCARD_TYPE;
        }
        if (this.contextResolvers.isMapEmpty()) {
            logger.debug("ContextResolvers MediaTypeMap was empty so returning null");
            return null;
        }
        List factories = this.contextResolvers.getProvidersByMediaType(mediaType, contextType);
        if (factories.isEmpty()) {
            logger.debug("Did not find a ContextResolver for {} which has @Produces compatible with {}", contextType, (Object)mediaType);
            return null;
        }
        if (factories.size() == 1) {
            ObjectFactory factory = factories.get(0);
            logger.debug("Found ContextResolver ObjectFactory {} for {} which has @Produces compatible with {}", new Object[]{factory, contextType, mediaType});
            return (ContextResolver)factory.getInstance(runtimeContext);
        }
        final ArrayList providers = new ArrayList(factories.size());
        for (MediaTypeMap.OFHolder factory : factories) {
            providers.add(factory.getInstance(runtimeContext));
        }
        logger.debug("Found multiple ContextResolver ObjectFactories {} for {} which has @Produces compatible with {} .  Using Proxy object which will call all matching ContextResolvers to find correct context.", new Object[]{providers, contextType, mediaType});
        final MediaType mt = mediaType;
        return (ContextResolver)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{ContextResolver.class}, new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getName().equals("getContext") && args != null && args.length == 1 && (args[0] == null || args[0].getClass().equals(Class.class))) {
                    for (ContextResolver resolver : providers) {
                        Object context;
                        Class arg0 = (Class)args[0];
                        if (logger.isDebugEnabled()) {
                            logger.debug("Calling {}.getContext({}) to find context for {} with @Produces media type compatible with {}", new Object[]{resolver, arg0, contextType, mt});
                        }
                        if ((context = resolver.getContext(arg0)) == null) continue;
                        if (logger.isDebugEnabled()) {
                            logger.debug("Returning {} from calling {}.getContext({}) to find context for {} with @Produces media type compatible with {}", new Object[]{context, resolver, arg0, contextType, mt});
                        }
                        return context;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("Did not find context for {} with @Produces media type compatible with {}", new Object[]{contextType, mt});
                    }
                    return null;
                }
                return method.invoke(proxy, args);
            }
        });
    }

    public <T extends Throwable> ExceptionMapper<T> getExceptionMapper(Class<T> type, RuntimeContext runtimeContext) {
        if (type == null) {
            throw new NullPointerException(Messages.getMessage("variableIsNull", "type"));
        }
        logger.debug("Getting ExceptionMapper for {} ", type);
        ArrayList matchingMappers = new ArrayList();
        for (ObjectFactory<ExceptionMapper<?>> factory : this.exceptionMappers) {
            ExceptionMapper<?> exceptionMapper = factory.getInstance(runtimeContext);
            Type genericType = GenericsUtils.getGenericInterfaceParamType(exceptionMapper.getClass(), ExceptionMapper.class);
            Class<T> classType = GenericsUtils.getClassType(genericType);
            if (!classType.isAssignableFrom(type)) continue;
            matchingMappers.add(exceptionMapper);
        }
        if (matchingMappers.isEmpty()) {
            logger.debug("Did not find an ExceptionMapper for {} ", type);
            return null;
        }
        logger.debug("Found matching ExceptionMappers {} for type {} ", matchingMappers, type);
        while (matchingMappers.size() > 1) {
            Class<?> secondClass;
            Type first = GenericsUtils.getGenericInterfaceParamType(((ExceptionMapper)matchingMappers.get(0)).getClass(), ExceptionMapper.class);
            Type second = GenericsUtils.getGenericInterfaceParamType(((ExceptionMapper)matchingMappers.get(1)).getClass(), ExceptionMapper.class);
            Class<?> firstClass = GenericsUtils.getClassType(first);
            if (firstClass == (secondClass = GenericsUtils.getClassType(second))) {
                matchingMappers.remove(1);
                continue;
            }
            if (firstClass.isAssignableFrom(secondClass)) {
                matchingMappers.remove(0);
                continue;
            }
            matchingMappers.remove(1);
        }
        ExceptionMapper mapper = (ExceptionMapper)matchingMappers.get(0);
        logger.debug("Found best matching ExceptionMapper {} for type {} ", (Object)mapper, type);
        return mapper;
    }

    public <T> MessageBodyReader<T> getMessageBodyReader(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, RuntimeContext runtimeContext) {
        if (type == null) {
            throw new NullPointerException(Messages.getMessage("variableIsNull", "type"));
        }
        if (mediaType == null) {
            throw new NullPointerException(Messages.getMessage("variableIsNull", "mediaType"));
        }
        if (logger.isDebugEnabled()) {
            List<Annotation> anns = annotations == null ? null : Arrays.asList(annotations);
            logger.debug("Getting MessageBodyReader for class type {}, genericType {}, annotations {}, and media type {}", new Object[]{type, genericType, anns, mediaType});
        }
        List factories = this.messageBodyReaders.getProvidersByMediaType(mediaType, type);
        logger.debug("Found possible MessageBodyReader ObjectFactories {}", factories);
        for (MediaTypeMap.OFHolder factory : factories) {
            List<Annotation> anns;
            MessageBodyReader reader = (MessageBodyReader)factory.getInstance(runtimeContext);
            if (logger.isDebugEnabled()) {
                anns = annotations == null ? null : Arrays.asList(annotations);
                logger.debug("Calling {}.isReadable( {}, {}, {}, {} )", new Object[]{reader, type, genericType, anns, mediaType});
            }
            if (!reader.isReadable(type, genericType, annotations, mediaType)) continue;
            if (logger.isDebugEnabled()) {
                anns = annotations == null ? null : Arrays.asList(annotations);
                logger.debug("{}.isReadable( {}, {}, {}, {} ) returned true", new Object[]{reader, type, genericType, anns, mediaType});
            }
            return reader;
        }
        return null;
    }

    public <T> MessageBodyWriter<T> getMessageBodyWriter(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, RuntimeContext runtimeContext) {
        if (type == null) {
            throw new NullPointerException(Messages.getMessage("variableIsNull", "type"));
        }
        if (mediaType == null) {
            throw new NullPointerException(Messages.getMessage("variableIsNull", "mediaType"));
        }
        if (logger.isDebugEnabled()) {
            List<Annotation> anns = annotations == null ? null : Arrays.asList(annotations);
            logger.debug("Getting MessageBodyWriter for class type {}, genericType {}, annotations {}, and media type {}", new Object[]{type, genericType, anns, mediaType});
        }
        List writersFactories = this.messageBodyWriters.getProvidersByMediaType(mediaType, type);
        logger.debug("Found possible MessageBodyWriter ObjectFactories {}", writersFactories);
        for (MediaTypeMap.OFHolder factory : writersFactories) {
            List<Annotation> anns;
            MessageBodyWriter writer = (MessageBodyWriter)factory.getInstance(runtimeContext);
            if (logger.isDebugEnabled()) {
                anns = annotations == null ? null : Arrays.asList(annotations);
                logger.debug("Calling {}.isWriteable( {}, {}, {}, {} )", new Object[]{writer, type, genericType, anns, mediaType});
            }
            if (!writer.isWriteable(type, genericType, annotations, mediaType)) continue;
            if (logger.isDebugEnabled()) {
                anns = annotations == null ? null : Arrays.asList(annotations);
                logger.debug("{}.isWriteable( {}, {}, {}, {} ) returned true", new Object[]{writer, type, genericType, anns, mediaType});
            }
            return writer;
        }
        if (logger.isDebugEnabled()) {
            List<Annotation> anns = annotations == null ? null : Arrays.asList(annotations);
            logger.debug("No MessageBodyWriter returned true for isWriteable( {}, {}, {}, {} )", new Object[]{type, genericType, anns, mediaType});
        }
        return null;
    }

    public Set<MediaType> getMessageBodyReaderMediaTypesLimitByIsReadable(Class<?> type, RuntimeContext runtimeContext) {
        HashSet<MediaType> mediaTypes = new HashSet<MediaType>();
        logger.debug("Searching MessageBodyReaders media types limited by class type {}", type);
        List readerFactories = this.messageBodyReaders.getProvidersByMediaType(MediaType.WILDCARD_TYPE, type);
        logger.debug("Found all MessageBodyReader ObjectFactories limited by class type {}", readerFactories);
        Annotation[] ann = new Annotation[]{};
        for (MediaTypeMap.OFHolder factory : readerFactories) {
            MessageBodyReader reader = (MessageBodyReader)factory.getInstance(runtimeContext);
            Consumes consumes = factory.getInstanceClass().getAnnotation(Consumes.class);
            String[] values = null;
            values = consumes != null ? AnnotationUtils.parseConsumesProducesValues(consumes.value()) : new String[]{"*/*"};
            for (String v : values) {
                MediaType mt = MediaType.valueOf((String)v);
                if (logger.isDebugEnabled()) {
                    List<Annotation> anns = ann == null ? null : Arrays.asList(ann);
                    logger.debug("Calling {}.isReadable( {}, {}, {}, {} )", new Object[]{reader, type, type, anns, mt});
                }
                if (!reader.isReadable(type, type, ann, mt)) continue;
                logger.debug("Adding {} to media type set", (Object)mt);
                mediaTypes.add(mt);
            }
        }
        logger.debug("Found {} from @Consumes values from all MessageBodyReader ObjectFactories compatible with Java type {}", mediaTypes, type);
        return mediaTypes;
    }

    public MediaType getMessageBodyWriterMediaTypeLimitByIsWritable(Class<?> type, RuntimeContext runtimeContext) {
        ArrayList mediaTypes = new ArrayList();
        logger.debug("Searching MessageBodyWriters media types limited by class type {}", type);
        List writerFactories = this.messageBodyWriters.getProvidersByMediaType(MediaType.WILDCARD_TYPE, type);
        logger.debug("Found all MessageBodyWriter ObjectFactories limited by class type {}", writerFactories);
        Annotation[] ann = new Annotation[]{};
        for (MediaTypeMap.OFHolder factory : writerFactories) {
            MessageBodyWriter writer = (MessageBodyWriter)factory.getInstance(runtimeContext);
            Produces produces = factory.getInstanceClass().getAnnotation(Produces.class);
            String[] values = null;
            values = produces != null ? AnnotationUtils.parseConsumesProducesValues(produces.value()) : new String[]{"*/*"};
            for (String v : values) {
                MediaType mt = MediaType.valueOf((String)v);
                if (logger.isDebugEnabled()) {
                    List<Annotation> anns = ann == null ? null : Arrays.asList(ann);
                    logger.debug("Calling {}.isWritable( {}, {}, {}, {} )", new Object[]{writer, type, type, anns, mt});
                }
                if (!writer.isWriteable(type, type, ann, mt)) continue;
                logger.debug("Returning media type {}", (Object)mt);
                return mt;
            }
        }
        return null;
    }

    public Set<MediaType> getMessageBodyWriterMediaTypes(Class<?> type) {
        if (type == null) {
            throw new NullPointerException(Messages.getMessage("variableIsNull", "type"));
        }
        Set<MediaType> mediaTypes = this.messageBodyWriters.getProvidersMediaTypes(type);
        return mediaTypes;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PriorityObjectFactory<T>
    implements ObjectFactory<T>,
    Comparable<PriorityObjectFactory<T>> {
        private final ObjectFactory<T> of;
        private final double priority;
        final boolean isSystemProvider;
        private static double counter = 1.0E-11;
        private static final double inc = 1.0E-11;

        public PriorityObjectFactory(ObjectFactory<T> of, double priority, boolean isSystemProvider) {
            this.of = of;
            this.priority = priority + (counter += 1.0E-11);
            this.isSystemProvider = isSystemProvider;
        }

        @Override
        public T getInstance(RuntimeContext context) {
            return this.of.getInstance(context);
        }

        @Override
        public Class<T> getInstanceClass() {
            return this.of.getInstanceClass();
        }

        @Override
        public void releaseInstance(T instance, RuntimeContext context) {
            this.of.releaseInstance(instance, context);
        }

        @Override
        public void releaseAll(RuntimeContext context) {
            this.of.releaseAll(context);
        }

        @Override
        public int compareTo(PriorityObjectFactory<T> o) {
            return Double.compare(this.priority, o.priority);
        }

        public String toString() {
            return String.format("Priority: %f, ObjectFactory: %s", this.priority, this.of);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class MediaTypeMap<T> {
        private volatile HashMap<MediaType, HashSet<PriorityObjectFactory<T>>> data = new HashMap();
        private volatile Map.Entry<MediaType, HashSet<PriorityObjectFactory<T>>>[] entrySet = this.data.entrySet().toArray(new Map.Entry[0]);
        private final Class<?> rawType;
        private final SoftConcurrentMap<Class<?>, SoftConcurrentMap<MediaType, List<OFHolder<T>>>> providersCache = new SoftConcurrentMap();

        public MediaTypeMap(Class<?> rawType) {
            this.rawType = rawType;
        }

        boolean isMapEmpty() {
            return this.data.isEmpty();
        }

        synchronized void removeAll() {
            Map.Entry<MediaType, HashSet<PriorityObjectFactory<T>>>[] oldEntrySet = this.entrySet;
            this.entrySet = this.data.entrySet().toArray(new Map.Entry[0]);
            this.data = new HashMap();
            this.providersCache.clear();
            for (Map.Entry<MediaType, HashSet<PriorityObjectFactory<T>>> entry : oldEntrySet) {
                HashSet<PriorityObjectFactory<T>> set = entry.getValue();
                for (PriorityObjectFactory<T> of : set) {
                    of.releaseAll(null);
                }
            }
        }

        public List<OFHolder<T>> getProvidersByMediaType(MediaType mediaType, Class<?> cls) {
            String subtype = mediaType.getSubtype();
            String type = mediaType.getType();
            if (!mediaType.getParameters().isEmpty()) {
                mediaType = new MediaType(type, subtype);
            }
            logger.debug("Getting providers by media type by calling getProvidersByMediaType({}, {})", (Object)mediaType, cls);
            SoftConcurrentMap<Object, List<OFHolder<Object>>> mediaTypeToProvidersCache = this.providersCache.get(cls);
            if (mediaTypeToProvidersCache == null) {
                logger.debug("MediaType to providers cache for class {} does not exist so creating", cls);
                mediaTypeToProvidersCache = new SoftConcurrentMap();
                this.providersCache.put(cls, mediaTypeToProvidersCache);
            }
            List<OFHolder<T>> list = mediaTypeToProvidersCache.get(mediaType);
            logger.debug("Get media type to providers cache for media type {} resulted in {}", (Object)mediaType, list);
            if (list == null) {
                list = this.internalGetProvidersByMediaType(mediaType, cls);
                mediaTypeToProvidersCache.put(mediaType, list);
            }
            return list;
        }

        private List<OFHolder<T>> internalGetProvidersByMediaType(MediaType mediaType, Class<?> cls) {
            TreeSet<OFHolder> compatible = new TreeSet<OFHolder>(Collections.reverseOrder());
            for (Map.Entry<MediaType, HashSet<PriorityObjectFactory<T>>> entry : this.entrySet) {
                if (!entry.getKey().isCompatible(mediaType)) continue;
                for (PriorityObjectFactory<T> of : entry.getValue()) {
                    if (!GenericsUtils.isGenericInterfaceAssignableFrom(cls, of.getInstanceClass(), this.rawType)) continue;
                    compatible.add(new OFHolder<T>(entry.getKey(), of, of.isSystemProvider));
                }
            }
            OFHolder[] tmp = compatible.toArray(new OFHolder[compatible.size()]);
            return Arrays.asList(tmp);
        }

        public Set<MediaType> getProvidersMediaTypes(Class<?> type) {
            HashSet<MediaType> mediaTypes = new HashSet<MediaType>();
            block0: for (Map.Entry<MediaType, HashSet<PriorityObjectFactory<T>>> entry : this.data.entrySet()) {
                MediaType mediaType = entry.getKey();
                Set set = entry.getValue();
                for (PriorityObjectFactory t : set) {
                    if (!GenericsUtils.isGenericInterfaceAssignableFrom(type, t.getInstanceClass(), this.rawType)) continue;
                    mediaTypes.add(mediaType);
                    continue block0;
                }
            }
            return mediaTypes;
        }

        synchronized void put(MediaType key, PriorityObjectFactory<T> objectFactory) {
            HashSet<PriorityObjectFactory<Object>> set;
            HashMap<MediaType, HashSet<PriorityObjectFactory<T>>> copyOfMap = new HashMap<MediaType, HashSet<PriorityObjectFactory<T>>>(this.data);
            if (!key.getParameters().isEmpty()) {
                key = new MediaType(key.getType(), key.getSubtype());
            }
            set = (set = this.data.get(key)) == null ? new HashSet() : new HashSet<PriorityObjectFactory<T>>(set);
            copyOfMap.put(key, set);
            if (!set.add(objectFactory)) {
                if (logger.isWarnEnabled()) {
                    logger.warn(Messages.getMessage("mediaTypeSetAlreadyContains", objectFactory));
                }
            } else {
                Object[] newEntrySet = copyOfMap.entrySet().toArray(new Map.Entry[0]);
                Arrays.sort(newEntrySet, Collections.reverseOrder(new Comparator<Map.Entry<MediaType, HashSet<PriorityObjectFactory<T>>>>(){

                    @Override
                    public int compare(Map.Entry<MediaType, HashSet<PriorityObjectFactory<T>>> o1, Map.Entry<MediaType, HashSet<PriorityObjectFactory<T>>> o2) {
                        return MediaTypeUtils.compareTo(o1.getKey(), o2.getKey());
                    }
                }));
                if (logger.isDebugEnabled()) {
                    logger.debug("Added ObjectFactory {} with MediaType {} to MediaTypeMap {}", new Object[]{objectFactory, key, this});
                    logger.debug("EntrySet is {}", newEntrySet);
                }
                this.entrySet = newEntrySet;
                this.data = copyOfMap;
                this.providersCache.clear();
                logger.debug("Cleared the providers cache");
            }
        }

        public String toString() {
            return this.toString("  ");
        }

        protected String toString(String indent) {
            StringBuffer sb = new StringBuffer();
            sb.append("\nRawType: ");
            sb.append(String.valueOf(this.rawType));
            sb.append("\nData Map: ");
            if (this.data.isEmpty()) {
                sb.append("{empty}");
            } else {
                sb.append("\n");
            }
            for (MediaType k : this.data.keySet()) {
                sb.append("MediaType key = ");
                sb.append(k);
                sb.append("\n");
                sb.append("ObjectFactory Set value = {\n");
                for (PriorityObjectFactory<T> of : this.data.get(k)) {
                    sb.append(indent);
                    sb.append(of);
                    sb.append("\n");
                }
                sb.append("}\n");
            }
            return sb.toString();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class OFHolder<T>
        implements ObjectFactory<T>,
        Comparable<OFHolder<T>> {
            private final PriorityObjectFactory<T> of;
            private final MediaType mediaType;
            private final Class<?> genericType;
            private final boolean isSystemProvider;

            public OFHolder(MediaType mediaType, PriorityObjectFactory<T> of, boolean isSystemProvider) {
                this.of = of;
                this.mediaType = mediaType;
                this.isSystemProvider = isSystemProvider;
                this.genericType = GenericsUtils.getClassType(GenericsUtils.getGenericInterfaceParamType(of.getInstanceClass(), MediaTypeMap.this.rawType));
            }

            public String toString() {
                return "OFHolder [" + (this.genericType != null ? "genericType=" + this.genericType + ", " : "") + (this.mediaType != null ? "mediaType=" + this.mediaType + ", " : "") + (this.of != null ? "of=" + this.of : "") + "]";
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + (this.of == null ? 0 : this.of.hashCode());
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                OFHolder other = (OFHolder)obj;
                return !(this.of == null ? other.of != null : this.of != other.of);
            }

            @Override
            public T getInstance(RuntimeContext context) {
                return this.of.getInstance(context);
            }

            @Override
            public Class<T> getInstanceClass() {
                return this.of.getInstanceClass();
            }

            @Override
            public void releaseInstance(T instance, RuntimeContext context) {
                this.of.releaseInstance(instance, context);
            }

            @Override
            public void releaseAll(RuntimeContext context) {
                this.of.releaseAll(context);
            }

            @Override
            public int compareTo(OFHolder<T> o) {
                int compare;
                if (this.isSystemProvider) {
                    if (!o.isSystemProvider) {
                        return -1;
                    }
                } else if (o.isSystemProvider && !this.isSystemProvider) {
                    return 1;
                }
                if ((compare = MediaTypeUtils.compareTo(this.mediaType, o.mediaType)) != 0) {
                    return compare;
                }
                if (this.genericType != o.genericType) {
                    if (this.genericType.isAssignableFrom(o.genericType)) {
                        return -1;
                    }
                    return 1;
                }
                return Double.compare(((PriorityObjectFactory)this.of).priority, ((PriorityObjectFactory)o.of).priority);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConsumesMediaTypeMap<T>
    extends MediaTypeMap<T> {
        public ConsumesMediaTypeMap(Class<?> rawType) {
            super(rawType);
        }

        public void putProvider(PriorityObjectFactory<T> objectFactory) {
            Consumes consumes = objectFactory.getInstanceClass().getAnnotation(Consumes.class);
            if (consumes == null) {
                this.put(MediaType.WILDCARD_TYPE, objectFactory);
            } else {
                String[] values;
                for (String val : values = AnnotationUtils.parseConsumesProducesValues(consumes.value())) {
                    this.put(MediaType.valueOf((String)val), objectFactory);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ProducesMediaTypeMap<T>
    extends MediaTypeMap<T> {
        public ProducesMediaTypeMap(Class<?> rawType) {
            super(rawType);
        }

        public void putProvider(PriorityObjectFactory<T> objectFactory) {
            Produces produces = objectFactory.getInstanceClass().getAnnotation(Produces.class);
            if (produces == null) {
                this.put(MediaType.WILDCARD_TYPE, objectFactory);
            } else {
                String[] values;
                for (String val : values = AnnotationUtils.parseConsumesProducesValues(produces.value())) {
                    this.put(MediaType.valueOf((String)val), objectFactory);
                }
            }
        }
    }
}

