/*******************************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *  
 *   http://www.apache.org/licenses/LICENSE-2.0
 *  
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 *  
 *******************************************************************************/
//
// This file was generated by the JavaTM Architecture for XML Binding(JAXB) Reference Implementation, v2.1.1-b02-fcs 
// See <a href="http://java.sun.com/xml/jaxb">http://java.sun.com/xml/jaxb</a> 
// Any modifications to this file will be lost upon recompilation of the source schema. 
// Generated on: 2008.09.15 at 12:57:27 PM IDT 
//

package org.apache.wink.common.model.app;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlAccessOrder;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorOrder;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

import org.apache.wink.common.model.atom.AtomCommonAttributes;
import org.apache.wink.common.model.atom.AtomText;
import org.w3c.dom.Element;

/**
 * The "app:workspace" Element Per RFC5023
 * 
 * <pre>
 * The &quot;app:workspace&quot; Element
 * Workspaces are server-defined groups of Collections.  
 * The &quot;app:workspace&quot; element contains zero or more app:collection elements
 * describing the Collections of Resources available for editing.
 * appWorkspace =
 *    element app:workspace {
 *       appCommonAttributes,
 *       ( atomTitle
 *         &amp; appCollection*
 *         &amp; extensionSansTitleElement* )
 *    }
 * atomTitle = element atom:title { atomTextConstruct }
 * 
 * o The &quot;atom:title&quot; Element
 * 
 *   The app:workspace element MUST contain one &quot;atom:title&quot; element (as
 *   defined in [RFC4287]), giving a human-readable title for the
 *   Workspace.
 * </pre>
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlAccessorOrder(XmlAccessOrder.UNDEFINED)
@XmlType(name = "appWorkspace", propOrder = {"title", "collection", "any"})
public class AppWorkspace extends AtomCommonAttributes {

    @XmlElement(namespace = "http://www.w3.org/2005/Atom", required = true)
    protected AtomText            title;
    protected List<AppCollection> collection;
    @XmlAnyElement
    protected List<Element>       any;

    /**
     * Gets the value of title.
     */
    public AtomText getTitle() {
        return title;
    }

    /**
     * Sets the value of title.
     */
    public void setTitle(AtomText value) {
        this.title = value;
    }

    /**
     * Gets the collections.
     * <p>
     * This accessor method returns a reference to the live list, not a
     * snapshot. Therefore any modification you make to the returned list will
     * be present inside the JAXB object. This is why there is not a
     * <CODE>set</CODE> method for the collection.
     * <p>
     * For example, to add a new item, do as follows:
     * 
     * <pre>
     * getCollection().add(newItem);
     * </pre>
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AppCollection }
     */
    public List<AppCollection> getCollection() {
        if (collection == null) {
            collection = new ArrayList<AppCollection>();
        }
        return this.collection;
    }

    public AppCollection getCollection(String name) {
        if (name == null) {
            return null;
        }

        List<AppCollection> collections = getCollection();
        for (AppCollection collection : collections) {
            if (name.equals(collection.getTitle().getValue())) {
                return collection;
            }
        }
        return null;
    }

    /**
     * Gets extension elements.
     * <p>
     * This accessor method returns a reference to the live list, not a
     * snapshot. Therefore any modification you make to the returned list will
     * be present inside the JAXB object. This is why there is not a
     * <CODE>set</CODE> method for the any.
     * <p>
     * For example, to add a new item, do as follows:
     * 
     * <pre>
     * getAny().add(newItem);
     * </pre>
     * <p>
     * Objects of the following type(s) are allowed in the list {@link Element }
     */
    public List<Element> getAny() {
        if (any == null) {
            any = new ArrayList<Element>();
        }
        return this.any;
    }

}
