/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.providers.json;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;
import org.apache.wink.common.annotations.Scope;
import org.apache.wink.common.internal.providers.entity.xml.JAXBXmlProvider;
import org.apache.wink.common.internal.utils.MediaTypeUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.XML;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value=Scope.ScopeType.PROTOTYPE)
@Provider
@Produces(value={"application/json", "application/javascript"})
@Consumes(value={"application/json", "application/javascript"})
public class JsonJAXBProvider
implements MessageBodyWriter<Object>,
MessageBodyReader<Object> {
    @Context
    private Providers providers;
    private MessageBodyWriter<JSONObject> bodyWriter;
    private MessageBodyReader<JSONObject> bodyReader;

    public long getSize(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (!JAXBXmlProvider.isJAXBObject(type, (Type)genericType) && !JAXBXmlProvider.isJAXBElement(type, (Type)genericType)) {
            return false;
        }
        this.bodyWriter = this.providers.getMessageBodyWriter(JSONObject.class, JSONObject.class, annotations, mediaType);
        return this.bodyWriter != null;
    }

    public void writeTo(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        try {
            mediaType = MediaTypeUtils.setDefaultCharsetOnMediaTypeHeader(httpHeaders, (MediaType)mediaType);
            MessageBodyWriter jaxbWriter = this.providers.getMessageBodyWriter(type, genericType, annotations, MediaType.APPLICATION_XML_TYPE);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            jaxbWriter.writeTo(t, type, genericType, annotations, MediaType.APPLICATION_XML_TYPE, httpHeaders, (OutputStream)os);
            JSONObject json = XML.toJSONObject((String)os.toString());
            this.bodyWriter.writeTo((Object)json, JSONObject.class, JSONObject.class, annotations, mediaType, httpHeaders, entityStream);
        }
        catch (JSONException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (!JAXBXmlProvider.isJAXBObject(type, (Type)genericType) && !JAXBXmlProvider.isJAXBElement(type, (Type)genericType)) {
            return false;
        }
        this.bodyReader = this.providers.getMessageBodyReader(JSONObject.class, JSONObject.class, annotations, mediaType);
        return this.bodyReader != null;
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        try {
            JSONObject json = (JSONObject)this.bodyReader.readFrom(JSONObject.class, JSONObject.class, annotations, mediaType, httpHeaders, entityStream);
            String xml = XML.toString((Object)json);
            MessageBodyReader jaxbReader = this.providers.getMessageBodyReader(type, genericType, annotations, MediaType.APPLICATION_XML_TYPE);
            return jaxbReader.readFrom(type, genericType, annotations, MediaType.APPLICATION_XML_TYPE, httpHeaders, (InputStream)new ByteArrayInputStream(xml.getBytes()));
        }
        catch (JSONException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
        }
    }
}

