/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.server.internal.contexts;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.servlet.FilterConfig;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.wink.common.internal.MultivaluedMapImpl;
import org.apache.wink.common.internal.PathSegmentImpl;
import org.apache.wink.common.internal.i18n.Messages;
import org.apache.wink.common.internal.runtime.RuntimeContextTLS;
import org.apache.wink.common.internal.uri.UriEncoder;
import org.apache.wink.common.internal.utils.UriHelper;
import org.apache.wink.server.handlers.MessageContext;
import org.apache.wink.server.internal.handlers.SearchResult;
import org.apache.wink.server.internal.registry.ResourceInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UriInfoImpl
implements UriInfo {
    private static final Logger logger = LoggerFactory.getLogger(UriInfoImpl.class);
    private MessageContext messageContext;
    private URI absolutePath;
    private URI baseUri;
    private String baseUriString;
    private String path;
    private MultivaluedMap<String, String> pathParameters;
    private MultivaluedMap<String, String> decodedPathParameters;
    private MultivaluedMap<String, String> queryParameters;
    private MultivaluedMap<String, String> decodedQueryParameters;
    private List<PathSegment> pathSegments;
    private List<PathSegment> decodedPathSegments;
    private List<String> matchedURIsStrings;
    private List<String> decodedMatchedURIsStrings;

    public UriInfoImpl(MessageContext msgContext) {
        this.messageContext = msgContext;
        this.absolutePath = null;
        this.baseUri = null;
        this.baseUriString = null;
        this.path = null;
        this.pathParameters = null;
        this.pathSegments = null;
        this.decodedPathSegments = null;
        this.matchedURIsStrings = null;
        this.decodedMatchedURIsStrings = null;
    }

    public URI getAbsolutePath() {
        if (this.absolutePath == null) {
            String requestPath = this.getPath(false);
            this.absolutePath = this.getBaseUri().resolve(requestPath);
        }
        logger.debug("getAbsolutePath() returning: {}", (Object)this.absolutePath);
        return this.absolutePath;
    }

    public UriBuilder getAbsolutePathBuilder() {
        UriBuilder builder = UriBuilder.fromUri((URI)this.getAbsolutePath());
        logger.debug("getAbsolutePathBuilder() returning: {}", (Object)builder);
        return builder;
    }

    public URI getBaseUri() {
        block3: {
            if (this.baseUri == null) {
                String baseUriString = this.getBaseUriString();
                try {
                    this.baseUri = new URI(baseUriString);
                }
                catch (URISyntaxException e) {
                    if (!logger.isErrorEnabled()) break block3;
                    logger.error(Messages.getMessage((String)"uriBadBaseURI", (Object[])new Object[]{baseUriString}), (Throwable)e);
                }
            }
        }
        logger.debug("getBaseUri() returning: {}", (Object)this.baseUri);
        return this.baseUri;
    }

    public UriBuilder getBaseUriBuilder() {
        UriBuilder builder = UriBuilder.fromUri((URI)this.getBaseUri());
        logger.debug("getBaseUriBuilder() returning: {}", (Object)builder);
        return builder;
    }

    public List<ResourceInstance> getMatchedResourceInstances() {
        List<ResourceInstance> resources = Collections.unmodifiableList(((SearchResult)this.messageContext.getAttribute(SearchResult.class)).getData().getMatchedResources());
        logger.debug("getMatchedResourceInstances() returning: {}", resources);
        return resources;
    }

    public List<Object> getMatchedResources() {
        LinkedList<ResourceInstance> matchedResources = ((SearchResult)this.messageContext.getAttribute(SearchResult.class)).getData().getMatchedResources();
        ArrayList<Object> resourceList = new ArrayList<Object>(matchedResources.size());
        for (ResourceInstance resourceInstance : matchedResources) {
            resourceList.add(resourceInstance.getInstance(this.messageContext));
        }
        logger.debug("getMatchedResources() returning: {}", resourceList);
        return Collections.unmodifiableList(resourceList);
    }

    public List<String> getMatchedURIs() {
        return this.getMatchedURIs(true);
    }

    public List<String> getMatchedURIs(boolean decode) {
        logger.debug("getMatchedURIs({}) called", (Object)decode);
        LinkedList<List<PathSegment>> matchedURIs = ((SearchResult)this.messageContext.getAttribute(SearchResult.class)).getData().getMatchedURIs();
        if (this.matchedURIsStrings != null && this.matchedURIsStrings.size() != matchedURIs.size()) {
            this.matchedURIsStrings = null;
            this.decodedMatchedURIsStrings = null;
        }
        if (this.matchedURIsStrings == null) {
            this.matchedURIsStrings = new ArrayList<String>(matchedURIs.size());
            for (List list : matchedURIs) {
                logger.debug("Adding matched URI: {}", (Object)list);
                this.matchedURIsStrings.add(PathSegmentImpl.toString((List)list));
            }
        }
        List<String> list = this.matchedURIsStrings;
        if (decode) {
            if (this.decodedMatchedURIsStrings == null) {
                this.decodedMatchedURIsStrings = new ArrayList<String>(this.matchedURIsStrings.size());
                for (String uri : this.matchedURIsStrings) {
                    String decodedUri = UriEncoder.decodeString((String)uri);
                    this.decodedMatchedURIsStrings.add(decodedUri);
                    logger.debug("Adding decoded URI: {} from URI: {}", (Object)decodedUri, (Object)uri);
                }
            }
            list = this.decodedMatchedURIsStrings;
        }
        logger.debug("getMatchedURIs({}) returning {}", (Object)decode, list);
        return Collections.unmodifiableList(list);
    }

    public String getPath() {
        return this.getPath(true);
    }

    public String getPath(boolean decode) {
        logger.debug("getPath({}) called", (Object)decode);
        if (this.path == null) {
            this.path = UriInfoImpl.buildRequestPath((HttpServletRequest)this.messageContext.getAttribute(HttpServletRequest.class));
        }
        if (decode) {
            String decodedPath = UriEncoder.decodeString((String)this.path);
            logger.debug("getPath({}) returning {}", (Object)decode, (Object)decodedPath);
            return decodedPath;
        }
        logger.debug("getPath({}) returning {}", (Object)decode, (Object)this.path);
        return this.path;
    }

    public MultivaluedMap<String, String> getPathParameters() {
        return this.getPathParameters(true);
    }

    public MultivaluedMap<String, String> getPathParameters(boolean decode) {
        logger.debug("getPathParameters({}) called", (Object)decode);
        if (this.pathParameters == null) {
            this.pathParameters = new MultivaluedMapImpl();
            SearchResult searchResult = (SearchResult)this.messageContext.getAttribute(SearchResult.class);
            if (searchResult == null) {
                throw new IllegalStateException(Messages.getMessage((String)"methodCallOutsideScopeOfRequestContext"));
            }
            MultivaluedMapImpl.copy(searchResult.getData().getMatchedVariables(), this.pathParameters);
            logger.debug("getPathParameters({}) encoded path parameters are: {}", (Object)decode, this.pathParameters);
        }
        MultivaluedMap<String, String> map = this.pathParameters;
        if (decode) {
            if (this.decodedPathParameters == null) {
                this.decodedPathParameters = UriEncoder.decodeMultivaluedMapValues(this.pathParameters);
            }
            map = this.decodedPathParameters;
        }
        logger.debug("getPathParameters({}) returning {}", (Object)decode, map);
        return map;
    }

    public void resetPathParameters() {
        this.pathParameters = null;
    }

    public List<PathSegment> getPathSegments() {
        return this.getPathSegments(true);
    }

    public List<PathSegment> getPathSegments(boolean decode) {
        logger.debug("getPathSegments({}) called", (Object)decode);
        if (this.pathSegments == null) {
            this.pathSegments = UriHelper.parsePath((String)this.getPath(false));
            logger.debug("getPathSegments({}) encoded path parameters are: {}", (Object)decode, this.pathSegments);
        }
        List<PathSegment> list = this.pathSegments;
        if (decode) {
            if (this.decodedPathSegments == null) {
                this.decodedPathSegments = UriHelper.parsePath((String)this.getPath(true));
            }
            list = this.decodedPathSegments;
        }
        logger.debug("getPathSegments({}) returning {}", (Object)decode, list);
        return list;
    }

    public MultivaluedMap<String, String> getQueryParameters() {
        return this.getQueryParameters(true);
    }

    public MultivaluedMap<String, String> getQueryParameters(boolean decode) {
        logger.debug("getQueryParameters({}) called", (Object)decode);
        if (this.queryParameters == null) {
            this.queryParameters = new MultivaluedMapImpl();
            String query = ((HttpServletRequest)this.messageContext.getAttribute(HttpServletRequest.class)).getQueryString();
            logger.debug("getQueryParameters({}) query string is: {}", (Object)decode, (Object)query);
            this.queryParameters = UriHelper.parseQuery((String)query);
            logger.debug("getQueryParameters({}) encoded query parameters are: {}", (Object)decode, this.queryParameters);
        }
        MultivaluedMap<String, String> map = this.queryParameters;
        if (decode) {
            if (this.decodedQueryParameters == null) {
                this.decodedQueryParameters = UriEncoder.decodeMultivaluedMapValues(this.queryParameters);
            }
            map = this.decodedQueryParameters;
        }
        logger.debug("getQueryParameters({}) returning {}", (Object)decode, map);
        return map;
    }

    public URI getRequestUri() {
        logger.debug("getRequestUri() called");
        UriBuilder builder = this.getAbsolutePathBuilder();
        String query = ((HttpServletRequest)this.messageContext.getAttribute(HttpServletRequest.class)).getQueryString();
        logger.debug("getRequestUri() query string: {}", (Object)query);
        builder.replaceQuery(query);
        logger.debug("getRequestUri() build after query replacement: {}", (Object)builder);
        URI uri = builder.build(new Object[0]);
        logger.debug("getRequestUri() returning: {}", (Object)uri);
        return uri;
    }

    public UriBuilder getRequestUriBuilder() {
        UriBuilder builder = UriBuilder.fromUri((URI)this.getRequestUri());
        logger.debug("getRequestUriBuilder() returning: {}", (Object)builder);
        return builder;
    }

    private String getBaseUriString() {
        if (this.baseUriString == null) {
            this.baseUriString = this.buildBaseUriString((HttpServletRequest)this.messageContext.getAttribute(HttpServletRequest.class), this.messageContext.getProperties());
        }
        logger.debug("getBaseUriString() returned {}", (Object)this.baseUriString);
        return this.baseUriString;
    }

    private String buildBaseUriString(HttpServletRequest request, Properties properties) {
        String httpURI = this.getURI(properties, "wink.http.uri");
        String httpsURI = this.getURI(properties, "wink.https.uri");
        if (httpURI != null || httpsURI != null) {
            if (httpsURI == null) {
                throw new IllegalStateException(Messages.getMessage((String)"parameterHttpsIsEmptyOrNotInitialized"));
            }
            if (httpURI == null) {
                throw new IllegalStateException(Messages.getMessage((String)"parameterHttpIsEmptyOrNotInitialized"));
            }
        } else {
            logger.debug("Endpoint is not set up in the configuration; using request detection");
        }
        String baseURI = httpURI;
        if (request.isSecure()) {
            logger.debug("buildBaseUriString request is secure");
            baseURI = httpsURI;
        }
        logger.debug("buildBaseUriString baseURI from properties is: {}", (Object)baseURI);
        if (baseURI == null) {
            baseURI = UriInfoImpl.autodetectBaseUri(request);
            logger.debug("buildBaseUriString baseURI from autodetectBaseUri is: {}", (Object)baseURI);
        }
        return this.appendContextAndServletPath(baseURI, request, properties);
    }

    private String getURI(Properties properties, String propertyName) {
        String uri = properties.getProperty(propertyName);
        logger.debug("getURI({}, {}) called", (Object)properties, (Object)propertyName);
        if (uri != null && uri.length() != 0) {
            try {
                URI uriParsed = new URI(uri);
                logger.debug("getURI({}, {}) returning {}", new Object[]{properties, propertyName, uriParsed});
                return uriParsed.toString();
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(Messages.getMessage((String)"uriInfoInvalidURI"), e);
            }
        }
        logger.debug("getURI({}, {}) returning null", (Object)properties, (Object)propertyName);
        return null;
    }

    private static String autodetectBaseUri(HttpServletRequest request) {
        try {
            return new URI(request.getScheme(), null, request.getServerName(), request.getServerPort(), "/", null, null).toString();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    private String appendContextAndServletPath(String basePath, HttpServletRequest request, Properties properties) {
        String contextURI;
        String contextPath;
        logger.debug("appendContextAndServletPath({}, {}, {}) called", new Object[]{basePath, request, properties});
        StringBuilder builder = new StringBuilder(basePath);
        if (builder.charAt(builder.length() - 1) == '/') {
            builder.deleteCharAt(builder.length() - 1);
        }
        String string = contextPath = (contextURI = properties.getProperty("wink.context.uri")) != null && contextURI.length() > 0 ? contextURI : request.getContextPath();
        if (contextPath != null) {
            builder.append(contextPath);
            logger.debug("appendContextAndServletPath after contextPath called is: {} ", (Object)builder);
        }
        boolean isServlet = RuntimeContextTLS.getRuntimeContext().getAttribute(FilterConfig.class) == null;
        logger.debug("appendContextAndServletPath isServlet: {} ", (Object)isServlet);
        if (request.getServletPath() != null && isServlet) {
            builder.append(request.getServletPath());
            logger.debug("appendContextAndServletPath after getServletPath called is: {} ", (Object)builder);
        }
        if (builder.charAt(builder.length() - 1) != '/') {
            builder.append('/');
        }
        String builderStr = builder.toString();
        logger.debug("appendContextAndServletPath returning: {} ", (Object)builderStr);
        return builderStr;
    }

    private static String buildRequestPath(HttpServletRequest request) {
        int index;
        String requestPath = request.getRequestURI();
        logger.debug("buildRequestPath requestPath is: {}", (Object)requestPath);
        requestPath = UriHelper.normalize((String)requestPath);
        logger.debug("buildRequestPath requestPath normalized is: {}", (Object)requestPath);
        if (request.getContextPath() != null) {
            requestPath = requestPath.substring(request.getContextPath().length());
            logger.debug("buildRequestPath after context path removed: {}", (Object)requestPath);
        }
        boolean isServlet = RuntimeContextTLS.getRuntimeContext().getAttribute(FilterConfig.class) == null;
        logger.debug("buildRequestPath isServlet: {}", (Object)isServlet);
        if (request.getServletPath() != null && isServlet) {
            requestPath = requestPath.substring(request.getServletPath().length());
            logger.debug("buildRequestPath requestPath after servlet path removed: {}", (Object)requestPath);
        }
        for (index = 0; index < requestPath.length() && requestPath.charAt(index) == '/'; ++index) {
        }
        requestPath = requestPath.substring(index);
        logger.debug("buildRequestPath returning requestPath: {}", (Object)requestPath);
        return requestPath;
    }
}

