/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.server.internal.handlers;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.wink.server.handlers.AbstractHandler;
import org.apache.wink.server.handlers.MessageContext;
import org.apache.wink.server.internal.handlers.SearchResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvokeMethodHandler
extends AbstractHandler {
    private static final Logger logger = LoggerFactory.getLogger(InvokeMethodHandler.class);

    public void handleRequest(MessageContext context) throws Throwable {
        try {
            SearchResult searchResult = (SearchResult)context.getAttribute(SearchResult.class);
            Method javaMethod = searchResult.getMethod().getMetadata().getReflectionMethod();
            Object[] parameters = searchResult.getInvocationParameters();
            Object instance = searchResult.getResource().getInstance(context);
            if (logger.isDebugEnabled()) {
                logger.debug("Invoking method {} of declaring class {} on the instance of a class {}@{} with parameters {}", new Object[]{javaMethod.getName(), javaMethod.getDeclaringClass().getName(), instance.getClass().getName(), Integer.toHexString(System.identityHashCode(instance)), Arrays.toString(parameters)});
            }
            Object result = javaMethod.invoke(instance, parameters);
            context.setResponseEntity(result);
        }
        catch (InvocationTargetException ite) {
            logger.debug("Exception encountered during invocation:", ite.getTargetException());
            throw ite.getTargetException();
        }
    }
}

