/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.server.internal.handlers;

import java.util.Properties;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import org.apache.wink.common.http.HttpStatus;
import org.apache.wink.common.internal.utils.HeaderUtils;
import org.apache.wink.server.handlers.HandlersChain;
import org.apache.wink.server.handlers.MessageContext;
import org.apache.wink.server.handlers.RequestHandler;
import org.apache.wink.server.internal.handlers.SearchResult;
import org.apache.wink.server.internal.registry.ResourceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptionsMethodHandler
implements RequestHandler {
    private static final Logger logger = LoggerFactory.getLogger(OptionsMethodHandler.class);

    public void handleRequest(MessageContext context, HandlersChain chain) throws Throwable {
        chain.doChain(context);
        SearchResult searchResult = (SearchResult)context.getAttribute(SearchResult.class);
        if (searchResult.isError() && searchResult.getError().getResponse().getStatus() == HttpStatus.METHOD_NOT_ALLOWED.getCode() && context.getHttpMethod().equalsIgnoreCase("OPTIONS")) {
            ResourceRegistry resourceRegistry = (ResourceRegistry)context.getAttribute(ResourceRegistry.class);
            Set<String> httpMethods = resourceRegistry.getOptions(searchResult.getResource());
            logger.debug("Invoking OPTIONS request handled by runtime with {} resource and {} HTTP methods", (Object)searchResult.getResource(), httpMethods);
            if (httpMethods.size() > 0) {
                String allowHeader = HeaderUtils.buildOptionsHeader(httpMethods);
                ((HttpServletResponse)context.getAttribute(HttpServletResponse.class)).addHeader("Allow", allowHeader);
                ((SearchResult)context.getAttribute(SearchResult.class)).setError(null);
                context.setResponseStatusCode(Response.Status.NO_CONTENT.getStatusCode());
                context.setResponseEntity(null);
            }
        }
    }

    public void init(Properties props) {
    }
}

