/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.server.internal.handlers;

import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Response;
import org.apache.wink.server.handlers.AbstractHandler;
import org.apache.wink.server.handlers.MessageContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopulateResponseStatusHandler
extends AbstractHandler {
    private static final Logger logger = LoggerFactory.getLogger(PopulateResponseStatusHandler.class);

    public void handleResponse(MessageContext context) throws Throwable {
        Object entity = context.getResponseEntity();
        int status = -1;
        if (entity instanceof Response) {
            Response response = (Response)entity;
            status = response.getStatus();
            entity = response.getEntity();
        }
        if (entity instanceof GenericEntity) {
            GenericEntity genericEntity = (GenericEntity)entity;
            entity = genericEntity.getEntity();
        }
        if (status == -1) {
            if (entity == null) {
                logger.debug("No status set and no entity so setting response status to 204 No Content");
                status = 204;
            } else {
                logger.debug("No status set so setting response status to 200 OK");
                status = 200;
            }
        }
        context.setResponseStatusCode(status);
    }
}

