/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.server.internal.servlet;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Application;
import org.apache.wink.common.internal.i18n.Messages;
import org.apache.wink.common.internal.lifecycle.ObjectFactory;
import org.apache.wink.common.internal.properties.WinkSystemProperties;
import org.apache.wink.common.internal.utils.ClassUtils;
import org.apache.wink.server.internal.DeploymentConfiguration;
import org.apache.wink.server.internal.RequestProcessor;
import org.apache.wink.server.internal.application.ServletWinkApplication;
import org.apache.wink.server.internal.servlet.AbstractRestServlet;
import org.apache.wink.server.internal.utils.ServletFileLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestServlet
extends AbstractRestServlet {
    private static final long serialVersionUID = 8797036173835816706L;
    private static final Logger logger = LoggerFactory.getLogger(RestServlet.class);
    public static final String APPLICATION_INIT_PARAM = "javax.ws.rs.Application";
    public static final String PROPERTIES_DEFAULT_FILE = "META-INF/wink-default.properties";
    public static final String PROPERTIES_INIT_PARAM = "propertiesLocation";
    public static final String APP_LOCATION_PARAM = "applicationConfigLocation";
    public static final String DEPLOYMENT_CONF_PARAM = "deploymentConfiguration";

    public void init() throws ServletException {
        logger.debug("Initializing {} servlet", (Object)this);
        try {
            super.init();
            RequestProcessor requestProcessor = this.getRequestProcessor();
            if (requestProcessor == null) {
                requestProcessor = this.createRequestProcessor();
                if (requestProcessor == null) {
                    throw new IllegalStateException(Messages.getMessage((String)"restServletRequestProcessorCouldNotBeCreated"));
                }
                this.storeRequestProcessorOnServletContext(requestProcessor);
            }
            if (requestProcessor.getConfiguration().getServletConfig() == null) {
                requestProcessor.getConfiguration().setServletConfig(this.getServletConfig());
            }
            if (requestProcessor.getConfiguration().getServletContext() == null) {
                requestProcessor.getConfiguration().setServletContext(this.getServletContext());
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new UnavailableException(e.getMessage());
        }
    }

    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.getRequestProcessor().handleRequest(httpServletRequest, httpServletResponse);
    }

    protected RequestProcessor createRequestProcessor() throws ClassNotFoundException, InstantiationException, IllegalAccessException, IOException {
        DeploymentConfiguration deploymentConfiguration = this.getDeploymentConfiguration();
        Application app = this.getApplication();
        if (app == null) {
            app = this.getApplication(deploymentConfiguration);
        }
        deploymentConfiguration.addApplication(app, false);
        RequestProcessor requestProcessor = new RequestProcessor(deploymentConfiguration);
        logger.debug("Creating request processor {} for servlet {}", (Object)requestProcessor, (Object)this);
        return requestProcessor;
    }

    protected DeploymentConfiguration getDeploymentConfiguration() throws ClassNotFoundException, InstantiationException, IllegalAccessException, IOException {
        DeploymentConfiguration deploymentConfiguration = this.createDeploymentConfiguration();
        deploymentConfiguration.setServletConfig(this.getServletConfig());
        deploymentConfiguration.setServletContext(this.getServletContext());
        deploymentConfiguration.setProperties(this.getProperties());
        deploymentConfiguration.init();
        return deploymentConfiguration;
    }

    protected Properties getProperties() throws IOException {
        Properties defaultProperties = this.loadProperties(PROPERTIES_DEFAULT_FILE, null);
        logger.debug("Default properties {} used in RestServlet {}", (Object)defaultProperties, (Object)this);
        String propertiesLocation = this.getInitParameter(PROPERTIES_INIT_PARAM);
        if (propertiesLocation != null) {
            if (logger.isInfoEnabled()) {
                logger.info(Messages.getMessage((String)"restServletUsePropertiesFileAtLocation", (Object[])new Object[]{propertiesLocation, PROPERTIES_INIT_PARAM}));
            }
            Properties properties = this.loadProperties(propertiesLocation, defaultProperties);
            properties.putAll((Map<?, ?>)WinkSystemProperties.loadSystemProperties((Properties)properties));
            return properties;
        }
        logger.debug("Final properties {} used in RestServlet {}", (Object)defaultProperties, (Object)this);
        defaultProperties.putAll((Map<?, ?>)WinkSystemProperties.loadSystemProperties((Properties)defaultProperties));
        return defaultProperties;
    }

    protected DeploymentConfiguration createDeploymentConfiguration() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        String initParameter = this.getInitParameter(DEPLOYMENT_CONF_PARAM);
        if (initParameter != null) {
            if (logger.isInfoEnabled()) {
                logger.info(Messages.getMessage((String)"restServletUseDeploymentConfigurationParam", (Object[])new Object[]{initParameter, DEPLOYMENT_CONF_PARAM}));
            }
            Class confClass = ClassUtils.loadClass((String)initParameter);
            return (DeploymentConfiguration)confClass.newInstance();
        }
        return new DeploymentConfiguration();
    }

    protected Application getApplication(DeploymentConfiguration configuration) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class appClass = null;
        String initParameter = this.getInitParameter(APPLICATION_INIT_PARAM);
        if (initParameter != null) {
            if (logger.isInfoEnabled()) {
                logger.info(Messages.getMessage((String)"restServletJAXRSApplicationInitParam", (Object[])new Object[]{initParameter, APPLICATION_INIT_PARAM}));
            }
            appClass = ClassUtils.loadClass((String)initParameter);
            ObjectFactory of = configuration.getOfFactoryRegistry().getObjectFactory(appClass);
            configuration.addApplicationObjectFactory(of);
            return (Application)of.getInstance(null);
        }
        String appLocationParameter = this.getInitParameter(APP_LOCATION_PARAM);
        if (appLocationParameter == null && logger.isWarnEnabled()) {
            logger.warn(Messages.getMessage((String)"propertyNotDefined", (Object[])new Object[]{APP_LOCATION_PARAM}));
        }
        if (logger.isInfoEnabled()) {
            logger.info(Messages.getMessage((String)"restServletWinkApplicationInitParam", (Object[])new Object[]{appLocationParameter, APP_LOCATION_PARAM}));
        }
        return new ServletWinkApplication(this.getServletContext(), appLocationParameter);
    }

    protected Application getApplication() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadProperties(String resourceName, Properties defaultProperties) throws IOException {
        Properties properties = defaultProperties == null ? new Properties() : new Properties(defaultProperties);
        InputStream is = null;
        try {
            is = ServletFileLoader.loadFileAsStream(this.getServletContext(), resourceName);
            properties.load(is);
        }
        catch (FileNotFoundException e) {
            logger.debug("FileNotFoundException for {}", (Object)resourceName);
        }
        finally {
            block13: {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e) {
                    if (!logger.isWarnEnabled()) break block13;
                    logger.warn(Messages.getMessage((String)"exceptionClosingFile") + ": " + resourceName, (Throwable)e);
                }
            }
        }
        return properties;
    }

    public void destroy() {
        this.getRequestProcessor().getConfiguration().getProvidersRegistry().removeAllProviders();
        this.getRequestProcessor().getConfiguration().getResourceRegistry().removeAllResources();
        for (ObjectFactory<?> of : this.getRequestProcessor().getConfiguration().getApplicationObjectFactories()) {
            of.releaseAll(null);
        }
        super.destroy();
    }
}

