/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.server.internal.registry;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Providers;
import org.apache.wink.common.RuntimeContext;
import org.apache.wink.common.internal.PathSegmentImpl;
import org.apache.wink.common.internal.registry.BoundInjectable;
import org.apache.wink.common.internal.registry.ContextAccessor;
import org.apache.wink.common.internal.registry.Injectable;
import org.apache.wink.common.internal.registry.InjectableFactory;
import org.apache.wink.common.internal.registry.ValueConvertor;
import org.apache.wink.common.internal.runtime.RuntimeContextTLS;
import org.apache.wink.common.internal.uri.UriEncoder;
import org.apache.wink.common.internal.utils.MediaTypeUtils;
import org.apache.wink.common.internal.utils.StringUtils;
import org.apache.wink.common.utils.ProviderUtils;
import org.apache.wink.server.internal.handlers.SearchResult;
import org.apache.wink.server.internal.registry.ServletContextAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerInjectableFactory
extends InjectableFactory {
    public Injectable createContextParam(Class<?> classType, Annotation[] annotations, Member member) {
        return new ServerContextParam(classType, annotations, member);
    }

    public Injectable createCookieParam(String value, Class<?> classType, Type genericType, Annotation[] annotations, Member member) {
        return new CookieParamBinding(value, classType, genericType, annotations, member);
    }

    public Injectable createEntityParam(Class<?> classType, Type genericType, Annotation[] annotations, Member member) {
        return new EntityParam(classType, genericType, annotations, member);
    }

    public Injectable createFormParam(String value, Class<?> classType, Type genericType, Annotation[] annotations, Member member) {
        return new FormParamBinding(value, classType, genericType, annotations, member);
    }

    public Injectable createHeaderParam(String value, Class<?> classType, Type genericType, Annotation[] annotations, Member member) {
        return new HeaderParamBinding(value, classType, genericType, annotations, member);
    }

    public Injectable createMatrixParam(String value, Class<?> classType, Type genericType, Annotation[] annotations, Member member) {
        return new MatrixParamBinding(value, classType, genericType, annotations, member);
    }

    public Injectable createPathParam(String value, Class<?> classType, Type genericType, Annotation[] annotations, Member member) {
        return new PathParamBinding(value, classType, genericType, annotations, member);
    }

    public Injectable createQueryParam(String value, Class<?> classType, Type genericType, Annotation[] annotations, Member member) {
        return new QueryParamBinding(value, classType, genericType, annotations, member);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CookieParamBinding
    extends BoundInjectable {
        public CookieParamBinding(String variableName, Class<?> type, Type genericType, Annotation[] annotations, Member member) {
            super(Injectable.ParamType.COOKIE, variableName, type, genericType, annotations, member);
        }

        public Object getValue(RuntimeContext runtimeContext) throws IOException {
            if (runtimeContext == null) {
                return null;
            }
            String value = null;
            HttpHeaders httpHeaders = runtimeContext.getHttpHeaders();
            Map values = httpHeaders.getCookies();
            Cookie cookie = null;
            if (values.size() > 0) {
                cookie = (Cookie)values.get(this.getName());
            }
            if (cookie == null && this.hasDefaultValue()) {
                cookie = new Cookie(this.getName(), this.getDefaultValue());
            }
            if (cookie != null) {
                if (this.isTypeCollectionOf(Cookie.class)) {
                    return this.elementAsTypeCollection(cookie, new CookieComparator());
                }
                if (this.isTypeOf(Cookie.class)) {
                    return cookie;
                }
                value = cookie.getValue();
            }
            try {
                return this.getConvertor().convert(value);
            }
            catch (ValueConvertor.ConversionException e) {
                throw new WebApplicationException(e.getCause(), Response.Status.BAD_REQUEST);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class CookieComparator
        implements Comparator<Cookie> {
            @Override
            public int compare(Cookie o1, Cookie o2) {
                int val = 0;
                if (o1.getName() != null && (val = o1.getName().compareTo(o2.getName())) != 0) {
                    return val;
                }
                if (o1.getValue() != null && (val = o1.getValue().compareTo(o2.getValue())) != 0) {
                    return val;
                }
                if (o1.getPath() != null && (val = o1.getPath().compareTo(o2.getPath())) != 0) {
                    return val;
                }
                if (o1.getDomain() != null && (val = o1.getDomain().compareTo(o2.getDomain())) != 0) {
                    return val;
                }
                return o1.getVersion() - o2.getVersion();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HeaderParamBinding
    extends BoundInjectable {
        public HeaderParamBinding(String variableName, Class<?> type, Type genericType, Annotation[] annotations, Member member) {
            super(Injectable.ParamType.HEADER, variableName, type, genericType, annotations, member);
        }

        public Object getValue(RuntimeContext runtimeContext) throws IOException {
            if (runtimeContext == null) {
                return null;
            }
            HttpHeaders httpHeaders = runtimeContext.getHttpHeaders();
            LinkedList<String> values = httpHeaders.getRequestHeader(this.getName());
            if (values == null) {
                values = new LinkedList<String>();
            }
            if (values.size() == 0 && this.hasDefaultValue()) {
                values.add(this.getDefaultValue());
            }
            try {
                return this.getConvertor().convert(values);
            }
            catch (ValueConvertor.ConversionException e) {
                throw new WebApplicationException(e.getCause(), Response.Status.BAD_REQUEST);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PathParamBinding
    extends BoundInjectable {
        public PathParamBinding(String variableName, Class<?> type, Type genericType, Annotation[] annotations, Member member) {
            super(Injectable.ParamType.PATH, variableName, type, genericType, annotations, member);
        }

        /*
         * WARNING - void declaration
         */
        public Object getValue(RuntimeContext runtimeContext) throws IOException {
            void var7_13;
            UriInfo uriInfo;
            MultivaluedMap variables;
            List list;
            if (runtimeContext == null) {
                return null;
            }
            MultivaluedMap<String, List<PathSegment>> pathSegmentsMap = ((SearchResult)runtimeContext.getAttribute(SearchResult.class)).getData().getMatchedVariablesPathSegments();
            ArrayList<PathSegmentImpl> segments = null;
            List listOfListPathSegments = (List)pathSegmentsMap.get((Object)this.getName());
            if (listOfListPathSegments != null && listOfListPathSegments.size() > 0) {
                segments = (List)listOfListPathSegments.get(listOfListPathSegments.size() - 1);
            }
            if (segments != null && segments.size() > 0) {
                if (this.isTypeOf(PathSegment.class)) {
                    PathSegment segment = (PathSegment)segments.get(segments.size() - 1);
                    if (!this.isEncoded()) {
                        segment = PathSegmentImpl.decode((PathSegment)segment);
                    }
                    return segment;
                }
                if (this.isTypeCollectionOf(PathSegment.class)) {
                    ArrayList<PathSegmentImpl> list2 = segments;
                    if (!this.isEncoded()) {
                        list2 = new ArrayList<PathSegmentImpl>(segments.size());
                        for (PathSegment pathSegment : segments) {
                            list2.add(PathSegmentImpl.decode((PathSegment)pathSegment));
                        }
                    }
                    return this.asTypeCollection(list2, null);
                }
            }
            if ((list = (List)(variables = (uriInfo = runtimeContext.getUriInfo()).getPathParameters(false)).get((Object)this.getName())) == null) {
                LinkedList linkedList = new LinkedList();
            }
            if (var7_13.size() == 0 && this.hasDefaultValue()) {
                String defaultValue = this.getDefaultValue();
                if (this.isTypeOf(PathSegment.class) || this.isTypeCollectionOf(PathSegment.class)) {
                    String[] segmentsArray = StringUtils.fastSplit((String)defaultValue, (String)"/", (boolean)true);
                    var7_13.addAll(Arrays.asList(segmentsArray));
                } else {
                    var7_13.add(defaultValue);
                }
                this.decodeValues((List)var7_13);
                try {
                    return this.getConvertor().convert((List)var7_13);
                }
                catch (ValueConvertor.ConversionException e) {
                    throw new WebApplicationException(e.getCause(), Response.Status.NOT_FOUND);
                }
            }
            this.decodeValues((List)var7_13);
            try {
                Collections.reverse(var7_13);
                return this.getConvertor().convert((List)var7_13);
            }
            catch (ValueConvertor.ConversionException e) {
                throw new WebApplicationException(e.getCause(), Response.Status.NOT_FOUND);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FormParamBinding
    extends BoundInjectable {
        static final String FORM_PARAMATERS = "wink.formParameters";
        public static final MultivaluedMap<String, String> dummyMultivaluedMap = null;
        private static Type MULTIVALUED_MAP_STRING_TYPE = null;

        public FormParamBinding(String variableName, Class<?> type, Type genericType, Annotation[] annotations, Member member) {
            super(Injectable.ParamType.FORM, variableName, type, genericType, annotations, member);
        }

        public Object getValue(RuntimeContext runtimeContext) throws IOException {
            LinkedList<String> values;
            if (runtimeContext == null) {
                return null;
            }
            MediaType mediaType = runtimeContext.getHttpHeaders().getMediaType();
            if (!MediaTypeUtils.equalsIgnoreParameters((MediaType)mediaType, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE)) {
                return null;
            }
            MultivaluedMap formParameters = (MultivaluedMap)runtimeContext.getAttributes().get(FORM_PARAMATERS);
            if (formParameters == null) {
                EntityParam entityParam = new EntityParam(MultivaluedMap.class, MULTIVALUED_MAP_STRING_TYPE, this.getAnnotations(), null);
                formParameters = (MultivaluedMap)entityParam.getValue(runtimeContext);
                if (formParameters.isEmpty()) {
                    Map map = ((HttpServletRequest)RuntimeContextTLS.getRuntimeContext().getAttribute(HttpServletRequest.class)).getParameterMap();
                    for (String key : map.keySet()) {
                        String[] value = (String[])map.get(key);
                        formParameters.put((Object)key, Arrays.asList(value));
                    }
                }
                runtimeContext.getAttributes().put(FORM_PARAMATERS, formParameters);
            }
            if ((values = (LinkedList<String>)formParameters.get((Object)this.getName())) == null) {
                values = new LinkedList<String>();
            }
            if (values.size() == 0 && this.hasDefaultValue()) {
                values.add(this.getDefaultValue());
            }
            this.decodeValues(values);
            try {
                return this.getConvertor().convert(values);
            }
            catch (ValueConvertor.ConversionException e) {
                throw new WebApplicationException(e.getCause(), Response.Status.BAD_REQUEST);
            }
        }

        protected String decodeValue(String value) {
            return UriEncoder.decodeQuery((String)value);
        }

        static {
            try {
                MULTIVALUED_MAP_STRING_TYPE = FormParamBinding.class.getField("dummyMultivaluedMap").getGenericType();
            }
            catch (SecurityException e) {
                throw new WebApplicationException((Throwable)e);
            }
            catch (NoSuchFieldException e) {
                throw new WebApplicationException((Throwable)e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class QueryParamBinding
    extends BoundInjectable {
        public QueryParamBinding(String variableName, Class<?> type, Type genericType, Annotation[] annotations, Member member) {
            super(Injectable.ParamType.QUERY, variableName, type, genericType, annotations, member);
        }

        public Object getValue(RuntimeContext runtimeContext) throws IOException {
            if (runtimeContext == null) {
                return null;
            }
            UriInfo uriInfo = runtimeContext.getUriInfo();
            MultivaluedMap queryParameters = uriInfo.getQueryParameters(false);
            LinkedList<String> values = (LinkedList<String>)queryParameters.get((Object)this.getName());
            if (values == null) {
                values = new LinkedList<String>();
            }
            if (values.size() == 0 && this.hasDefaultValue()) {
                values.add(this.getDefaultValue());
            }
            this.decodeValues(values);
            try {
                return this.getConvertor().convert(values);
            }
            catch (ValueConvertor.ConversionException e) {
                throw new WebApplicationException(e.getCause(), Response.Status.NOT_FOUND);
            }
        }

        protected String decodeValue(String value) {
            return UriEncoder.decodeQuery((String)value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MatrixParamBinding
    extends BoundInjectable {
        public MatrixParamBinding(String variableName, Class<?> type, Type genericType, Annotation[] annotations, Member member) {
            super(Injectable.ParamType.MATRIX, variableName, type, genericType, annotations, member);
        }

        public Object getValue(RuntimeContext runtimeContext) throws IOException {
            if (runtimeContext == null) {
                return null;
            }
            ArrayList<String> allValues = new ArrayList<String>();
            List<PathSegment> segments = ((SearchResult)runtimeContext.getAttribute(SearchResult.class)).getData().getMatchedURIs().get(0);
            PathSegment segment = segments.get(segments.size() - 1);
            MultivaluedMap matrixParameters = segment.getMatrixParameters();
            List values = (List)matrixParameters.get((Object)this.getName());
            if (values != null) {
                allValues.addAll(values);
            }
            if (allValues.size() == 0 && this.hasDefaultValue()) {
                allValues.add(this.getDefaultValue());
            }
            this.decodeValues(allValues);
            try {
                return this.getConvertor().convert(allValues);
            }
            catch (ValueConvertor.ConversionException e) {
                throw new WebApplicationException(e.getCause(), Response.Status.NOT_FOUND);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EntityParam
    extends Injectable {
        public EntityParam(Class<?> type, Type genericType, Annotation[] annotations, Member member) {
            super(Injectable.ParamType.ENTITY, type, genericType, annotations, member);
        }

        public Object getValue(RuntimeContext runtimeContext) throws IOException {
            if (runtimeContext == null) {
                return null;
            }
            Class paramType = this.getType();
            Providers providers = runtimeContext.getProviders();
            if (providers != null) {
                MessageBodyReader mbr;
                MediaType mediaType = runtimeContext.getHttpHeaders().getMediaType();
                if (mediaType == null) {
                    mediaType = MediaType.APPLICATION_OCTET_STREAM_TYPE;
                }
                if ((mbr = providers.getMessageBodyReader(paramType, this.getGenericType(), this.getAnnotations(), mediaType)) != null) {
                    Object read;
                    try {
                        read = mbr.readFrom(paramType, this.getGenericType(), this.getAnnotations(), mediaType, runtimeContext.getHttpHeaders().getRequestHeaders(), runtimeContext.getInputStream());
                    }
                    catch (RuntimeException e) {
                        ProviderUtils.logUserProviderException((RuntimeException)e, (Object)mbr, (ProviderUtils.PROVIDER_EXCEPTION_ORIGINATOR)ProviderUtils.PROVIDER_EXCEPTION_ORIGINATOR.readFrom, (Object[])new Object[]{paramType, this.getGenericType(), this.getAnnotations(), mediaType, runtimeContext.getHttpHeaders().getRequestHeaders(), runtimeContext.getInputStream()}, (RuntimeContext)runtimeContext);
                        throw e;
                    }
                    return read;
                }
            }
            throw new WebApplicationException(Response.Status.UNSUPPORTED_MEDIA_TYPE);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ServerContextParam
    extends Injectable {
        private ContextAccessor contextAccessor;

        public ServerContextParam(Class<?> type, Annotation[] annotations, Member member) {
            super(Injectable.ParamType.CONTEXT, type, type, annotations, member);
            this.contextAccessor = type != HttpServletRequest.class && type != HttpServletResponse.class ? new ContextAccessor() : new ServletContextAccessor();
        }

        public Object getValue(RuntimeContext runtimeContext) {
            return this.contextAccessor.getContext(this.getType(), runtimeContext);
        }
    }
}

