/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.soap.impl.llom;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axiom.soap.SOAPProcessingException;
import org.apache.axiom.soap.impl.llom.SOAPElement;
import org.apache.axiom.soap.impl.llom.SOAPEnvelopeImpl;

public abstract class SOAPHeaderImpl
extends SOAPElement
implements SOAPHeader {
    protected SOAPHeaderImpl(OMNamespace ns, SOAPFactory factory) {
        super("Header", ns, factory);
    }

    public SOAPHeaderImpl(SOAPEnvelope envelope, SOAPFactory factory) throws SOAPProcessingException {
        super((OMElement)envelope, "Header", true, factory);
    }

    public SOAPHeaderImpl(SOAPEnvelope envelope, OMXMLParserWrapper builder, SOAPFactory factory) {
        super((OMElement)envelope, "Header", builder, factory);
    }

    public abstract SOAPHeaderBlock addHeaderBlock(String var1, OMNamespace var2) throws OMException;

    public Iterator examineHeaderBlocks(String paramRole) {
        Iterator headerBlocksIter = this.getChildren();
        ArrayList<SOAPHeaderBlock> headersWithGivenActor = new ArrayList<SOAPHeaderBlock>();
        if (paramRole == null || "".equals(paramRole)) {
            return this.returnAllSOAPHeaders(this.getChildren());
        }
        while (headerBlocksIter.hasNext()) {
            SOAPHeaderBlock soapHeaderBlock;
            String role;
            Object o = headerBlocksIter.next();
            if (!(o instanceof SOAPHeaderBlock) || (role = (soapHeaderBlock = (SOAPHeaderBlock)o).getRole()) == null || !role.equalsIgnoreCase(paramRole)) continue;
            headersWithGivenActor.add(soapHeaderBlock);
        }
        return headersWithGivenActor.iterator();
    }

    private Iterator returnAllSOAPHeaders(Iterator children) {
        ArrayList headers = new ArrayList();
        while (children.hasNext()) {
            Object o = children.next();
            if (!(o instanceof SOAPHeaderBlock)) continue;
            headers.add(o);
        }
        return headers.iterator();
    }

    public abstract Iterator extractHeaderBlocks(String var1);

    public Iterator examineMustUnderstandHeaderBlocks(String actor) {
        Iterator headerBlocksIter = this.getChildren();
        ArrayList<SOAPHeaderBlock> mustUnderstandHeadersWithGivenActor = new ArrayList<SOAPHeaderBlock>();
        while (headerBlocksIter.hasNext()) {
            Object o = headerBlocksIter.next();
            if (!(o instanceof SOAPHeaderBlock)) continue;
            SOAPHeaderBlock soapHeaderBlock = (SOAPHeaderBlock)o;
            String role = soapHeaderBlock.getRole();
            boolean mustUnderstand = soapHeaderBlock.getMustUnderstand();
            if (role == null || !role.equalsIgnoreCase(actor) || !mustUnderstand) continue;
            mustUnderstandHeadersWithGivenActor.add(soapHeaderBlock);
        }
        return mustUnderstandHeadersWithGivenActor.iterator();
    }

    public Iterator examineAllHeaderBlocks() {
        return this.getChildrenWithName(null);
    }

    public Iterator extractAllHeaderBlocks() {
        throw new UnsupportedOperationException();
    }

    public ArrayList getHeaderBlocksWithNSURI(String nsURI) {
        ArrayList<OMElement> headers = null;
        OMNode node = null;
        OMElement header = this.getFirstElement();
        if (header != null) {
            headers = new ArrayList<OMElement>();
        }
        for (node = header; node != null; node = node.getNextOMSibling()) {
            if (node.getType() != 1) continue;
            header = node;
            OMNamespace namespace = header.getNamespace();
            if (nsURI == null) {
                if (namespace != null) continue;
                headers.add(header);
                continue;
            }
            if (namespace == null || !nsURI.equals(namespace.getNamespaceURI())) continue;
            headers.add(header);
        }
        return headers;
    }

    protected void checkParent(OMElement parent) throws SOAPProcessingException {
        if (!(parent instanceof SOAPEnvelopeImpl)) {
            throw new SOAPProcessingException("Expecting an implementation of SOAP Envelope as the parent. But received some other implementation");
        }
    }
}

