/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.llom;

import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMConstants;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.impl.OMContainerEx;
import org.apache.axiom.om.impl.OMNamespaceImpl;
import org.apache.axiom.om.impl.OMNodeEx;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.llom.OMAttributeImpl;
import org.apache.axiom.om.impl.llom.OMNodeImpl;
import org.apache.axiom.om.impl.llom.OMStAXWrapper;
import org.apache.axiom.om.impl.llom.factory.OMLinkedListImplFactory;
import org.apache.axiom.om.impl.traverse.OMChildElementIterator;
import org.apache.axiom.om.impl.traverse.OMChildrenIterator;
import org.apache.axiom.om.impl.traverse.OMChildrenQNameIterator;
import org.apache.axiom.om.impl.util.EmptyIterator;
import org.apache.axiom.om.impl.util.OMSerializerUtil;
import org.apache.axiom.om.util.ElementHelper;
import org.apache.axiom.om.util.StAXUtils;

public class OMElementImpl
extends OMNodeImpl
implements OMElement,
OMConstants,
OMContainerEx {
    public static final OMNamespace DEFAULT_DEFAULT_NS_OBJECT = new OMNamespaceImpl("", "");
    protected OMNamespace ns;
    protected String localName;
    protected OMNode firstChild;
    protected HashMap namespaces = null;
    protected HashMap attributes = null;
    protected int noPrefixNamespaceCounter = 0;
    protected OMNode lastChild;
    private int lineNumber;
    private static final EmptyIterator EMPTY_ITERATOR = new EmptyIterator();
    static final OMNamespaceImpl xmlns = new OMNamespaceImpl("http://www.w3.org/XML/1998/namespace", "xml");

    public OMElementImpl(String localName, OMNamespace ns, OMContainer parent, OMXMLParserWrapper builder, OMFactory factory) {
        super(parent, factory, false);
        this.localName = localName;
        if (ns != null) {
            this.setNamespace(ns);
        }
        this.builder = builder;
        this.firstChild = null;
    }

    public OMElementImpl(String localName, OMNamespace ns, OMFactory factory) {
        this(localName, ns, null, factory);
    }

    public OMElementImpl(String localName, OMNamespace ns, OMContainer parent, OMFactory factory) {
        super(parent, factory, true);
        if (localName == null || localName.trim().length() == 0) {
            throw new OMException("localname can not be null or empty");
        }
        this.localName = localName;
        if (ns != null) {
            this.setNamespace(ns);
        }
    }

    public OMElementImpl(QName qname, OMContainer parent, OMFactory factory) throws OMException {
        this(qname.getLocalPart(), null, parent, factory);
        this.ns = this.handleNamespace(qname);
    }

    OMNamespace handleNamespace(QName qname) {
        OMNamespace ns = null;
        String namespaceURI = qname.getNamespaceURI();
        if (namespaceURI != null && namespaceURI.length() > 0) {
            String prefix = qname.getPrefix();
            ns = this.findNamespace(qname.getNamespaceURI(), prefix);
            if (ns == null) {
                if ("".equals(prefix)) {
                    prefix = OMSerializerUtil.getNextNSPrefix();
                }
                ns = this.declareNamespace(namespaceURI, prefix);
            }
            if (ns != null) {
                this.ns = ns;
            }
        }
        return ns;
    }

    private OMNamespace handleNamespace(OMNamespace ns) {
        OMNamespace namespace = this.findNamespace(ns.getNamespaceURI(), ns.getPrefix());
        if (namespace == null) {
            namespace = this.declareNamespace(ns);
        }
        return namespace;
    }

    OMNamespace handleNamespace(String namespaceURI, String prefix) {
        OMNamespace namespace = this.findNamespace(namespaceURI, prefix);
        if (namespace == null) {
            namespace = this.declareNamespace(namespaceURI, prefix);
        }
        return namespace;
    }

    public void addChild(OMNode child) {
        if (child.getOMFactory() instanceof OMLinkedListImplFactory) {
            this.addChild((OMNodeImpl)child);
        } else {
            this.addChild(this.importNode(child));
        }
    }

    public Iterator getChildrenWithName(QName elementQName) {
        return new OMChildrenQNameIterator(this.getFirstOMChild(), elementQName);
    }

    public OMElement getFirstChildWithName(QName elementQName) throws OMException {
        OMChildrenQNameIterator omChildrenQNameIterator = new OMChildrenQNameIterator(this.getFirstOMChild(), elementQName);
        OMNode omNode = null;
        if (omChildrenQNameIterator.hasNext()) {
            omNode = (OMNode)omChildrenQNameIterator.next();
        }
        return omNode != null && 1 == omNode.getType() ? (OMElement)omNode : null;
    }

    private void addChild(OMNodeImpl child) {
        child.setParent(this);
        if (this.firstChild == null) {
            this.firstChild = child;
            child.previousSibling = null;
        } else {
            child.previousSibling = (OMNodeImpl)this.lastChild;
            ((OMNodeImpl)this.lastChild).nextSibling = child;
        }
        child.nextSibling = null;
        this.lastChild = child;
        if (!child.isComplete()) {
            this.setComplete(false);
        }
    }

    public OMNode getNextOMSibling() throws OMException {
        while (!this.done && this.builder != null) {
            int token = this.builder.next();
            if (token != 8) continue;
            throw new OMException("Parser has already reached end of the document. No siblings found");
        }
        return super.getNextOMSibling();
    }

    public Iterator getChildren() {
        return new OMChildrenIterator(this.getFirstOMChild());
    }

    public Iterator getChildElements() {
        return new OMChildElementIterator(this.getFirstElement());
    }

    public OMNamespace declareNamespace(String uri, String prefix) {
        if ("".equals(prefix)) {
            prefix = OMSerializerUtil.getNextNSPrefix();
        }
        OMNamespaceImpl ns = new OMNamespaceImpl(uri, prefix);
        return this.declareNamespace(ns);
    }

    public OMNamespace declareDefaultNamespace(String uri) {
        OMNamespaceImpl namespace = new OMNamespaceImpl(uri == null ? "" : uri, "");
        if (this.namespaces == null) {
            this.namespaces = new HashMap(5);
        }
        this.namespaces.put("", namespace);
        return namespace;
    }

    public OMNamespace getDefaultNamespace() {
        OMNamespace defaultNS;
        if (this.namespaces != null && (defaultNS = (OMNamespace)this.namespaces.get("")) != null) {
            return defaultNS;
        }
        if (this.parent instanceof OMElementImpl) {
            return ((OMElementImpl)this.parent).getDefaultNamespace();
        }
        return null;
    }

    public OMNamespace declareNamespace(OMNamespace namespace) {
        String prefix;
        if (this.namespaces == null) {
            this.namespaces = new HashMap(5);
        }
        if ((prefix = namespace.getPrefix()) == null) {
            prefix = OMSerializerUtil.getNextNSPrefix();
            namespace = new OMNamespaceImpl(namespace.getNamespaceURI(), prefix);
        }
        this.namespaces.put(prefix, namespace);
        return namespace;
    }

    public OMNamespace findNamespace(String uri, String prefix) {
        OMNamespace namespace = this.findDeclaredNamespace(uri, prefix);
        if (namespace != null) {
            return namespace;
        }
        if (this.parent != null && this.parent instanceof OMElement) {
            namespace = ((OMElementImpl)this.parent).findNamespace(uri, prefix);
        }
        return namespace;
    }

    public OMNamespace findNamespaceURI(String prefix) {
        OMNamespace ns;
        OMNamespace oMNamespace = ns = this.namespaces == null ? null : (OMNamespace)this.namespaces.get(prefix);
        if (ns == null && this.parent instanceof OMElement) {
            ns = ((OMElement)((Object)this.parent)).findNamespaceURI(prefix);
        }
        return ns;
    }

    private OMNamespace findDeclaredNamespace(String uri, String prefix) {
        if (uri == null) {
            return null;
        }
        if (prefix != null && prefix.equals("xml") && uri.equals("http://www.w3.org/XML/1998/namespace")) {
            return xmlns;
        }
        if (this.namespaces == null) {
            return null;
        }
        if (prefix == null || "".equals(prefix)) {
            OMNamespace defaultNamespace = this.getDefaultNamespace();
            if (defaultNamespace != null && uri.equals(defaultNamespace.getNamespaceURI())) {
                return defaultNamespace;
            }
            Iterator namespaceListIterator = this.namespaces.values().iterator();
            while (namespaceListIterator.hasNext()) {
                OMNamespace omNamespace = (OMNamespace)namespaceListIterator.next();
                String nsUri = omNamespace.getNamespaceURI();
                if (nsUri == null || !nsUri.equals(uri)) continue;
                return omNamespace;
            }
        } else {
            OMNamespace namespace = (OMNamespace)this.namespaces.get(prefix);
            if (namespace != null && uri.equalsIgnoreCase(namespace.getNamespaceURI())) {
                return namespace;
            }
        }
        return null;
    }

    public Iterator getAllDeclaredNamespaces() {
        if (this.namespaces == null) {
            return EMPTY_ITERATOR;
        }
        return this.namespaces.values().iterator();
    }

    public Iterator getAllAttributes() {
        if (this.attributes == null) {
            return EMPTY_ITERATOR;
        }
        return this.attributes.values().iterator();
    }

    public OMAttribute getAttribute(QName qname) {
        return this.attributes == null ? null : (OMAttribute)this.attributes.get(qname);
    }

    public String getAttributeValue(QName qname) {
        OMAttribute attr = this.getAttribute(qname);
        return attr == null ? null : attr.getAttributeValue();
    }

    public OMAttribute addAttribute(OMAttribute attr) {
        String nsPrefix;
        String nsURI;
        OMNamespace namespace;
        if (this.attributes == null) {
            this.attributes = new LinkedHashMap(5);
        }
        if ((namespace = attr.getNamespace()) != null && (nsURI = namespace.getNamespaceURI()) != null && !"".equals(nsURI) && this.findNamespace(nsURI, nsPrefix = namespace.getPrefix()) == null) {
            this.declareNamespace(nsURI, nsPrefix);
        }
        this.attributes.put(attr.getQName(), attr);
        return attr;
    }

    public void removeAttribute(OMAttribute attr) {
        if (this.attributes != null) {
            this.attributes.remove(attr.getQName());
        }
    }

    public OMAttribute addAttribute(String attributeName, String value, OMNamespace ns) {
        String prefix;
        String namespaceURI;
        OMNamespace namespace = null;
        if (ns != null && (namespace = this.findNamespace(namespaceURI = ns.getNamespaceURI(), prefix = ns.getPrefix())) == null) {
            namespace = new OMNamespaceImpl(namespaceURI, prefix);
        }
        return this.addAttribute(new OMAttributeImpl(attributeName, namespace, value, this.factory));
    }

    public void setBuilder(OMXMLParserWrapper wrapper) {
        this.builder = wrapper;
    }

    public OMXMLParserWrapper getBuilder() {
        return this.builder;
    }

    public void buildNext() {
        if (this.builder != null) {
            this.builder.next();
        }
    }

    public OMNode getFirstOMChild() {
        while (this.firstChild == null && !this.done) {
            this.buildNext();
        }
        return this.firstChild;
    }

    public void setFirstChild(OMNode firstChild) {
        if (firstChild != null) {
            ((OMNodeEx)firstChild).setParent(this);
        }
        this.firstChild = firstChild;
    }

    public OMNode detach() throws OMException {
        if (!this.done) {
            this.build();
        }
        super.detach();
        return this;
    }

    public boolean isComplete() {
        return this.done;
    }

    public int getType() {
        return 1;
    }

    public void build() throws OMException {
        if (this.builder == null && !this.done) {
            Iterator childrenIterator = this.getChildren();
            while (childrenIterator.hasNext()) {
                OMNode omNode = (OMNode)childrenIterator.next();
                omNode.build();
            }
        } else {
            super.build();
        }
    }

    public XMLStreamReader getXMLStreamReader() {
        return this.getXMLStreamReader(true);
    }

    public XMLStreamReader getXMLStreamReaderWithoutCaching() {
        return this.getXMLStreamReader(false);
    }

    private XMLStreamReader getXMLStreamReader(boolean cache) {
        if (this.builder == null && this.done) {
            return new OMStAXWrapper(null, this, false);
        }
        if (this.builder == null && !cache) {
            throw new UnsupportedOperationException("This element was not created in a manner to be switched");
        }
        if (this.builder != null && this.builder.isCompleted() && !cache) {
            throw new UnsupportedOperationException("The parser is already consumed!");
        }
        return new OMStAXWrapper(this.builder, this, cache);
    }

    public void setText(String text) {
        for (OMNode child = this.getFirstOMChild(); child != null; child = child.getNextOMSibling()) {
            if (child.getType() != 4) continue;
            child.detach();
        }
        OMAbstractFactory.getOMFactory().createOMText((OMContainer)this, text);
    }

    public void setText(QName text) {
        for (OMNode child = this.getFirstOMChild(); child != null; child = child.getNextOMSibling()) {
            if (child.getType() != 4) continue;
            child.detach();
        }
        OMAbstractFactory.getOMFactory().createOMText((OMContainer)this, text);
    }

    public String getText() {
        String childText = "";
        for (OMNode child = this.getFirstOMChild(); child != null; child = child.getNextOMSibling()) {
            OMText textNode;
            String textValue;
            if (child.getType() != 4 || (textValue = (textNode = (OMText)child).getText()) == null || "".equals(textValue)) continue;
            childText = childText + textValue;
        }
        return childText;
    }

    public QName getTextAsQName() {
        String childText = "";
        for (OMNode child = this.getFirstOMChild(); child != null; child = child.getNextOMSibling()) {
            OMText textNode;
            String textValue;
            if (child.getType() != 4 || (textValue = (textNode = (OMText)child).getText()) == null || "".equals(textValue)) continue;
            String namespaceURI = textNode.getTextAsQName().getNamespaceURI();
            if (namespaceURI != null && !"".equals(namespaceURI)) {
                return textNode.getTextAsQName();
            }
            childText = childText + textValue;
        }
        return new QName(childText);
    }

    public String getTrimmedText() {
        String childText = "";
        for (OMNode child = this.getFirstOMChild(); child != null; child = child.getNextOMSibling()) {
            OMText textNode;
            String textValue;
            if (child.getType() != 4 || (textValue = (textNode = (OMText)child).getText()) == null || "".equals(textValue.trim())) continue;
            childText = childText + textValue.trim();
        }
        return childText;
    }

    public void internalSerialize(XMLStreamWriter writer) throws XMLStreamException {
        this.internalSerialize(writer, true);
    }

    protected void internalSerialize(XMLStreamWriter writer, boolean cache) throws XMLStreamException {
        if (cache) {
            OMSerializerUtil.serializeStartpart(this, writer);
            Iterator children = this.getChildren();
            while (children.hasNext()) {
                ((OMNodeEx)children.next()).internalSerialize(writer);
            }
            OMSerializerUtil.serializeEndpart(writer);
        } else if (this.done || this.builder == null) {
            OMSerializerUtil.serializeStartpart(this, writer);
            OMNodeImpl child = (OMNodeImpl)this.firstChild;
            while (child != null) {
                if (!(child instanceof OMElement) || child.isComplete() || child.builder == null) {
                    child.internalSerializeAndConsume(writer);
                } else {
                    OMElement element = (OMElement)((Object)child);
                    element.getBuilder().setCache(false);
                    OMSerializerUtil.serializeByPullStream(element, writer, cache);
                }
                child = child.nextSibling;
            }
            OMSerializerUtil.serializeEndpart(writer);
        } else {
            OMSerializerUtil.serializeByPullStream(this, writer, cache);
        }
    }

    public void internalSerializeAndConsume(XMLStreamWriter writer) throws XMLStreamException {
        this.internalSerialize(writer, false);
    }

    public OMElement getFirstElement() {
        for (OMNode node = this.getFirstOMChild(); node != null; node = node.getNextOMSibling()) {
            if (node.getType() != 1) continue;
            return (OMElement)node;
        }
        return null;
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public OMNamespace getNamespace() throws OMException {
        OMNamespace parentDefaultNS;
        if (this.ns == null && (parentDefaultNS = this.findNamespaceURI("")) != null && !"".equals(parentDefaultNS.getNamespaceURI())) {
            this.ns = DEFAULT_DEFAULT_NS_OBJECT;
        }
        return this.ns;
    }

    public void setNamespace(OMNamespace namespace) {
        OMNamespace nsObject = null;
        if (namespace != null) {
            nsObject = this.handleNamespace(namespace);
        }
        this.ns = nsObject;
    }

    public void setNamespaceWithNoFindInCurrentScope(OMNamespace namespace) {
        this.ns = namespace;
    }

    public QName getQName() {
        QName qName = this.ns != null ? (this.ns.getPrefix() != null ? new QName(this.ns.getNamespaceURI(), this.localName, this.ns.getPrefix()) : new QName(this.ns.getNamespaceURI(), this.localName)) : new QName(this.localName);
        return qName;
    }

    public String toStringWithConsume() throws XMLStreamException {
        StringWriter writer = new StringWriter();
        XMLStreamWriter writer2 = StAXUtils.createXMLStreamWriter(writer);
        this.serializeAndConsume(writer2);
        writer2.flush();
        return writer.toString();
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        try {
            XMLStreamWriter writer2 = StAXUtils.createXMLStreamWriter(writer);
            this.serialize(writer2);
            writer2.flush();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException("Can not serialize OM Element " + this.getLocalName(), e);
        }
        return writer.toString();
    }

    public void discard() throws OMException {
        if (this.done || this.builder == null) {
            this.detach();
        } else {
            this.builder.discard(this);
        }
    }

    public QName resolveQName(String qname) {
        ElementHelper helper = new ElementHelper(this);
        return helper.resolveQName(qname);
    }

    public OMElement cloneOMElement() {
        OMElement clonedElement = new StAXOMBuilder(this.getXMLStreamReader(true)).getDocumentElement();
        clonedElement.build();
        return clonedElement;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void buildWithAttachments() {
        if (!this.done) {
            this.build();
        }
        Iterator iterator = this.getChildren();
        while (iterator.hasNext()) {
            OMNode node = (OMNode)iterator.next();
            node.buildWithAttachments();
        }
    }

    protected void notifyChildComplete() {
        if (!this.done && this.builder == null) {
            Iterator iterator = this.getChildren();
            while (iterator.hasNext()) {
                OMNode node = (OMNode)iterator.next();
                if (node.isComplete()) continue;
                return;
            }
            this.setComplete(true);
        }
    }
}

