/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.attachments;

import java.io.IOException;
import java.io.InputStream;
import org.apache.axiom.attachments.MIMEBodyPartInputStream;

public class PushbackFilePartInputStream
extends InputStream {
    MIMEBodyPartInputStream inStream;
    byte[] buffer;
    int count;

    public PushbackFilePartInputStream(MIMEBodyPartInputStream inStream, byte[] buffer) {
        this.inStream = inStream;
        this.buffer = buffer;
        this.count = buffer.length;
    }

    public int read() throws IOException {
        int data;
        if (this.count > 0) {
            byte byteValue = this.buffer[this.buffer.length - this.count];
            data = byteValue & 0xFF;
            --this.count;
        } else {
            data = this.inStream.read();
        }
        return data;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.count > 0) {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            if (this.count < len) {
                System.arraycopy(this.buffer, this.buffer.length - this.count, b, off, this.count);
                int bytesCopied = this.count;
                this.count = 0;
                return bytesCopied;
            }
            System.arraycopy(this.buffer, this.buffer.length - this.count, b, off, len);
            this.count -= len;
            return len;
        }
        return this.inStream.read(b, off, len);
    }

    public int available() throws IOException {
        return this.count + this.inStream.available();
    }
}

