/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.attachments;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.UnsupportedEncodingException;
import java.util.Set;
import java.util.TreeMap;
import javax.activation.DataHandler;
import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;
import org.apache.axiom.attachments.BoundaryDelimitedStream;
import org.apache.axiom.attachments.IncomingAttachmentStreams;
import org.apache.axiom.attachments.MIMEBodyPartInputStream;
import org.apache.axiom.attachments.MultipartAttachmentStreams;
import org.apache.axiom.attachments.Part;
import org.apache.axiom.attachments.PartOnFile;
import org.apache.axiom.attachments.PartOnMemory;
import org.apache.axiom.attachments.PushbackFilePartInputStream;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Attachments {
    ContentType contentType;
    byte[] boundary;
    String applicationType;
    PushbackInputStream pushbackInStream;
    int PUSHBACK_SIZE = 1000;
    TreeMap attachmentsMap;
    int partIndex = 0;
    IncomingAttachmentStreams streams = null;
    private boolean streamsRequested = false;
    private boolean partsRequested = false;
    private boolean endOfStreamReached;
    private boolean noStreams = false;
    private String firstPartId;
    private boolean fileCacheEnable;
    private String attachmentRepoDir;
    private int fileStorageThreshold;
    protected static Log log = LogFactory.getLog((Class)(class$org$apache$axiom$attachments$Attachments == null ? (class$org$apache$axiom$attachments$Attachments = Attachments.class$("org.apache.axiom.attachments.Attachments")) : class$org$apache$axiom$attachments$Attachments));
    static /* synthetic */ Class class$org$apache$axiom$attachments$Attachments;

    public Attachments(InputStream inStream, String contentTypeString, boolean fileCacheEnable, String attachmentRepoDir, String fileThreshold) throws OMException {
        this.attachmentRepoDir = attachmentRepoDir;
        this.fileCacheEnable = fileCacheEnable;
        this.fileStorageThreshold = fileThreshold != null && !"".equals(fileThreshold) ? Integer.parseInt(fileThreshold) : 1;
        this.attachmentsMap = new TreeMap();
        try {
            this.contentType = new ContentType(contentTypeString);
        }
        catch (ParseException e) {
            throw new OMException("Invalid Content Type Field in the Mime Message", e);
        }
        try {
            this.boundary = ("--" + this.contentType.getParameter("boundary")).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new OMException(e);
        }
        this.pushbackInStream = new PushbackInputStream(inStream, this.PUSHBACK_SIZE);
        try {
            block9: {
                while (true) {
                    int value;
                    if ((byte)(value = this.pushbackInStream.read()) == this.boundary[0]) {
                        int boundaryIndex;
                        for (boundaryIndex = 0; boundaryIndex < this.boundary.length && (byte)value == this.boundary[boundaryIndex]; ++boundaryIndex) {
                            value = this.pushbackInStream.read();
                            if (value != -1) continue;
                            throw new OMException("Unexpected End of Stream while searching for first Mime Boundary");
                        }
                        if (boundaryIndex != this.boundary.length) continue;
                        break block9;
                    }
                    if ((byte)value == -1) break;
                }
                throw new OMException("Mime parts not found. Stream ended while searching for the boundary");
            }
            this.pushbackInStream.read();
        }
        catch (IOException e1) {
            throw new OMException("Stream Error" + e1.toString(), e1);
        }
        this.getDataHandler(this.getSOAPPartContentID());
        this.partsRequested = false;
    }

    public Attachments(InputStream inStream, String contentTypeString) throws OMException {
        this(inStream, contentTypeString, false, null, null);
    }

    public Attachments() {
        this.attachmentsMap = new TreeMap();
        this.noStreams = true;
    }

    public String getAttachmentSpecType() {
        if (this.applicationType == null) {
            this.applicationType = this.contentType.getParameter("type");
            if ("application/xop+xml".equalsIgnoreCase(this.applicationType)) {
                this.applicationType = "application/xop+xml";
            } else if ("text/xml".equalsIgnoreCase(this.applicationType)) {
                this.applicationType = "text/xml";
            } else if ("application/soap+xml".equalsIgnoreCase(this.applicationType)) {
                this.applicationType = "application/soap+xml";
            } else {
                throw new OMException("Invalid Application type. Support available for MTOM & SwA only.");
            }
        }
        return this.applicationType;
    }

    public DataHandler getDataHandler(String blobContentID) {
        if (this.attachmentsMap.containsKey(blobContentID)) {
            DataHandler dataHandler = (DataHandler)this.attachmentsMap.get(blobContentID);
            return dataHandler;
        }
        if (!this.noStreams) {
            DataHandler dataHandler;
            while ((dataHandler = this.getNextPartDataHandler()) != null) {
                if (!this.attachmentsMap.containsKey(blobContentID)) continue;
                dataHandler = (DataHandler)this.attachmentsMap.get(blobContentID);
                return dataHandler;
            }
        }
        return null;
    }

    public void addDataHandler(String contentID, DataHandler dataHandler) {
        this.attachmentsMap.put(contentID, dataHandler);
    }

    public void removeDataHandler(String blobContentID) {
        if (this.attachmentsMap.containsKey(blobContentID)) {
            this.attachmentsMap.remove(blobContentID);
        } else if (!this.noStreams) {
            DataHandler dataHandler;
            while ((dataHandler = this.getNextPartDataHandler()) != null) {
                if (!this.attachmentsMap.containsKey(blobContentID)) continue;
                this.attachmentsMap.remove(blobContentID);
            }
        }
    }

    public InputStream getSOAPPartInputStream() throws OMException {
        if (this.noStreams) {
            throw new OMException("Invalid operation. Attachments are created programatically.");
        }
        try {
            DataHandler dh = this.getDataHandler(this.getSOAPPartContentID());
            if (dh == null) {
                throw new OMException("Mandatory Root MIME part containing the SOAP Envelope is missing");
            }
            return dh.getInputStream();
        }
        catch (IOException e) {
            throw new OMException("Problem with DataHandler of the Root Mime Part. ", e);
        }
    }

    public String getSOAPPartContentID() {
        String rootContentID = this.contentType.getParameter("start");
        if (rootContentID == null) {
            if (this.partIndex == 0) {
                this.getNextPartDataHandler();
            }
            rootContentID = this.firstPartId;
        } else if ((rootContentID = rootContentID.trim()).indexOf("<") > -1 & rootContentID.indexOf(">") > -1) {
            rootContentID = rootContentID.substring(1, rootContentID.length() - 1);
        }
        if ("cid".equalsIgnoreCase(rootContentID.substring(0, 3))) {
            rootContentID = rootContentID.substring(4);
        }
        return rootContentID;
    }

    public String getSOAPPartContentType() {
        if (!this.noStreams) {
            DataHandler soapPart = this.getDataHandler(this.getSOAPPartContentID());
            return soapPart.getContentType();
        }
        throw new OMException("The attachments map was created programatically. Unsupported operation.");
    }

    public IncomingAttachmentStreams getIncomingAttachmentStreams() throws IllegalStateException {
        if (this.partsRequested) {
            throw new IllegalStateException("The attachments stream can only be accessed once; either by using the IncomingAttachmentStreams class or by getting a collection of AttachmentPart objects. They cannot both be called within the life time of the same service request.");
        }
        if (this.noStreams) {
            throw new IllegalStateException("The attachments map was created programatically. No streams are available.");
        }
        this.streamsRequested = true;
        if (this.streams == null) {
            BoundaryDelimitedStream boundaryDelimitedStream = new BoundaryDelimitedStream(this.pushbackInStream, this.boundary, 1024);
            this.streams = new MultipartAttachmentStreams(boundaryDelimitedStream);
        }
        return this.streams;
    }

    public String[] getAllContentIDs() {
        Set keys = this.getContentIDSet();
        return keys.toArray(new String[keys.size()]);
    }

    public Set getContentIDSet() {
        DataHandler dataHandler;
        while (!this.noStreams && (dataHandler = this.getNextPartDataHandler()) != null) {
        }
        return this.attachmentsMap.keySet();
    }

    protected void setEndOfStream(boolean value) {
        this.endOfStreamReached = value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DataHandler getNextPartDataHandler() throws OMException {
        if (this.endOfStreamReached) {
            return null;
        }
        Part nextPart = this.getPart();
        if (nextPart == null) {
            return null;
        }
        if (nextPart.getSize() <= 0) return null;
        try {
            String partContentID = nextPart.getContentID();
            if (partContentID == null & this.partIndex == 1) {
                String id = "firstPart_" + UUIDGenerator.getUUID();
                this.attachmentsMap.put(id, nextPart.getDataHandler());
                this.firstPartId = id;
                return nextPart.getDataHandler();
            }
            if (partContentID == null) {
                throw new OMException("Part content ID cannot be blank for non root MIME parts");
            }
            if (partContentID.indexOf("<") > -1 & partContentID.indexOf(">") > -1) {
                partContentID = partContentID.substring(1, partContentID.length() - 1);
            } else if (this.partIndex == 1) {
                this.firstPartId = partContentID;
            }
            if (this.attachmentsMap.containsKey(partContentID)) {
                throw new OMException("Two MIME parts with the same Content-ID not allowed.");
            }
            this.attachmentsMap.put(partContentID, nextPart.getDataHandler());
            return nextPart.getDataHandler();
        }
        catch (MessagingException e) {
            try {
                throw new OMException("Error reading Content-ID from the Part." + (Object)((Object)e));
            }
            catch (MessagingException e2) {
                throw new OMException(e2);
            }
        }
    }

    private Part getPart() throws OMException {
        Part part;
        block10: {
            if (this.streamsRequested) {
                throw new IllegalStateException("The attachments stream can only be accessed once; either by using the IncomingAttachmentStreams class or by getting a collection of AttachmentPart objects. They cannot both be called within the life time of the same service request.");
            }
            this.partsRequested = true;
            try {
                if (this.fileCacheEnable) {
                    try {
                        byte[] buffer = new byte[this.fileStorageThreshold];
                        MIMEBodyPartInputStream partStream = new MIMEBodyPartInputStream(this.pushbackInStream, this.boundary, this, this.PUSHBACK_SIZE);
                        int count = 0;
                        do {
                            int len;
                            int off = 0;
                            int rem = this.fileStorageThreshold;
                            while ((len = partStream.read(buffer, off, rem)) > 0) {
                                off += len;
                                rem -= len;
                            }
                            count += off;
                        } while (partStream.available() > 0);
                        if (count == this.fileStorageThreshold) {
                            PushbackFilePartInputStream filePartStream = new PushbackFilePartInputStream(partStream, buffer);
                            part = new PartOnFile(filePartStream, this.attachmentRepoDir);
                        } else {
                            ByteArrayInputStream byteArrayInStream = new ByteArrayInputStream(buffer, 0, count);
                            part = new PartOnMemory(byteArrayInStream);
                        }
                        break block10;
                    }
                    catch (Exception e) {
                        throw new OMException("Error creating temporary File.", e);
                    }
                }
                MIMEBodyPartInputStream partStream = new MIMEBodyPartInputStream(this.pushbackInStream, this.boundary, this, this.PUSHBACK_SIZE);
                part = new PartOnMemory(partStream);
            }
            catch (MessagingException e) {
                throw new OMException(e);
            }
        }
        ++this.partIndex;
        return part;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

