/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.dom;

import java.util.Iterator;
import java.util.Stack;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMComment;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.impl.EmptyOMLocation;
import org.apache.axiom.om.impl.dom.DOMNavigator;
import org.apache.axiom.om.impl.exception.OMStreamingException;
import org.w3c.dom.Attr;

public class DOMStAXWrapper
implements XMLStreamReader,
XMLStreamConstants {
    private DOMNavigator navigator;
    private OMXMLParserWrapper builder;
    private XMLStreamReader parser;
    private OMNode rootNode;
    private boolean isFirst = true;
    private static final short NAVIGABLE = 0;
    private static final short SWITCH_AT_NEXT = 1;
    private static final short COMPLETED = 2;
    private static final short SWITCHED = 3;
    private static final short DOCUMENT_COMPLETE = 4;
    private short state;
    private int currentEvent = 7;
    boolean switchingAllowed = false;
    private Stack elementStack = new Stack();
    private OMNode nextNode = null;
    private OMNode currentNode = null;
    private OMNode lastNode = null;
    private boolean needToThrowEndDocument = false;

    public void setAllowSwitching(boolean b) {
        this.switchingAllowed = b;
    }

    public boolean isAllowSwitching() {
        return this.switchingAllowed;
    }

    public DOMStAXWrapper(OMXMLParserWrapper builder, OMElement startNode) {
        this(builder, startNode, false);
    }

    public DOMStAXWrapper(OMXMLParserWrapper builder, OMElement startNode, boolean cache) {
        this.navigator = new DOMNavigator(startNode);
        this.builder = builder;
        this.rootNode = startNode;
        if (this.rootNode != null && this.rootNode.getParent() != null && this.rootNode.getParent() instanceof OMDocument) {
            this.needToThrowEndDocument = true;
        }
        this.currentNode = this.navigator.next();
        this.updateNextNode();
        this.switchingAllowed = !cache;
    }

    public String getPrefix() {
        String returnStr = null;
        if (this.parser != null) {
            returnStr = this.parser.getPrefix();
        } else if (this.currentEvent == 1 || this.currentEvent == 2) {
            OMNamespace ns = ((OMElement)this.lastNode).getNamespace();
            returnStr = ns == null ? null : ns.getPrefix();
        }
        return returnStr;
    }

    public String getNamespaceURI() {
        String returnStr = null;
        if (this.parser != null) {
            returnStr = this.parser.getNamespaceURI();
        } else if (this.currentEvent == 1 || this.currentEvent == 2 || this.currentEvent == 13) {
            OMNamespace ns = ((OMElement)this.lastNode).getNamespace();
            returnStr = ns == null ? null : ns.getNamespaceURI();
        }
        return returnStr != null ? returnStr.intern() : null;
    }

    public boolean hasName() {
        if (this.parser != null) {
            return this.parser.hasName();
        }
        return this.currentEvent == 1 || this.currentEvent == 2;
    }

    public String getLocalName() {
        String returnStr = null;
        if (this.parser != null) {
            returnStr = this.parser.getLocalName();
        } else if (this.currentEvent == 1 || this.currentEvent == 2 || this.currentEvent == 9) {
            returnStr = ((OMElement)this.lastNode).getLocalName();
        }
        return returnStr;
    }

    public QName getName() {
        QName returnName = null;
        if (this.parser != null) {
            returnName = this.parser.getName();
        } else if (this.currentEvent == 1 || this.currentEvent == 2) {
            returnName = this.getQName((OMElement)this.lastNode);
        }
        return returnName;
    }

    public boolean hasText() {
        return this.currentEvent == 4 || this.currentEvent == 11 || this.currentEvent == 9 || this.currentEvent == 5 || this.currentEvent == 6;
    }

    public int getTextLength() {
        int returnLength = 0;
        if (this.parser != null) {
            returnLength = this.parser.getTextLength();
        } else {
            OMText textNode = (OMText)this.lastNode;
            returnLength = textNode.getText().length();
        }
        return returnLength;
    }

    public int getTextStart() {
        int returnLength = 0;
        if (this.parser != null) {
            returnLength = this.parser.getTextStart();
        }
        return returnLength;
    }

    public int getTextCharacters(int i, char[] chars, int i1, int i2) throws XMLStreamException {
        int returnLength = 0;
        if (this.hasText() && this.parser != null) {
            try {
                returnLength = this.parser.getTextCharacters(i, chars, i1, i2);
            }
            catch (XMLStreamException e) {
                throw new OMStreamingException(e);
            }
        }
        return returnLength;
    }

    public char[] getTextCharacters() {
        char[] returnArray = null;
        if (this.parser != null) {
            returnArray = this.parser.getTextCharacters();
        } else if (this.hasText()) {
            OMText textNode = (OMText)this.lastNode;
            String str = textNode.getText();
            returnArray = str.toCharArray();
        }
        return returnArray;
    }

    public String getText() {
        String returnString = null;
        if (this.parser != null) {
            returnString = this.parser.getText();
        } else if (this.hasText()) {
            if (this.lastNode instanceof OMText) {
                returnString = ((OMText)this.lastNode).getText();
            } else if (this.lastNode instanceof OMComment) {
                returnString = ((OMComment)this.lastNode).getValue();
            }
        }
        return returnString;
    }

    public int getEventType() {
        return this.currentEvent;
    }

    public String getNamespaceURI(int i) {
        String returnString = null;
        if (this.parser != null) {
            returnString = this.parser.getNamespaceURI(i);
        } else if (this.isStartElement() || this.isEndElement() || this.currentEvent == 13) {
            OMNamespace ns = (OMNamespace)this.getItemFromIterator(((OMElement)this.lastNode).getAllDeclaredNamespaces(), i);
            returnString = ns == null ? null : ns.getNamespaceURI();
        }
        return returnString;
    }

    public String getNamespacePrefix(int i) {
        String returnString = null;
        if (this.parser != null) {
            returnString = this.parser.getNamespacePrefix(i);
        } else if (this.isStartElement() || this.isEndElement() || this.currentEvent == 13) {
            OMNamespace ns = (OMNamespace)this.getItemFromIterator(((OMElement)this.lastNode).getAllDeclaredNamespaces(), i);
            returnString = ns == null ? null : ns.getPrefix();
        }
        return returnString;
    }

    public int getNamespaceCount() {
        int returnCount = 0;
        if (this.parser != null) {
            returnCount = this.parser.getNamespaceCount();
        } else if (this.isStartElement() || this.isEndElement() || this.currentEvent == 13) {
            returnCount = this.getCount(((OMElement)this.lastNode).getAllDeclaredNamespaces());
        }
        return returnCount;
    }

    public boolean isAttributeSpecified(int i) {
        boolean returnValue = false;
        if (this.parser != null) {
            returnValue = this.parser.isAttributeSpecified(i);
        } else if (!this.isStartElement() && this.currentEvent != 10) {
            throw new IllegalStateException("attribute type accessed in illegal event!");
        }
        return returnValue;
    }

    public String getAttributeValue(int i) {
        String returnString = null;
        if (this.parser != null) {
            returnString = this.parser.getAttributeValue(i);
        } else if (this.isStartElement() || this.currentEvent == 10) {
            OMAttribute attrib = this.getAttribute((OMElement)this.lastNode, i);
            if (attrib != null) {
                returnString = attrib.getAttributeValue();
            }
        } else {
            throw new IllegalStateException("attribute type accessed in illegal event!");
        }
        return returnString;
    }

    public String getAttributeType(int i) {
        String returnString = null;
        if (this.parser != null) {
            returnString = this.parser.getAttributeType(i);
        } else if (!this.isStartElement() && this.currentEvent != 10) {
            throw new IllegalStateException("attribute type accessed in illegal event!");
        }
        return returnString;
    }

    public String getAttributePrefix(int i) {
        String returnString = null;
        if (this.parser != null) {
            returnString = this.parser.getAttributePrefix(i);
        } else if (this.isStartElement() || this.currentEvent == 10) {
            OMNamespace nameSpace;
            OMAttribute attrib = this.getAttribute((OMElement)this.lastNode, i);
            if (attrib != null && (nameSpace = attrib.getNamespace()) != null) {
                returnString = nameSpace.getPrefix();
            }
        } else {
            throw new IllegalStateException("attribute prefix accessed in illegal event!");
        }
        return returnString;
    }

    public String getAttributeLocalName(int i) {
        String returnString = null;
        if (this.parser != null) {
            returnString = this.parser.getAttributeLocalName(i);
        } else if (this.isStartElement() || this.currentEvent == 10) {
            OMAttribute attrib = this.getAttribute((OMElement)this.lastNode, i);
            if (attrib != null) {
                returnString = attrib.getNamespace() != null ? attrib.getLocalName() : ((Attr)((Object)attrib)).getNodeName();
            }
        } else {
            throw new IllegalStateException("attribute localName accessed in illegal event!");
        }
        return returnString;
    }

    public String getAttributeNamespace(int i) {
        String returnString = null;
        if (this.parser != null) {
            returnString = this.parser.getAttributeNamespace(i);
        } else if (this.isStartElement() || this.currentEvent == 10) {
            OMNamespace nameSpace;
            OMAttribute attrib = this.getAttribute((OMElement)this.lastNode, i);
            if (attrib != null && (nameSpace = attrib.getNamespace()) != null) {
                returnString = nameSpace.getNamespaceURI();
            }
        } else {
            throw new IllegalStateException("attribute nameSpace accessed in illegal event!");
        }
        return returnString;
    }

    public QName getAttributeName(int i) {
        QName returnQName = null;
        if (this.parser != null) {
            returnQName = this.parser.getAttributeName(i);
        } else if (this.isStartElement() || this.currentEvent == 10) {
            returnQName = this.getAttribute((OMElement)this.lastNode, i).getQName();
        } else {
            throw new IllegalStateException("attribute count accessed in illegal event!");
        }
        return returnQName;
    }

    public int getAttributeCount() {
        int returnCount = 0;
        if (this.parser != null) {
            returnCount = this.parser.getAttributeCount();
        } else if (this.isStartElement() || this.currentEvent == 10) {
            OMElement elt = (OMElement)this.lastNode;
            returnCount = this.getCount(elt.getAllAttributes());
        } else {
            throw new IllegalStateException("attribute count accessed in illegal event (" + this.currentEvent + ")!");
        }
        return returnCount;
    }

    public String getAttributeValue(String s, String s1) {
        String returnString = null;
        if (this.parser != null) {
            returnString = this.parser.getAttributeValue(s, s1);
        } else if (this.isStartElement() || this.currentEvent == 10) {
            QName qname = new QName(s, s1);
            OMAttribute attrib = ((OMElement)this.lastNode).getAttribute(qname);
            if (attrib != null) {
                returnString = attrib.getAttributeValue();
            }
        } else {
            throw new IllegalStateException("attribute type accessed in illegal event!");
        }
        return returnString;
    }

    public boolean isWhiteSpace() {
        boolean b = this.parser != null ? this.parser.isWhiteSpace() : this.currentEvent == 6;
        return b;
    }

    public boolean isCharacters() {
        boolean b = this.parser != null ? this.parser.isCharacters() : this.currentEvent == 4;
        return b;
    }

    public boolean isEndElement() {
        boolean b = this.parser != null ? this.parser.isEndElement() : this.currentEvent == 2;
        return b;
    }

    public void require(int i, String s, String s1) throws XMLStreamException {
        throw new XMLStreamException();
    }

    public boolean isStartElement() {
        boolean b = this.parser != null ? this.parser.isStartElement() : this.currentEvent == 1;
        return b;
    }

    public String getNamespaceURI(String s) {
        String returnString = null;
        if (this.parser != null) {
            returnString = this.parser.getNamespaceURI(s);
        } else if (this.isStartElement() || this.isEndElement() || this.currentEvent == 13) {
            // empty if block
        }
        return returnString;
    }

    public void close() throws XMLStreamException {
        if (this.parser != null) {
            this.parser.close();
        }
    }

    public boolean hasNext() throws XMLStreamException {
        if (this.needToThrowEndDocument) {
            return this.state != 4;
        }
        return this.state != 2 && this.currentEvent != 8;
    }

    public int nextTag() throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    public String getElementText() throws XMLStreamException {
        String returnText = "";
        if (this.parser != null) {
            try {
                returnText = this.parser.getElementText();
            }
            catch (XMLStreamException e) {
                throw new OMStreamingException(e);
            }
        } else if (this.currentNode.getType() == 1) {
            returnText = ((OMElement)this.currentNode).getText();
        } else if (this.currentNode.getType() == 4) {
            returnText = ((OMText)this.currentNode).getText();
        }
        return returnText;
    }

    public int next() throws XMLStreamException {
        switch (this.state) {
            case 4: {
                throw new XMLStreamException("End of the document reached");
            }
            case 2: {
                this.state = (short)4;
                this.currentEvent = 8;
                break;
            }
            case 1: {
                this.state = (short)3;
                try {
                    this.parser = (XMLStreamReader)this.builder.getParser();
                }
                catch (Exception e) {
                    throw new XMLStreamException("problem accessing the parser", e);
                }
                this.currentEvent = this.currentEvent == 7 && this.currentEvent == this.parser.getEventType() ? this.parser.next() : this.parser.getEventType();
                this.updateCompleteStatus();
                break;
            }
            case 0: {
                this.currentEvent = this.generateEvents(this.currentNode);
                this.updateCompleteStatus();
                this.updateLastNode();
                break;
            }
            case 3: {
                this.currentEvent = this.parser.next();
                this.updateCompleteStatus();
                break;
            }
            default: {
                throw new OMStreamingException("unsuppported state!");
            }
        }
        return this.currentEvent;
    }

    public Object getProperty(String s) throws IllegalArgumentException {
        throw new IllegalArgumentException();
    }

    private void updateLastNode() throws XMLStreamException {
        this.lastNode = this.currentNode;
        this.currentNode = this.nextNode;
        try {
            this.updateNextNode();
        }
        catch (Exception e) {
            throw new XMLStreamException(e);
        }
    }

    private void updateNextNode() {
        if (this.navigator.isNavigable()) {
            this.nextNode = this.navigator.next();
        } else if (!this.switchingAllowed) {
            if (this.navigator.isCompleted()) {
                this.nextNode = null;
            } else {
                this.builder.next();
                this.navigator.step();
                this.nextNode = this.navigator.next();
            }
        } else {
            this.builder.setCache(false);
            this.state = 1;
        }
    }

    private void updateCompleteStatus() {
        if (this.state == 0) {
            if (this.rootNode == this.currentNode) {
                if (this.isFirst) {
                    this.isFirst = false;
                } else {
                    this.state = (short)2;
                }
            }
        } else {
            this.state = (short)(this.currentEvent == 8 ? 4 : (int)this.state);
        }
    }

    public NamespaceContext getNamespaceContext() {
        throw new UnsupportedOperationException();
    }

    public String getEncoding() {
        return null;
    }

    public Location getLocation() {
        return new EmptyOMLocation();
    }

    public String getVersion() {
        return "1.0";
    }

    public boolean isStandalone() {
        return true;
    }

    public boolean standaloneSet() {
        return false;
    }

    public String getCharacterEncodingScheme() {
        return "utf-8";
    }

    public String getPITarget() {
        throw new UnsupportedOperationException();
    }

    public String getPIData() {
        throw new UnsupportedOperationException();
    }

    private int generateEvents(OMNode node) {
        int returnEvent = 0;
        int nodeType = node.getType();
        switch (nodeType) {
            case 1: {
                OMElement element = (OMElement)node;
                returnEvent = this.generateElementEvents(element);
                break;
            }
            case 4: {
                returnEvent = this.generateTextEvents();
                break;
            }
            case 5: {
                returnEvent = this.generateCommentEvents();
                break;
            }
            case 12: {
                returnEvent = this.generateCdataEvents();
                break;
            }
        }
        return returnEvent;
    }

    private int generateElementEvents(OMElement elt) {
        int returnValue = 1;
        if (!this.elementStack.isEmpty() && this.elementStack.peek().equals(elt)) {
            returnValue = 2;
            this.elementStack.pop();
        } else {
            this.elementStack.push(elt);
        }
        return returnValue;
    }

    private int generateTextEvents() {
        return 4;
    }

    private int generateCommentEvents() {
        return 5;
    }

    private int generateCdataEvents() {
        return 12;
    }

    private int getCount(Iterator it) {
        int count = 0;
        if (it != null) {
            while (it.hasNext()) {
                it.next();
                ++count;
            }
        }
        return count;
    }

    private Object getItemFromIterator(Iterator it, int index) {
        int count = 0;
        Object returnObject = null;
        boolean found = false;
        if (it != null) {
            while (it.hasNext()) {
                returnObject = it.next();
                if (index != count++) continue;
                found = true;
                break;
            }
        }
        if (found) {
            return returnObject;
        }
        return null;
    }

    private QName getQName(OMElement element) {
        QName returnName;
        OMNamespace ns = element.getNamespace();
        String localPart = element.getLocalName();
        if (ns != null) {
            String prefix = ns.getPrefix();
            String uri = ns.getNamespaceURI();
            returnName = prefix == null || prefix.equals("") ? new QName(uri, localPart) : new QName(uri, localPart, prefix);
        } else {
            returnName = new QName(localPart);
        }
        return returnName;
    }

    private OMAttribute getAttribute(OMElement elt, int index) {
        OMAttribute returnAttrib = null;
        if (elt != null) {
            returnAttrib = (OMAttribute)this.getItemFromIterator(elt.getAllAttributes(), index);
        }
        return returnAttrib;
    }

    public void setParser(XMLStreamReader parser) {
        this.parser = parser;
    }
}

