/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.llom;

import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.llom.OMElementImpl;
import org.apache.axiom.om.impl.llom.OMNodeImpl;
import org.apache.axiom.om.impl.llom.OMSourcedElementImpl;

public class OMNavigator {
    protected OMNode node;
    private boolean visited;
    private OMNode next;
    private OMNode root;
    private boolean backtracked;
    private boolean end = false;
    private boolean start = true;

    public OMNavigator() {
    }

    public OMNavigator(OMNode node) {
        this.init(node);
    }

    public void init(OMNode node) {
        this.next = node;
        this.root = node;
        this.backtracked = false;
    }

    public OMNode next() {
        if (this.next == null) {
            return null;
        }
        this.node = this.next;
        this.visited = this.backtracked;
        this.backtracked = false;
        this.updateNextNode();
        if (this.root.equals(this.node)) {
            if (!this.start) {
                this.end = true;
            } else {
                this.start = false;
            }
        }
        return this.node;
    }

    private void updateNextNode() {
        if (this.next instanceof OMElement && !this.visited) {
            OMNode firstChild = this._getFirstChild((OMElement)this.next);
            if (firstChild != null) {
                this.next = firstChild;
            } else if (this.next.isComplete()) {
                this.backtracked = true;
            } else {
                this.next = null;
            }
        } else {
            OMContainer parent = this.next.getParent();
            OMNode nextSibling = this.getNextSibling(this.next);
            if (nextSibling != null) {
                this.next = nextSibling;
            } else if (parent != null && parent.isComplete() && !(parent instanceof OMDocument)) {
                this.next = (OMNodeImpl)((Object)parent);
                this.backtracked = true;
            } else {
                this.next = null;
            }
        }
    }

    private OMNode _getFirstChild(OMElement node) {
        if (node instanceof OMSourcedElementImpl) {
            OMNode first;
            for (OMNode sibling = first = node.getFirstOMChild(); sibling != null; sibling = sibling.getNextOMSibling()) {
            }
            return first;
        }
        return ((OMElementImpl)node).firstChild;
    }

    private OMNode getNextSibling(OMNode node) {
        if (node instanceof OMSourcedElementImpl) {
            return node.getNextOMSibling();
        }
        return ((OMNodeImpl)node).nextSibling;
    }

    public boolean visited() {
        return this.visited;
    }

    public void step() {
        if (!this.end) {
            this.next = this.node;
            this.updateNextNode();
        }
    }

    public boolean isNavigable() {
        if (this.end) {
            return false;
        }
        return this.next != null;
    }

    public boolean isCompleted() {
        return this.end;
    }
}

