/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.attachments;

import java.io.ByteArrayInputStream;
import java.io.PushbackInputStream;
import junit.framework.TestCase;
import org.apache.axiom.attachments.BoundaryPushbackInputStream;

public class BoundaryPushbackInputStreamTest
extends TestCase {
    public void testReadWithNewline() throws Exception {
        byte[] boundary = "--boundary".getBytes("ascii");
        byte[] data = "xxxxxxxxxxxxxxxxxxxxxxxxxxx\r\n--boundary\r\nyyyyyyyyyyyyyy".getBytes("ascii");
        for (int bufferSize = 1; bufferSize < data.length; ++bufferSize) {
            byte[] buffer = new byte[bufferSize];
            for (int pushBackSize = 0; pushBackSize < data.length; ++pushBackSize) {
                int read;
                PushbackInputStream pbis = new PushbackInputStream(new ByteArrayInputStream(data), 20);
                BoundaryPushbackInputStream bpbis = new BoundaryPushbackInputStream(pbis, boundary, pushBackSize);
                int count = 0;
                while ((read = bpbis.read(buffer)) != -1) {
                    count += read;
                }
                BoundaryPushbackInputStreamTest.assertEquals((int)27, (int)count);
            }
        }
    }
}

