/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.attachments;

import java.io.File;
import java.io.InputStream;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.attachments.IncomingAttachmentInputStream;
import org.apache.axiom.attachments.IncomingAttachmentStreams;
import org.apache.axiom.om.AbstractTestCase;

public class IncomingAttachmentTest
extends AbstractTestCase {
    File temp;

    public void testIncomingAttachmentInputStreamFunctions() throws Exception {
        InputStream inStream = IncomingAttachmentTest.getTestResource("mtom/MTOMAttachmentStream.bin");
        Attachments attachments = new Attachments(inStream, "multipart/related; boundary=\"MIMEBoundaryurn:uuid:A3ADBAEE51A1A87B2A11443668160701\"; type=\"application/xop+xml\"; start=\"<0.urn:uuid:A3ADBAEE51A1A87B2A11443668160702@apache.org>\"; start-info=\"application/soap+xml\"; charset=UTF-8;action=\"mtomSample\"");
        IncomingAttachmentStreams ias = attachments.getIncomingAttachmentStreams();
        IncomingAttachmentInputStream dataIs = ias.getNextStream();
        IncomingAttachmentTest.assertEquals((String)"<1.urn:uuid:A3ADBAEE51A1A87B2A11443668160943@apache.org>", (String)dataIs.getContentId());
        while (dataIs.read() != -1) {
        }
        dataIs = ias.getNextStream();
        IncomingAttachmentTest.assertEquals((String)"<2.urn:uuid:A3ADBAEE51A1A87B2A11443668160994@apache.org>", (String)dataIs.getContentId());
        IncomingAttachmentTest.assertEquals((String)"image/jpeg", (String)dataIs.getContentType());
        dataIs.addHeader("new-header", "test-value");
        IncomingAttachmentTest.assertEquals((String)"test-value", (String)dataIs.getHeader("new-header"));
    }
}

