/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import javax.activation.DataSource;
import javax.activation.URLDataSource;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.custommonkey.xmlunit.XMLTestCase;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;

public abstract class AbstractTestCase
extends XMLTestCase {
    protected String tempDir = "target" + File.separator + "generated" + File.separator + "temp";
    public static final String[] soapFiles = new String[]{"emtyBodymessage.xml", "invalidMustUnderstandSOAP12.xml", "minimalMessage.xml", "OMElementTest.xml", "reallyReallyBigMessage.xml", "sample1.xml", "security2-soap.xml", "soap12/message.xml", "soap12RoleMessage.xml", "soapmessage.xml", "soapmessage1.xml", "whitespacedMessage.xml"};
    public String basedir = System.getProperty("basedir");

    public AbstractTestCase() {
        this(null);
    }

    public AbstractTestCase(String testName) {
        super(testName);
        if (this.basedir == null) {
            this.basedir = new File(".").getAbsolutePath();
        }
        this.tempDir = new File(this.basedir, this.tempDir).getAbsolutePath();
    }

    public DataSource getTestResourceDataSource(String relativePath) {
        URL url = AbstractTestCase.class.getClassLoader().getResource(relativePath);
        if (url == null) {
            AbstractTestCase.fail((String)("The test resource " + relativePath + " could not be found"));
        }
        return new URLDataSource(url);
    }

    public static InputStream getTestResource(String relativePath) {
        InputStream in = AbstractTestCase.class.getClassLoader().getResourceAsStream(relativePath);
        if (in == null) {
            AbstractTestCase.fail((String)("The test resource " + relativePath + " could not be found"));
        }
        return in;
    }

    public static OMElement getTestResourceAsElement(OMMetaFactory omMetaFactory, String relativePath) {
        return OMXMLBuilderFactory.createOMBuilder((OMFactory)omMetaFactory.getOMFactory(), (InputStream)AbstractTestCase.getTestResource(relativePath)).getDocumentElement();
    }

    public static String[] getConformanceTestFiles() {
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(AbstractTestCase.class.getClassLoader().getResourceAsStream("conformance/filelist")));
            ArrayList<String> result = new ArrayList<String>(10);
            while ((line = in.readLine()) != null) {
                result.add("conformance/" + line);
            }
            in.close();
            return result.toArray(new String[result.size()]);
        }
        catch (IOException ex) {
            AbstractTestCase.fail((String)("Unable to load file list: " + ex.getMessage()));
            return null;
        }
    }

    public File getTempOutputFile(String filename) {
        File f = new File(this.tempDir);
        if (!f.exists()) {
            f.mkdirs();
        }
        return new File(f, filename);
    }

    public static Document toDocumentWithoutDTD(InputStream in) throws Exception {
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(in);
        DocumentType docType = doc.getDoctype();
        if (docType != null) {
            doc.removeChild(docType);
        }
        return doc;
    }
}

