/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.AbstractTestCase;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.util.AXIOMUtil;

public abstract class OMElementTestBase
extends AbstractTestCase {
    protected final OMMetaFactory omMetaFactory;

    public OMElementTestBase(OMMetaFactory omMetaFactory) {
        this.omMetaFactory = omMetaFactory;
    }

    public void testSetText() {
        OMFactory factory = this.omMetaFactory.getOMFactory();
        String localName = "TestLocalName";
        String namespace = "http://ws.apache.org/axis2/ns";
        String prefix = "axis2";
        OMElement elem = factory.createOMElement(localName, namespace, prefix);
        String text = "The quick brown fox jumps over the lazy dog";
        elem.setText(text);
        OMElementTestBase.assertEquals((String)"Text value mismatch", (String)text, (String)elem.getText());
    }

    public void testCDATA() throws Exception {
        OMFactory factory = this.omMetaFactory.getOMFactory();
        OMElement omElement = factory.createOMElement("TestElement", null);
        String text = "this is <some> text in a CDATA";
        factory.createOMText((OMContainer)omElement, "this is <some> text in a CDATA", 12);
        OMElementTestBase.assertEquals((String)"this is <some> text in a CDATA", (String)omElement.getText());
        omElement = factory.createOMElement("element2", null);
        String normalText = "regular text and ";
        factory.createOMText((OMContainer)omElement, "regular text and ");
        factory.createOMText((OMContainer)omElement, "this is <some> text in a CDATA", 12);
        OMElementTestBase.assertEquals((String)"regular text and this is <some> text in a CDATA", (String)omElement.getText());
    }

    public void testAddChild() {
        OMFactory factory = this.omMetaFactory.getOMFactory();
        String localName = "TestLocalName";
        String childLocalName = "TestChildLocalName";
        String namespace = "http://ws.apache.org/axis2/ns";
        String prefix = "axis2";
        OMElement elem = factory.createOMElement(localName, namespace, prefix);
        OMElement childElem = factory.createOMElement(childLocalName, namespace, prefix);
        elem.addChild((OMNode)childElem);
        Iterator it = elem.getChildrenWithName(new QName(namespace, childLocalName));
        int count = 0;
        while (it.hasNext()) {
            OMElement child = (OMElement)it.next();
            OMElementTestBase.assertEquals((String)"Child local name mismatch", (String)childLocalName, (String)child.getLocalName());
            OMElementTestBase.assertEquals((String)"Child namespace mismatch", (String)namespace, (String)child.getNamespace().getNamespaceURI());
            ++count;
        }
        OMElementTestBase.assertEquals((String)"In correct number of children", (int)1, (int)count);
    }

    public void testFindNamespaceByPrefix() throws Exception {
        OMElement root = AXIOMUtil.stringToOM((OMFactory)this.omMetaFactory.getOMFactory(), (String)"<a:root xmlns:a='urn:a'><child/></a:root>");
        OMNamespace ns = root.getFirstElement().findNamespace(null, "a");
        OMElementTestBase.assertNotNull((Object)ns);
        OMElementTestBase.assertEquals((String)"urn:a", (String)ns.getNamespaceURI());
        root.close(false);
    }

    private int getNumberOfOccurrences(String xml, String pattern) {
        int index = -1;
        int count = 0;
        while ((index = xml.indexOf(pattern, index + 1)) != -1) {
            ++count;
        }
        return count;
    }

    public void testDeclareDefaultNamespace1() throws XMLStreamException {
        OMFactory omFac = this.omMetaFactory.getOMFactory();
        OMElement documentElement = omFac.createOMElement("RootElement", null);
        documentElement.declareDefaultNamespace("http://one.org");
        OMNamespace ns = omFac.createOMNamespace("http://ws.apache.org/axis2", "ns2");
        OMElement childOne = omFac.createOMElement("ChildElementOne", ns, (OMContainer)documentElement);
        childOne.declareDefaultNamespace("http://two.org");
        OMElement childTwo = omFac.createOMElement("ChildElementTwo", null, (OMContainer)childOne);
        childTwo.declareDefaultNamespace("http://one.org");
        OMElementTestBase.assertEquals((int)2, (int)this.getNumberOfOccurrences(documentElement.toStringWithConsume(), "xmlns=\"http://one.org\""));
    }

    public void testDeclareDefaultNamespace2() throws XMLStreamException {
        OMFactory omFac = this.omMetaFactory.getOMFactory();
        OMElement documentElement = omFac.createOMElement("RootElement", null);
        OMNamespace ns1 = documentElement.declareNamespace("http://one.org", "ns1");
        OMNamespace ns2 = documentElement.declareNamespace("http://one.org", "ns2");
        OMElement childOne = omFac.createOMElement("ChildElementOne", ns2, (OMContainer)documentElement);
        childOne.declareDefaultNamespace("http://one.org");
        OMElement childTwo = omFac.createOMElement("ChildElementTwo", ns1, (OMContainer)childOne);
        OMElementTestBase.assertEquals((int)1, (int)this.getNumberOfOccurrences(documentElement.toStringWithConsume(), "xmlns:ns2=\"http://one.org\""));
    }

    public void testMultipleDefaultNS() {
        OMFactory omFactory = this.omMetaFactory.getOMFactory();
        OMNamespace defaultNS1 = omFactory.createOMNamespace("http://defaultNS1.org", null);
        OMNamespace defaultNS2 = omFactory.createOMNamespace("http://defaultNS2.org", null);
        OMElement omElementOne = omFactory.createOMElement("DocumentElement", null);
        omElementOne.declareDefaultNamespace("http://defaultNS1.org");
        OMElement omElementOneChild = omFactory.createOMElement("ChildOne", null, (OMContainer)omElementOne);
        OMElement omElementTwo = omFactory.createOMElement("Foo", defaultNS2, (OMContainer)omElementOne);
        omElementTwo.declareDefaultNamespace("http://defaultNS2.org");
        OMElement omElementTwoChild = omFactory.createOMElement("ChildOne", null, (OMContainer)omElementTwo);
        OMElement omElementThree = omFactory.createOMElement("Bar", defaultNS1, (OMContainer)omElementTwo);
        omElementThree.declareDefaultNamespace("http://defaultNS1.org");
        OMNamespace omElementOneChildNS = omElementOneChild.getNamespace();
        OMNamespace omElementTwoChildNS = omElementTwoChild.getNamespace();
        OMElementTestBase.assertTrue((omElementOneChildNS == null || "".equals(omElementOneChildNS.getNamespaceURI()) ? 1 : 0) != 0);
        OMElementTestBase.assertTrue((omElementTwoChildNS == null || "".equals(omElementTwoChildNS.getNamespaceURI()) ? 1 : 0) != 0);
    }

    public void testChildReDeclaringParentsDefaultNSWithPrefix() throws Exception {
        OMFactory fac = this.omMetaFactory.getOMFactory();
        OMElement elem = fac.createOMElement("RequestSecurityToken", null);
        elem.declareDefaultNamespace("http://schemas.xmlsoap.org/ws/2005/02/trust");
        fac.createOMElement(new QName("TokenType"), (OMContainer)elem).setText("test");
        fac.createOMElement(new QName("RequestType"), (OMContainer)elem).setText("test1");
        fac.createOMElement(new QName("http://schemas.xmlsoap.org/ws/2005/02/trust", "Entropy", "wst"), (OMContainer)elem);
        String xml = elem.toString();
        OMXMLParserWrapper builder = OMXMLBuilderFactory.createOMBuilder((OMFactory)this.omMetaFactory.getOMFactory(), (InputStream)new ByteArrayInputStream(xml.getBytes()));
        builder.getDocumentElement().build();
        String assertText1 = "<wst:Entropy xmlns:wst=\"http://schemas.xmlsoap.org/ws/2005/02/trust\" />";
        String assertText2 = "<wst:Entropy xmlns:wst=\"http://schemas.xmlsoap.org/ws/2005/02/trust\"/>";
        String assertText3 = "<wst:Entropy xmlns:wst=\"http://schemas.xmlsoap.org/ws/2005/02/trust\"></wst:Entropy>";
        OMElementTestBase.assertTrue((xml.indexOf(assertText1) != -1 || xml.indexOf(assertText2) != -1 || xml.indexOf(assertText3) != -1 ? 1 : 0) != 0);
    }

    public void testChildReDeclaringGrandParentsDefaultNSWithPrefix() {
        OMFactory fac = this.omMetaFactory.getOMFactory();
        OMElement elem = fac.createOMElement("RequestSecurityToken", null);
        elem.declareDefaultNamespace("http://schemas.xmlsoap.org/ws/2005/02/trust");
        fac.createOMElement(new QName("TokenType"), (OMContainer)elem).setText("test");
        fac.createOMElement(new QName("RequestType"), (OMContainer)elem).setText("test1");
        OMElement entElem = fac.createOMElement(new QName("http://schemas.xmlsoap.org/ws/2005/02/trust", "Entropy", "wst"), (OMContainer)elem);
        OMElement binSecElem = fac.createOMElement(new QName("http://schemas.xmlsoap.org/ws/2005/02/trust", "Binarysecret", "wst"), (OMContainer)entElem);
        binSecElem.setText("secret value");
        String xml = elem.toString();
        OMElementTestBase.assertTrue((String)"Binarysecret element should have 'wst' ns prefix", (xml.indexOf("<wst:Binarysecret") != -1 ? 1 : 0) != 0);
    }
}

