/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.AbstractTestCase;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMSerializable;
import org.apache.axiom.om.impl.OMNavigator;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.impl.builder.StAXSOAPModelBuilder;

public class OMNavigatorTestBase
extends AbstractTestCase {
    private final OMMetaFactory omMetaFactory;
    private SOAPEnvelope envelope = null;
    private StAXSOAPModelBuilder builder;

    public OMNavigatorTestBase(OMMetaFactory omMetaFactory) {
        this.omMetaFactory = omMetaFactory;
    }

    protected void setUp() throws Exception {
        XMLStreamReader xmlStreamReader = StAXUtils.createXMLStreamReader((InputStream)OMNavigatorTestBase.getTestResource("soap/soapmessage1.xml"));
        this.builder = new StAXSOAPModelBuilder(this.omMetaFactory, xmlStreamReader, null);
        this.envelope = (SOAPEnvelope)this.builder.getDocumentElement();
    }

    protected void tearDown() throws Exception {
        this.builder.close();
    }

    public void testnavigatorFullyBuilt() throws Exception {
        OMNavigatorTestBase.assertNotNull((Object)this.envelope);
        XMLStreamWriter output = StAXUtils.createXMLStreamWriter((OutputStream)new ByteArrayOutputStream(), (String)"utf-8");
        this.envelope.serialize(output);
        OMNavigator navigator = new OMNavigator((OMSerializable)this.envelope);
        OMNode node = null;
        while (navigator.isNavigable()) {
            node = navigator.next();
            OMNavigatorTestBase.assertNotNull((Object)node);
        }
    }

    public void testnavigatorHalfBuilt() {
        OMNavigatorTestBase.assertNotNull((Object)this.envelope);
        OMNavigator navigator = new OMNavigator((OMSerializable)this.envelope);
        OMNode node = null;
        while (navigator.isNavigable()) {
            node = navigator.next();
            OMNavigatorTestBase.assertNotNull((Object)node);
        }
    }

    public void testnavigatorHalfBuiltStep() {
        OMNavigatorTestBase.assertNotNull((Object)this.envelope);
        OMNavigator navigator = new OMNavigator((OMSerializable)this.envelope);
        OMNode node = null;
        while (!navigator.isCompleted()) {
            if (navigator.isNavigable()) {
                node = navigator.next();
            } else {
                this.builder.next();
                navigator.step();
                node = navigator.next();
            }
            OMNavigatorTestBase.assertNotNull((Object)node);
        }
    }
}

