/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.serialize;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.axiom.om.AbstractTestCase;
import org.apache.axiom.om.impl.serialize.StreamingOMSerializer;
import org.apache.axiom.util.stax.dialect.StAXDialect;
import org.apache.axiom.util.stax.dialect.StAXDialectDetector;

public class StreamingOMSerializerTest
extends AbstractTestCase {
    private final String file;

    public StreamingOMSerializerTest(String name, String file) {
        super(name);
        this.file = file;
    }

    protected void runTest() throws Throwable {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        StAXDialect dialect = StAXDialectDetector.getDialect(inputFactory.getClass());
        inputFactory = dialect.normalize(inputFactory);
        inputFactory = dialect.enableCDataReporting(inputFactory);
        XMLOutputFactory outputFactory = dialect.normalize(XMLOutputFactory.newInstance());
        StreamingOMSerializer serializer = new StreamingOMSerializer();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        XMLStreamReader reader = inputFactory.createXMLStreamReader(StreamingOMSerializerTest.getTestResource(this.file));
        String encoding = reader.getEncoding();
        XMLStreamWriter writer = outputFactory.createXMLStreamWriter(out, encoding);
        writer.writeStartDocument(encoding, reader.getVersion());
        serializer.serialize(reader, writer, false);
        writer.writeEndDocument();
        writer.flush();
        this.assertXMLIdentical(this.compareXML(StreamingOMSerializerTest.toDocumentWithoutDTD(StreamingOMSerializerTest.getTestResource(this.file)), StreamingOMSerializerTest.toDocumentWithoutDTD(new ByteArrayInputStream(out.toByteArray()))), true);
    }

    public static TestSuite suite() throws Exception {
        TestSuite suite = new TestSuite();
        String[] files = StreamingOMSerializerTest.getConformanceTestFiles();
        for (int i = 0; i < files.length; ++i) {
            String file = files[i];
            int idx = file.lastIndexOf(47);
            String name = file.substring(idx + 1);
            suite.addTest((Test)new StreamingOMSerializerTest(name, file));
        }
        return suite;
    }
}

