/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.soap;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axiom.soap.SOAPHeaderTestBase;

public class SOAP12HeaderTestBase
extends SOAPHeaderTestBase {
    public SOAP12HeaderTestBase(OMMetaFactory omMetaFactory) {
        super(omMetaFactory, "http://www.w3.org/2003/05/soap-envelope", "http://www.w3.org/2003/05/soap-envelope/role/next");
    }

    public void testExamineMustUnderstandHeaderBlocks() {
        SOAPEnvelope soapEnvelope = this.soapFactory.createSOAPEnvelope();
        SOAPHeader soapHeader = this.soapFactory.createSOAPHeader(soapEnvelope);
        OMNamespace namespace = this.soapFactory.createOMNamespace("http://www.example.org", "test");
        soapHeader.addHeaderBlock("echoOk1", namespace).setRole("http://www.w3.org/2003/05/soap-envelope/role/ultimateReceiver");
        SOAPHeaderBlock headerBlock1 = soapHeader.addHeaderBlock("echoOk2", namespace);
        headerBlock1.setRole("http://www.w3.org/2003/05/soap-envelope/role/ultimateReceiver");
        headerBlock1.setMustUnderstand(true);
        soapHeader.addHeaderBlock("echoOk3", namespace).setMustUnderstand(true);
        Iterator iterator = soapHeader.examineMustUnderstandHeaderBlocks("http://www.w3.org/2003/05/soap-envelope/role/ultimateReceiver");
        iterator.hasNext();
        SOAPHeaderBlock headerBlock = (SOAPHeaderBlock)iterator.next();
        SOAP12HeaderTestBase.assertFalse((String)"SOAP Header Test : - examineMustUnderstandHeaderBlocks method returns empty iterator", (headerBlock == null ? 1 : 0) != 0);
        SOAP12HeaderTestBase.assertTrue((String)"SOAP Header Test : - HeaderBlock local name mismatch", (boolean)headerBlock.getLocalName().equals("echoOk2"));
        SOAP12HeaderTestBase.assertTrue((String)"SOAP Header Test : - HeaderBlock role value mismatch", (boolean)headerBlock.getRole().equals("http://www.w3.org/2003/05/soap-envelope/role/ultimateReceiver"));
        SOAP12HeaderTestBase.assertFalse((String)"SOAP Header Test : - examineMustUnderstandHeaderBlocks method returns an iterator with more than one object", (boolean)iterator.hasNext());
    }

    public void testExamineHeaderBlocksWithParser() {
        Iterator iterator = this.getTestMessage("message.xml").getHeader().examineHeaderBlocks("http://www.w3.org/2003/05/soap-envelope/role/ultimateReceiver");
        iterator.hasNext();
        SOAPHeaderBlock headerBlock1 = (SOAPHeaderBlock)iterator.next();
        SOAP12HeaderTestBase.assertTrue((String)"SOAP Header Test With Parser : - headerBlock1 localname mmismatch", (boolean)headerBlock1.getLocalName().equals("echoOk"));
        SOAP12HeaderTestBase.assertTrue((String)"SOAP Header Test With Parser : - headerBlock1 role value mmismatch", (boolean)headerBlock1.getRole().equals("http://www.w3.org/2003/05/soap-envelope/role/ultimateReceiver"));
        iterator.hasNext();
        SOAPHeaderBlock headerBlock2 = (SOAPHeaderBlock)iterator.next();
        SOAP12HeaderTestBase.assertTrue((String)"SOAP Header Test With Parser : - headerBlock2 localname mmismatch", (boolean)headerBlock2.getLocalName().equals("echoOk2"));
        SOAP12HeaderTestBase.assertTrue((String)"SOAP Header Test With Parser : - headerBlock2 role value mmismatch", (boolean)headerBlock2.getRole().equals("http://www.w3.org/2003/05/soap-envelope/role/ultimateReceiver"));
        SOAP12HeaderTestBase.assertFalse((String)"SOAP Header Test With Parser : - examineHeaderBlocks(String role) method returns an iterator with more than two objects", (boolean)iterator.hasNext());
    }

    public void testExamineMustUnderstandHeaderBlocksWithParser() {
        Iterator iterator = this.getTestMessage("message.xml").getHeader().examineMustUnderstandHeaderBlocks("http://www.w3.org/2003/05/soap-envelope/role/ultimateReceiver");
        iterator.hasNext();
        SOAPHeaderBlock headerBlock1 = (SOAPHeaderBlock)iterator.next();
        SOAP12HeaderTestBase.assertEquals((String)"SOAP Header Test With Parser : - headerBlock localname mmismatch", (String)headerBlock1.getLocalName(), (String)"echoOk");
        SOAP12HeaderTestBase.assertEquals((String)"SOAP Header Test With Parser : - headerBlock role value mmismatch", (String)headerBlock1.getRole(), (String)"http://www.w3.org/2003/05/soap-envelope/role/ultimateReceiver");
        iterator.hasNext();
        SOAPHeaderBlock headerBlock2 = (SOAPHeaderBlock)iterator.next();
        SOAP12HeaderTestBase.assertEquals((String)"SOAP Header Test With Parser : - headerBlock localname mmismatch", (String)headerBlock2.getLocalName(), (String)"echoOk2");
        SOAP12HeaderTestBase.assertEquals((String)"SOAP Header Test With Parser : - headerBlock role value mmismatch", (String)headerBlock1.getRole(), (String)"http://www.w3.org/2003/05/soap-envelope/role/ultimateReceiver");
        SOAP12HeaderTestBase.assertFalse((String)"SOAP Header Test With Parser : - examineMustUnderstandHeaderBlocks(String role) method returns an iterator with more than one objects", (boolean)iterator.hasNext());
    }

    public void testExamineAllHeaderBlocksWithParser() {
        Iterator iterator = this.getTestMessage("message.xml").getHeader().examineAllHeaderBlocks();
        SOAP12HeaderTestBase.assertTrue((boolean)iterator.hasNext());
        SOAPHeaderBlock headerBlock1 = (SOAPHeaderBlock)iterator.next();
        SOAP12HeaderTestBase.assertTrue((String)"SOAP Header Test With Parser : - headerBlock1 localname mmismatch", (boolean)headerBlock1.getLocalName().equals("echoOk"));
        SOAP12HeaderTestBase.assertTrue((boolean)iterator.hasNext());
        SOAPHeaderBlock headerBlock2 = (SOAPHeaderBlock)iterator.next();
        SOAP12HeaderTestBase.assertTrue((String)"SOAP Header Test With Parser : - headerBlock1 localname mmismatch", (boolean)headerBlock2.getLocalName().equals("echoOk1"));
        SOAP12HeaderTestBase.assertTrue((boolean)iterator.hasNext());
        SOAPHeaderBlock headerBlock3 = (SOAPHeaderBlock)iterator.next();
        SOAP12HeaderTestBase.assertTrue((String)"SOAP Header Test With Parser : - headerBlock1 localname mmismatch", (boolean)headerBlock3.getLocalName().equals("echoOk2"));
        SOAP12HeaderTestBase.assertFalse((String)"SOAP Header Test With Parser : - examineAllHeaderBlocks method returns an iterator with more than three objects", (boolean)iterator.hasNext());
    }

    public void testGetHeaderBlocksWithNSURIWithParser() {
        ArrayList arrayList = this.getTestMessage("message.xml").getHeader().getHeaderBlocksWithNSURI("http://example.org/ts-tests");
        SOAP12HeaderTestBase.assertTrue((String)"SOAP Header Test With Parser : - getHeaderBlocksWithNSURI returns an arrayList of incorrect size", (arrayList.size() == 1 ? 1 : 0) != 0);
        SOAP12HeaderTestBase.assertTrue((String)"SOAP Header Test With Parser : - headerBlock of given namespace uri, local name mismatch", (boolean)((SOAPHeaderBlock)arrayList.get(0)).getLocalName().equals("echoOk"));
        SOAP12HeaderTestBase.assertTrue((String)"SOAP Header Test With Parser : - headerBlock of given namespace uri, mismatch", (boolean)((SOAPHeaderBlock)arrayList.get(0)).getNamespace().getNamespaceURI().equals("http://example.org/ts-tests"));
    }
}

