/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.soap;

import java.io.InputStream;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.AbstractTestCase;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.impl.builder.StAXSOAPModelBuilder;

public abstract class SOAPTestCase
extends AbstractTestCase {
    protected OMMetaFactory omMetaFactory;
    protected SOAPFactory soap11Factory;
    protected SOAPFactory soap12Factory;
    protected OMFactory omFactory;
    protected SOAPEnvelope soap11Envelope;
    protected SOAPEnvelope soap12Envelope;
    protected SOAPEnvelope soap11EnvelopeWithParser;
    protected SOAPEnvelope soap12EnvelopeWithParser;
    protected static final String SOAP11_FILE_NAME = "soap/soap11/message.xml";
    protected static final String SOAP12_FILE_NAME = "soap/soap12/message.xml";

    public SOAPTestCase(OMMetaFactory omMetaFactory) {
        this.omMetaFactory = omMetaFactory;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.soap11Factory = this.omMetaFactory.getSOAP11Factory();
        this.soap12Factory = this.omMetaFactory.getSOAP12Factory();
        this.omFactory = this.omMetaFactory.getOMFactory();
        this.soap11Envelope = this.soap11Factory.createSOAPEnvelope();
        this.soap12Envelope = this.soap12Factory.createSOAPEnvelope();
        this.soap11EnvelopeWithParser = (SOAPEnvelope)this.getSOAPBuilder(SOAP11_FILE_NAME).getDocumentElement();
        this.soap12EnvelopeWithParser = (SOAPEnvelope)this.getSOAPBuilder(SOAP12_FILE_NAME).getDocumentElement();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.soap11Envelope.close(false);
        this.soap12Envelope.close(false);
        this.soap11EnvelopeWithParser.close(false);
        this.soap12EnvelopeWithParser.close(false);
    }

    protected StAXSOAPModelBuilder getSOAPBuilder(String fileName) throws Exception {
        XMLStreamReader parser = StAXUtils.createXMLStreamReader((InputStream)SOAPTestCase.getTestResource(fileName));
        return new StAXSOAPModelBuilder(this.omMetaFactory, parser, null);
    }
}

