/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.util.stax;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Random;
import javax.activation.DataHandler;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import junit.framework.TestCase;
import org.apache.axiom.om.util.StAXParserConfiguration;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.util.base64.Base64EncodingStringBufferOutputStream;
import org.apache.axiom.util.stax.XMLStreamReaderUtils;
import org.apache.axiom.util.stax.xop.XOPDecodingStreamReader;
import org.apache.commons.io.IOUtils;

public class XMLStreamReaderUtilsTest
extends TestCase {
    public void testGetDataHandlerFromElementWithZeroLengthNonDHR() throws Exception {
        this.testGetDataHandlerFromElementWithZeroLength(false);
    }

    public void testGetDataHandlerFromElementWithZeroLengthDHR() throws Exception {
        this.testGetDataHandlerFromElementWithZeroLength(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testGetDataHandlerFromElementWithZeroLength(boolean useDHR) throws Exception {
        XMLStreamReader reader = StAXUtils.createXMLStreamReader((Reader)new StringReader("<test/>"));
        if (useDHR) {
            reader = new XOPDecodingStreamReader(reader, null);
        }
        try {
            reader.next();
            XMLStreamReaderUtilsTest.assertTrue((boolean)reader.isStartElement());
            DataHandler dh = XMLStreamReaderUtils.getDataHandlerFromElement((XMLStreamReader)reader);
            XMLStreamReaderUtilsTest.assertTrue((boolean)reader.isEndElement());
            XMLStreamReaderUtilsTest.assertEquals((int)-1, (int)dh.getInputStream().read());
        }
        finally {
            reader.close();
        }
    }

    public void testGetDataHandlerFromElementWithUnexpectedContentNonDHR() throws Exception {
        this.testGetDataHandlerFromElementWithUnexpectedContent(false);
    }

    public void testGetDataHandlerFromElementWithUnexpectedContentDHR() throws Exception {
        this.testGetDataHandlerFromElementWithUnexpectedContent(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testGetDataHandlerFromElementWithUnexpectedContent(boolean useDHR) throws Exception {
        XMLStreamReader reader = StAXUtils.createXMLStreamReader((Reader)new StringReader("<test>\n<child/>\n</test>"));
        if (useDHR) {
            reader = new XOPDecodingStreamReader(reader, null);
        }
        try {
            reader.next();
            XMLStreamReaderUtilsTest.assertTrue((boolean)reader.isStartElement());
            try {
                XMLStreamReaderUtils.getDataHandlerFromElement((XMLStreamReader)reader);
                XMLStreamReaderUtilsTest.fail((String)"Expected XMLStreamException");
            }
            catch (XMLStreamException xMLStreamException) {
                // empty catch block
            }
        }
        finally {
            reader.close();
        }
    }

    public void testGetDataHandlerFromElementNonCoalescingNonDHR() throws Exception {
        this.testGetDataHandlerFromElementNonCoalescing(false);
    }

    public void testGetDataHandlerFromElementNonCoalescingDHR() throws Exception {
        this.testGetDataHandlerFromElementNonCoalescing(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testGetDataHandlerFromElementNonCoalescing(boolean useDHR) throws Exception {
        StringBuffer buffer = new StringBuffer("<test>");
        Base64EncodingStringBufferOutputStream out = new Base64EncodingStringBufferOutputStream(buffer);
        byte[] data = new byte[65536];
        new Random().nextBytes(data);
        out.write(data);
        out.complete();
        buffer.append("</test>");
        XMLStreamReader reader = StAXUtils.createXMLStreamReader((StAXParserConfiguration)StAXParserConfiguration.NON_COALESCING, (Reader)new StringReader(buffer.toString()));
        if (useDHR) {
            reader = new XOPDecodingStreamReader(reader, null);
        }
        try {
            reader.next();
            XMLStreamReaderUtilsTest.assertTrue((boolean)reader.isStartElement());
            DataHandler dh = XMLStreamReaderUtils.getDataHandlerFromElement((XMLStreamReader)reader);
            XMLStreamReaderUtilsTest.assertTrue((boolean)reader.isEndElement());
            XMLStreamReaderUtilsTest.assertTrue((boolean)Arrays.equals(data, IOUtils.toByteArray((InputStream)dh.getInputStream())));
        }
        finally {
            reader.close();
        }
    }

    public void testGetElementTextAsStream() throws Exception {
        XMLStreamReader reader = StAXUtils.createXMLStreamReader((Reader)new StringReader("<a>test</a>"));
        reader.next();
        Reader in = XMLStreamReaderUtils.getElementTextAsStream((XMLStreamReader)reader, (boolean)false);
        XMLStreamReaderUtilsTest.assertEquals((String)"test", (String)IOUtils.toString((Reader)in));
        XMLStreamReaderUtilsTest.assertEquals((int)2, (int)reader.getEventType());
    }

    public void testGetElementTextAsStreamWithAllowedNonTextChildren() throws Exception {
        XMLStreamReader reader = StAXUtils.createXMLStreamReader((Reader)new StringReader("<a>xxx<b>yyy</b>zzz</a>"));
        reader.next();
        Reader in = XMLStreamReaderUtils.getElementTextAsStream((XMLStreamReader)reader, (boolean)true);
        XMLStreamReaderUtilsTest.assertEquals((String)"xxxzzz", (String)IOUtils.toString((Reader)in));
    }

    public void testGetElementTextAsStreamWithForbiddenNonTextChildren() throws Exception {
        XMLStreamReader reader = StAXUtils.createXMLStreamReader((Reader)new StringReader("<a>xxx<b>yyy</b>zzz</a>"));
        reader.next();
        Reader in = XMLStreamReaderUtils.getElementTextAsStream((XMLStreamReader)reader, (boolean)false);
        try {
            IOUtils.toString((Reader)in);
            XMLStreamReaderUtilsTest.fail((String)"Expected exception");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

