/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.util.stax.xop;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.om.AbstractTestCase;
import org.apache.axiom.om.OMAttachmentAccessor;
import org.apache.axiom.om.impl.builder.OMAttachmentAccessorMimePartProvider;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.testutils.stax.XMLStreamReaderComparator;
import org.apache.axiom.util.base64.Base64Utils;
import org.apache.axiom.util.stax.xop.MimePartProvider;
import org.apache.axiom.util.stax.xop.XOPDecodingStreamReader;

public class XOPDecodingStreamReaderTest
extends AbstractTestCase {
    private XMLStreamReader getXOPDecodingStreamReader() throws Exception {
        Attachments attachments = new Attachments(XOPDecodingStreamReaderTest.getTestResource("mtom/MTOMAttachmentStream.bin"), "multipart/related; boundary=\"MIMEBoundaryurn:uuid:A3ADBAEE51A1A87B2A11443668160701\"; type=\"application/xop+xml\"; start=\"<0.urn:uuid:A3ADBAEE51A1A87B2A11443668160702@apache.org>\"; start-info=\"application/soap+xml\"; charset=UTF-8;action=\"mtomSample\"");
        return new XOPDecodingStreamReader(StAXUtils.createXMLStreamReader((InputStream)attachments.getSOAPPartInputStream()), (MimePartProvider)new OMAttachmentAccessorMimePartProvider((OMAttachmentAccessor)attachments));
    }

    public void testCompareToInlined() throws Exception {
        XMLStreamReader expected = StAXUtils.createXMLStreamReader((InputStream)XOPDecodingStreamReaderTest.getTestResource("mtom/MTOMAttachmentStream_inlined.xml"));
        XMLStreamReader actual = this.getXOPDecodingStreamReader();
        XMLStreamReaderComparator comparator = new XMLStreamReaderComparator(expected, actual);
        comparator.addPrefix("xop");
        comparator.compare();
        expected.close();
        actual.close();
    }

    public void testGetElementText() throws Exception {
        XMLStreamReader reader = this.getXOPDecodingStreamReader();
        while (!reader.isStartElement() || !reader.getLocalName().equals("image1")) {
            reader.next();
        }
        String base64 = reader.getElementText();
        byte[] data = Base64Utils.decode((String)base64);
        ImageIO.read(new ByteArrayInputStream(data));
        reader.close();
    }
}

