/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.attachments;

import java.io.File;
import org.apache.axiom.attachments.AttachmentCacheMonitor;
import org.apache.axiom.om.AbstractTestCase;

public class AttachmentCacheMonitorTest
extends AbstractTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCachedFilesExpired() throws Exception {
        long INTERVAL = 3000L;
        AttachmentCacheMonitor acm = AttachmentCacheMonitor.getAttachmentCacheMonitor();
        int previousTime = acm.getTimeout();
        try {
            acm.setTimeout(10);
            File aFile = new File("A");
            aFile.createNewFile();
            String aFileName = aFile.getCanonicalPath();
            acm.register(aFileName);
            Thread.sleep(INTERVAL);
            File bFile = new File("B");
            bFile.createNewFile();
            String bFileName = bFile.getCanonicalPath();
            acm.register(bFileName);
            Thread.sleep(INTERVAL);
            acm.access(aFileName);
            AttachmentCacheMonitorTest.assertTrue((String)"File A should still exist", (boolean)aFile.exists());
            Thread.sleep(INTERVAL);
            acm.access(bFileName);
            AttachmentCacheMonitorTest.assertTrue((String)"File B should still exist", (boolean)bFile.exists());
            Thread.sleep(INTERVAL);
            File cFile = new File("C");
            cFile.createNewFile();
            String cFileName = cFile.getCanonicalPath();
            acm.register(cFileName);
            acm.access(bFileName);
            Thread.sleep(INTERVAL);
            acm.checkForAgedFiles();
            AttachmentCacheMonitorTest.assertTrue((String)"File C should still exist", (boolean)cFile.exists());
            Thread.sleep(10L * INTERVAL);
            AttachmentCacheMonitorTest.assertFalse((String)"File A should no longer exist", (boolean)aFile.exists());
            AttachmentCacheMonitorTest.assertFalse((String)"File B should no longer exist", (boolean)bFile.exists());
            AttachmentCacheMonitorTest.assertFalse((String)"File C should no longer exist", (boolean)cFile.exists());
        }
        finally {
            acm.setTimeout(previousTime);
        }
    }
}

