/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.attachments;

import java.io.File;
import java.io.InputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.om.AbstractTestCase;
import org.apache.axiom.om.TestConstants;

public class PartOnFileTest
extends AbstractTestCase {
    File temp;

    public PartOnFileTest(String testName) {
        super(testName);
    }

    public void setUp() throws Exception {
        this.createTemporaryDirectory();
    }

    public void tearDown() throws Exception {
        this.deleteTemporaryDirectory();
    }

    public void testHeaderGetSet() throws Exception {
        InputStream inStream = PartOnFileTest.getTestResource(TestConstants.MTOM_MESSAGE.getName());
        Attachments attachments = new Attachments(inStream, TestConstants.MTOM_MESSAGE.getContentType(), true, this.temp.getPath(), "1");
        DataHandler dh = attachments.getDataHandler("1.urn:uuid:A3ADBAEE51A1A87B2A11443668160943@apache.org");
        PartOnFileTest.assertNotNull((Object)dh);
        DataSource ds = dh.getDataSource();
        PartOnFileTest.assertNotNull((Object)ds);
        if (!(ds instanceof FileDataSource)) {
            PartOnFileTest.fail((String)("Expected FileDataSource, but got " + ds.getClass().getName()));
        }
        PartOnFileTest.assertEquals((String)"image/jpeg", (String)dh.getContentType());
    }

    public void testGetAllheaders() throws Exception {
    }

    private void createTemporaryDirectory() throws Exception {
        this.temp = File.createTempFile("partOnFileTest", ".tmp");
        if (!this.temp.delete()) {
            PartOnFileTest.fail((String)("Cannot delete from temporary directory. File: " + this.temp.toURL()));
        }
        if (!this.temp.mkdir()) {
            PartOnFileTest.fail((String)"Cannot create a temporary location for part files");
        }
    }

    private void deleteTemporaryDirectory() throws Exception {
        String[] fileList = this.temp.list();
        for (int i = 0; i < fileList.length; ++i) {
            if (new File(this.temp, fileList[i]).delete()) continue;
            System.err.println("WARNING: temporary directory removal failed.");
        }
        if (!this.temp.delete()) {
            System.err.println("WARNING: temporary directory removal failed.");
        }
    }
}

