/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.attachments.impl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.util.ByteArrayDataSource;
import junit.framework.TestCase;
import org.apache.axiom.attachments.impl.BufferUtils;

public class BufferUtilsTest
extends TestCase {
    byte[] bytes;
    static final int MAX = 0x100000;

    protected void setUp() throws Exception {
        this.bytes = new byte[0x100000];
        for (int i = 0; i < 52428; ++i) {
            for (int j = 0; j < 20; ++j) {
                this.bytes[i * 20 + j] = (byte)j;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test() throws Exception {
        File file = File.createTempFile("bufferUtils", "tst");
        file.deleteOnExit();
        try {
            FileOutputStream fos = new FileOutputStream(file, true);
            for (int i = 0; i < 20; ++i) {
                ByteArrayInputStream bais = new ByteArrayInputStream(this.bytes);
                BufferUtils.inputStream2OutputStream((InputStream)bais, (OutputStream)fos);
                fos.flush();
            }
            ((OutputStream)fos).close();
            FileInputStream fis = new FileInputStream(file);
            byte[] buffer = new byte[20];
            fis.read(buffer);
            for (int i = 0; i < buffer.length; ++i) {
                BufferUtilsTest.assertTrue((buffer[i] == (byte)i ? 1 : 0) != 0);
            }
        }
        finally {
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDataSourceBackedDataHandlerExceedLimit() throws IOException {
        File file = File.createTempFile("bufferUtils", "tst");
        file.deleteOnExit();
        try {
            RandomAccessFile raf = new RandomAccessFile(file, "rw");
            try {
                raf.setLength(5000L);
            }
            finally {
                raf.close();
            }
            FileDataSource fds = new FileDataSource(file);
            DataHandler dh = new DataHandler((DataSource)fds);
            int unsupported = BufferUtils.doesDataHandlerExceedLimit((DataHandler)dh, (int)0);
            BufferUtilsTest.assertEquals((int)-1, (int)unsupported);
            int doesExceed = BufferUtils.doesDataHandlerExceedLimit((DataHandler)dh, (int)1000);
            BufferUtilsTest.assertEquals((int)1, (int)doesExceed);
            int doesNotExceed = BufferUtils.doesDataHandlerExceedLimit((DataHandler)dh, (int)100000);
            BufferUtilsTest.assertEquals((int)0, (int)doesNotExceed);
        }
        finally {
            file.delete();
        }
    }

    public void testObjectBackedDataHandlerExceedLimit() throws Exception {
        String str = "This is a test String";
        DataHandler dh = new DataHandler((Object)str, "text/plain");
        int unsupported = BufferUtils.doesDataHandlerExceedLimit((DataHandler)dh, (int)0);
        BufferUtilsTest.assertEquals((int)-1, (int)unsupported);
        int doesExceed = BufferUtils.doesDataHandlerExceedLimit((DataHandler)dh, (int)10);
        BufferUtilsTest.assertEquals((int)1, (int)doesExceed);
        int doesNotExceed = BufferUtils.doesDataHandlerExceedLimit((DataHandler)dh, (int)100);
        BufferUtilsTest.assertEquals((int)0, (int)doesNotExceed);
    }

    public void testByteArrayDataSourceBackedDataHandlerExceedLimit() throws Exception {
        String str = "This is a test String";
        byte[] b = str.getBytes();
        ByteArrayDataSource bads = new ByteArrayDataSource(b, "text/plain");
        DataHandler dh = new DataHandler((DataSource)bads);
        int unsupported = BufferUtils.doesDataHandlerExceedLimit((DataHandler)dh, (int)0);
        BufferUtilsTest.assertEquals((int)-1, (int)unsupported);
        int doesExceed = BufferUtils.doesDataHandlerExceedLimit((DataHandler)dh, (int)10);
        BufferUtilsTest.assertEquals((int)1, (int)doesExceed);
        int doesNotExceed = BufferUtils.doesDataHandlerExceedLimit((DataHandler)dh, (int)100);
        BufferUtilsTest.assertEquals((int)0, (int)doesNotExceed);
    }
}

