/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.mime;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Random;
import javax.activation.DataSource;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import junit.framework.TestCase;
import org.apache.axiom.attachments.ByteArrayDataSource;
import org.apache.axiom.mime.MultipartWriter;
import org.apache.axiom.mime.MultipartWriterFactory;
import org.apache.axiom.util.UIDGenerator;

public abstract class AbstractMultipartWriterTest
extends TestCase {
    private final MultipartWriterFactory factory;

    public AbstractMultipartWriterTest(MultipartWriterFactory factory) {
        this.factory = factory;
    }

    private void test(String contentTransferEncoding) throws Exception {
        Random random = new Random();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        MultipartWriter mpw = this.factory.createMultipartWriter((OutputStream)baos, UIDGenerator.generateMimeBoundary());
        byte[] content = new byte[8192];
        random.nextBytes(content);
        OutputStream partOutputStream = mpw.writePart("application/octet-stream", contentTransferEncoding, UIDGenerator.generateContentId());
        partOutputStream.write(content);
        partOutputStream.close();
        mpw.complete();
        MimeMultipart mp = new MimeMultipart((DataSource)new ByteArrayDataSource(baos.toByteArray()));
        AbstractMultipartWriterTest.assertEquals((int)1, (int)mp.getCount());
        MimeBodyPart bp = (MimeBodyPart)mp.getBodyPart(0);
        AbstractMultipartWriterTest.assertEquals((String)contentTransferEncoding, (String)bp.getHeader("Content-Transfer-Encoding")[0]);
        baos.reset();
        bp.getDataHandler().writeTo((OutputStream)baos);
        AbstractMultipartWriterTest.assertTrue((boolean)Arrays.equals(content, baos.toByteArray()));
    }

    public void testBinary() throws Exception {
        this.test("binary");
    }

    public void testBase64() throws Exception {
        this.test("base64");
    }
}

