/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om;

import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;

public class MIMEResource {
    private final String name;
    private final String contentType;

    public MIMEResource(String name, String contentType) {
        this.name = name;
        this.contentType = contentType;
    }

    public String getName() {
        return this.name;
    }

    public String getContentType() {
        return this.contentType;
    }

    private String getParameter(String name) {
        try {
            return new ContentType(this.contentType).getParameter(name);
        }
        catch (ParseException ex) {
            throw new Error(ex);
        }
    }

    public String getStart() {
        String start = this.getParameter("start");
        if (start.startsWith("<") && start.endsWith(">")) {
            return start.substring(1, start.length() - 1);
        }
        return start;
    }

    public String getBoundary() {
        return this.getParameter("boundary");
    }
}

