/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om;

import java.lang.reflect.Method;
import java.util.Arrays;

public class MethodSignature {
    private final String name;
    private final Class[] parameterTypes;

    public MethodSignature(String name, Class[] parameterTypes) {
        this.name = name;
        this.parameterTypes = parameterTypes;
    }

    public MethodSignature(Method method) {
        this.name = method.getName();
        this.parameterTypes = method.getParameterTypes();
    }

    public boolean equals(Object obj) {
        if (obj instanceof MethodSignature) {
            MethodSignature other = (MethodSignature)obj;
            return other.name.equals(this.name) && Arrays.equals(other.parameterTypes, this.parameterTypes);
        }
        return false;
    }

    public int hashCode() {
        int hashCode = this.name.hashCode();
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            hashCode = 31 * hashCode + this.parameterTypes[i].hashCode();
        }
        return hashCode;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.name);
        buffer.append('(');
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(this.parameterTypes[i].getName());
        }
        buffer.append(')');
        return buffer.toString();
    }
}

