/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import junit.framework.TestCase;
import org.apache.axiom.om.OMOutputFormat;

public class OMOutputFormatTest
extends TestCase {
    public void testAPI_getProperty() throws Exception {
        Method m = OMOutputFormat.class.getMethod("getProperty", String.class);
        OMOutputFormatTest.assertTrue((m != null ? 1 : 0) != 0);
        Class<?> returnType = m.getReturnType();
        OMOutputFormatTest.assertTrue((returnType == Object.class ? 1 : 0) != 0);
    }

    public void testAPI_setProperty() throws Exception {
        Method m = OMOutputFormat.class.getMethod("setProperty", String.class, Object.class);
        OMOutputFormatTest.assertTrue((m != null ? 1 : 0) != 0);
        Class<?> returnType = m.getReturnType();
        OMOutputFormatTest.assertTrue((returnType == Object.class ? 1 : 0) != 0);
    }

    public void testAPI_publicProperties() throws Exception {
        Field f = OMOutputFormat.class.getField("ACTION_PROPERTY");
        OMOutputFormatTest.assertTrue((f != null ? 1 : 0) != 0);
    }

    public void testGetContentTypeDefault() {
        OMOutputFormat format = new OMOutputFormat();
        String contentType = format.getContentType();
        OMOutputFormatTest.assertTrue((boolean)contentType.equals("text/xml"));
    }

    public void testGetContentTypeSOAP12() {
        OMOutputFormat format = new OMOutputFormat();
        format.setSOAP11(false);
        String contentType = format.getContentType();
        OMOutputFormatTest.assertTrue((boolean)contentType.equals("application/soap+xml"));
    }

    public void testGetContentTypeSOAP11MTOM() {
        OMOutputFormat format = new OMOutputFormat();
        format.setDoOptimize(true);
        String contentType = format.getContentType();
        OMOutputFormatTest.assertTrue((contentType.indexOf("text/xml") != -1 ? 1 : 0) != 0);
        OMOutputFormatTest.assertTrue((contentType.indexOf("application/xop+xml") != -1 ? 1 : 0) != 0);
        OMOutputFormatTest.assertTrue((contentType.indexOf("boundary=\"") != -1 ? 1 : 0) != 0);
    }

    public void testGetContentTypeSOAP11SWA() {
        OMOutputFormat format = new OMOutputFormat();
        format.setSOAP11(true);
        format.setDoingSWA(true);
        String contentType = format.getContentType();
        OMOutputFormatTest.assertTrue((contentType.indexOf("text/xml") >= 0 ? 1 : 0) != 0);
        OMOutputFormatTest.assertTrue((contentType.indexOf("multipart/related") >= 0 ? 1 : 0) != 0);
        OMOutputFormatTest.assertTrue((contentType.indexOf("application/xop+xml") < 0 ? 1 : 0) != 0);
        format = new OMOutputFormat();
        format.setSOAP11(true);
        format.setDoingSWA(true);
        format.setDoOptimize(true);
        contentType = format.getContentType();
        OMOutputFormatTest.assertTrue((contentType.indexOf("text/xml") >= 0 ? 1 : 0) != 0);
        OMOutputFormatTest.assertTrue((contentType.indexOf("multipart/related") >= 0 ? 1 : 0) != 0);
        OMOutputFormatTest.assertTrue((contentType.indexOf("application/xop+xml") < 0 ? 1 : 0) != 0);
        OMOutputFormatTest.assertTrue((contentType.indexOf("boundary=\"") != -1 ? 1 : 0) != 0);
    }

    public void testGetContentTypeSOAP12MTOM() {
        OMOutputFormat format = new OMOutputFormat();
        format.setDoOptimize(true);
        format.setSOAP11(false);
        String contentType = format.getContentType();
        OMOutputFormatTest.assertTrue((contentType.indexOf("application/soap+xml") != -1 ? 1 : 0) != 0);
        OMOutputFormatTest.assertTrue((contentType.indexOf("application/xop+xml") != -1 ? 1 : 0) != 0);
    }

    public void testGetContentTypeSOAP12MTOMWithAction() {
        OMOutputFormat format = new OMOutputFormat();
        format.setDoOptimize(true);
        format.setSOAP11(false);
        format.setProperty("action", (Object)"testSoapAction");
        String contentType = format.getContentType();
        OMOutputFormatTest.assertTrue((contentType.indexOf("application/soap+xml") != -1 ? 1 : 0) != 0);
        OMOutputFormatTest.assertTrue((contentType.indexOf("application/xop+xml") != -1 ? 1 : 0) != 0);
        OMOutputFormatTest.assertTrue((contentType.indexOf("action=\\\"testSoapAction\\\"") != -1 ? 1 : 0) != 0);
    }
}

