/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om;

import java.util.Iterator;
import junit.framework.TestCase;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OMTestUtils {
    public static void walkThrough(OMElement omEle) {
        Iterator it;
        Iterator attibIt = omEle.getAllAttributes();
        if (attibIt != null) {
            while (attibIt.hasNext()) {
                TestCase.assertNotNull((String)"once the has next is not null, the element should not be null", attibIt.next());
            }
        }
        if ((it = omEle.getChildren()) != null) {
            while (it.hasNext()) {
                OMNode ele = (OMNode)it.next();
                TestCase.assertNotNull((String)"once the has next is not null, the element should not be null", (Object)ele);
                if (!(ele instanceof OMElement)) continue;
                OMTestUtils.walkThrough((OMElement)ele);
            }
        }
    }

    public static void compare(Element ele, OMElement omele) throws Exception {
        if (ele == null && omele == null) {
            return;
        }
        if (ele != null && omele != null) {
            TestCase.assertEquals((String)"Element name not correct", (String)ele.getLocalName(), (String)omele.getLocalName());
            if (omele.getNamespace() != null) {
                TestCase.assertEquals((String)"Namespace URI not correct", (String)ele.getNamespaceURI(), (String)omele.getNamespace().getNamespaceURI());
            }
            NamedNodeMap map = ele.getAttributes();
            Iterator attIterator = omele.getAllAttributes();
            while (attIterator != null && attIterator.hasNext() && map == null) {
                OMAttribute omattribute = (OMAttribute)attIterator.next();
                Node node = map.getNamedItemNS(omattribute.getNamespace().getNamespaceURI(), omattribute.getLocalName());
                if (node.getNodeType() == 2) {
                    Attr attr = (Attr)node;
                    TestCase.assertEquals((String)attr.getValue(), (String)omattribute.getAttributeValue());
                    continue;
                }
                throw new OMException("return type is not a Attribute");
            }
            Iterator it = omele.getChildren();
            NodeList list = ele.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                if (node.getNodeType() != 1) continue;
                TestCase.assertTrue((boolean)it.hasNext());
                OMNode tempOmNode = (OMNode)it.next();
                while (tempOmNode.getType() != 1) {
                    TestCase.assertTrue((boolean)it.hasNext());
                    tempOmNode = (OMNode)it.next();
                }
                OMTestUtils.compare((Element)node, (OMElement)tempOmNode);
            }
        } else {
            throw new Exception("One is null");
        }
    }
}

