/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.jaxp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.xml.transform.Result;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.axiom.om.AbstractTestCase;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.impl.jaxp.OMResult;

public class StreamSourceToOMResultTestCase
extends AbstractTestCase {
    private final OMMetaFactory omMetaFactory;
    private final TransformerFactory transformerFactory;
    private final String file;

    private StreamSourceToOMResultTestCase(OMMetaFactory omMetaFactory, TransformerFactory transformerFactory, String name, String file) {
        super(name);
        this.omMetaFactory = omMetaFactory;
        this.transformerFactory = transformerFactory;
        this.file = file;
    }

    protected void runTest() throws Throwable {
        StreamSource source = new StreamSource(StreamSourceToOMResultTestCase.getTestResource(this.file));
        OMResult result = new OMResult(this.omMetaFactory.getOMFactory());
        this.transformerFactory.newTransformer().transform(source, (Result)result);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        result.getDocument().serialize((OutputStream)out);
        this.assertXMLIdentical(this.compareXML(StreamSourceToOMResultTestCase.toDocumentWithoutDTD(StreamSourceToOMResultTestCase.getTestResource(this.file)), StreamSourceToOMResultTestCase.toDocumentWithoutDTD(new ByteArrayInputStream(out.toByteArray()))), true);
    }

    public static TestSuite suite(OMMetaFactory omMetaFactory, TransformerFactory transformerFactory) throws Exception {
        TestSuite suite = new TestSuite();
        String[] files = StreamSourceToOMResultTestCase.getConformanceTestFiles();
        for (int i = 0; i < files.length; ++i) {
            String file = files[i];
            int idx = file.lastIndexOf(47);
            String name = file.substring(idx + 1);
            suite.addTest((Test)new StreamSourceToOMResultTestCase(omMetaFactory, transformerFactory, name, file));
        }
        return suite;
    }
}

