/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.soap;

import java.io.InputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.AbstractTestCase;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.impl.builder.StAXSOAPModelBuilder;

public class UnifiedSOAPTestCase
extends AbstractTestCase {
    protected static final String MESSAGE = "message.xml";
    protected static final String MESSAGE_WITHOUT_HEADER = "message_without_header.xml";
    protected final OMMetaFactory omMetaFactory;
    protected final String envelopeNamespaceURI;
    protected SOAPFactory soapFactory;

    public UnifiedSOAPTestCase(OMMetaFactory omMetaFactory, String envelopeNamespaceURI) {
        this.omMetaFactory = omMetaFactory;
        this.envelopeNamespaceURI = envelopeNamespaceURI;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.soapFactory = this.isSOAP11() ? this.omMetaFactory.getSOAP11Factory() : this.omMetaFactory.getSOAP12Factory();
    }

    protected boolean isSOAP11() {
        return this.envelopeNamespaceURI.equals("http://schemas.xmlsoap.org/soap/envelope/");
    }

    protected SOAPEnvelope getTestMessage(String name) {
        XMLStreamReader parser;
        String folder = this.isSOAP11() ? "soap11" : "soap12";
        try {
            parser = StAXUtils.createXMLStreamReader((InputStream)UnifiedSOAPTestCase.getTestResource("soap/" + folder + "/" + name));
        }
        catch (XMLStreamException ex) {
            UnifiedSOAPTestCase.fail((String)("Failed to get test message " + name + ": " + ex.getMessage()));
            return null;
        }
        return new StAXSOAPModelBuilder(parser, this.soapFactory, this.envelopeNamespaceURI).getSOAPEnvelope();
    }
}

